/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.asset.dto.QueryAssetListByIdsDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO;
import com.ifourthwall.dbm.tracker.bo.ReportingAssetOutputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingOutputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingPictureOutputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingQueryListInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerReportCountOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskSpaceInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TemporaryTaskWorksheetWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserInformationOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.config.TranslationBean;
import com.ifourthwall.dbm.tracker.config.TranslationConfig;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.ReportingRepository;
import com.ifourthwall.dbm.tracker.domain.WorksheetRepository;
import com.ifourthwall.dbm.tracker.dto.ReportingAssetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ReportingOutputDTO;
import com.ifourthwall.dbm.tracker.dto.SeerReportOutputDTO;
import com.ifourthwall.dbm.tracker.service.ReportingService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reportingServiceImpl")
public class ReportingServiceImpl
implements ReportingService {
    private static final Logger log = LoggerFactory.getLogger(ReportingServiceImpl.class);
    @Resource(name="reportingRepository")
    ReportingRepository reportingRepository;
    @Resource(name="worksheetRepository")
    WorksheetRepository worksheetRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Autowired
    private TranslationConfig translationConfig;

    public BaseResponse<Object> createReporting(IFWUser ifwUser, ReportingInsertInputBO reportingInsertInputBO) {
        if (StringUtils.isBlank((String)reportingInsertInputBO.getTenantId())) {
            reportingInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportingInsertInputBO.getTenantId());
        }
        reportingInsertInputBO.setCreateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)reportingInsertInputBO);
        this.reportingRepository.createReporting(reportingInsertInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<IFWPageInfo<ReportingOutputDTO>> getReportingList(IFWUser ifwUser, ReportingQueryListInputBO reportingQueryListInputBO) {
        IFWPageInfo pageInfo;
        List reportingOutputDTOList;
        if (StringUtils.isBlank((String)reportingQueryListInputBO.getTenantId())) {
            reportingQueryListInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportingQueryListInputBO.getTenantId());
        }
        IFWValidator.validate((Object)reportingQueryListInputBO);
        if (!StringUtils.isBlank((String)reportingQueryListInputBO.getCreateName())) {
            List userInformationOutputBOS = this.organizationRepository.queryListUserAndFindUser(reportingQueryListInputBO.getCreateName(), reportingQueryListInputBO.getTenantId(), reportingQueryListInputBO.getLanguageCode());
            if (userInformationOutputBOS != null && !userInformationOutputBOS.isEmpty()) {
                List collect = userInformationOutputBOS.stream().map(UserInformationOutputBO::getUserId).collect(Collectors.toList());
                reportingQueryListInputBO.setUserIdList(collect);
            } else {
                return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
        }
        if (StringUtils.isBlank((String)reportingQueryListInputBO.getSortByCreateTime())) {
            reportingQueryListInputBO.setSortByCreateTime("0");
        }
        if ((reportingOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)(pageInfo = this.reportingRepository.getReportingList(reportingQueryListInputBO)).getList(), ReportingOutputDTO.class)) != null && !reportingOutputDTOList.isEmpty()) {
            List spaceId;
            List projectSpaceList;
            List collect = reportingOutputDTOList.stream().map(ReportingOutputDTO::getCreateBy).distinct().collect(Collectors.toList());
            List userList = this.organizationRepository.queryUserDetailByUserId(collect, reportingQueryListInputBO.getTenantId(), reportingQueryListInputBO.getLanguageCode());
            if (userList != null && !userList.isEmpty()) {
                for (ReportingOutputDTO dto : reportingOutputDTOList) {
                    for (UserDeatilInfoOutputBO bo : userList) {
                        if (!StringUtils.isEquals((String)dto.getCreateBy(), (String)bo.getUserId())) continue;
                        dto.setCreateName(bo.getRealName());
                    }
                }
            }
            if ((projectSpaceList = this.configRepository.querySpaceNameBySpaceList(spaceId = reportingOutputDTOList.stream().map(ReportingOutputDTO::getReportingSpaceId).collect(Collectors.toList()), reportingQueryListInputBO.getTenantId(), reportingQueryListInputBO.getLanguageCode(), reportingQueryListInputBO.getProjectId())) != null && !projectSpaceList.isEmpty()) {
                for (ReportingOutputDTO dto : reportingOutputDTOList) {
                    for (ProjectSpacePathDTO spaceDTO : projectSpaceList) {
                        if (!StringUtils.isEquals((String)spaceDTO.getId(), (String)dto.getReportingSpaceId())) continue;
                        dto.setSpaceName(spaceDTO.getNameStr());
                    }
                }
            }
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setPageNum(pageInfo.getPageNum());
        result.setPageSize(pageInfo.getPageSize());
        result.setTotal(pageInfo.getTotal());
        result.setList(reportingOutputDTOList);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Workbook> exportReportList(IFWUser ifwUser, ReportingQueryListInputBO reportingQueryListInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)reportingQueryListInputBO.getTenantId())) {
                reportingQueryListInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportingQueryListInputBO.getTenantId());
            }
            log.info("exportReportList\u67e5\u8be2\u5165\u53c2{}", (Object)reportingQueryListInputBO);
            BaseResponse data = this.getReportingList(ifwUser, reportingQueryListInputBO);
            log.info("exportReportList\u67e5\u8be2\u6570\u636e{}", (Object)data);
            IFWPageInfo pageInfo = (IFWPageInfo)data.getData();
            List list = pageInfo.getList();
            TranslationBean translationBean = StringUtils.isEquals((String)reportingQueryListInputBO.getLanguageCode(), (String)"CN") ? (TranslationBean)this.translationConfig.getList().get(0) : (StringUtils.isEquals((String)reportingQueryListInputBO.getLanguageCode(), (String)"JP") ? (TranslationBean)this.translationConfig.getList().get(2) : (TranslationBean)this.translationConfig.getList().get(1));
            HSSFWorkbook sheets = new HSSFWorkbook();
            Sheet sheet = sheets.createSheet(translationBean.getReportingData());
            int rowNum = 0;
            int cellNum = 0;
            Row row = sheet.createRow(rowNum++);
            row.createCell(cellNum++).setCellValue(translationBean.getReportStatus());
            row.createCell(cellNum++).setCellValue(translationBean.getReporterName());
            row.createCell(cellNum++).setCellValue(translationBean.getReportContent());
            row.createCell(cellNum++).setCellValue(translationBean.getReportSpace());
            row.createCell(cellNum++).setCellValue(translationBean.getReportWorksheetNo());
            row.createCell(cellNum++).setCellValue(translationBean.getReportCreateTime());
            if (list != null && !list.isEmpty()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (ReportingOutputDTO dto : list) {
                    row = sheet.createRow(rowNum++);
                    cellNum = 0;
                    row.createCell(cellNum++).setCellValue(dto.getContentValue());
                    row.createCell(cellNum++).setCellValue(dto.getCreateName());
                    row.createCell(cellNum++).setCellValue(dto.getReportingContent());
                    row.createCell(cellNum++).setCellValue(dto.getSpaceName());
                    row.createCell(cellNum++).setCellValue(dto.getWorksheetNo() != null ? dto.getWorksheetNo() : "");
                    row.createCell(cellNum++).setCellValue(sdf.format(dto.getCreateTime()));
                }
            }
            sheet.setColumnWidth(0, 2000);
            sheet.autoSizeColumn(1);
            sheet.autoSizeColumn(2);
            sheet.autoSizeColumn(3);
            sheet.autoSizeColumn(4);
            sheet.autoSizeColumn(5);
            response = BaseResponseUtils.getSuccessResponse((Object)sheets, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<SeerReportOutputDTO> getReportingListForSeer(IFWUser ifwUser, ReportingQueryListInputBO reportingQueryListInputBO) {
        if (StringUtils.isBlank((String)reportingQueryListInputBO.getTenantId())) {
            reportingQueryListInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportingQueryListInputBO.getTenantId());
        }
        IFWValidator.validate((Object)reportingQueryListInputBO);
        SeerReportOutputDTO seerReportOutputDTO = new SeerReportOutputDTO();
        BaseResponse reportingListResponse = this.getReportingList(ifwUser, reportingQueryListInputBO);
        if (reportingListResponse.isFlag()) {
            seerReportOutputDTO.setData((IFWPageInfo)reportingListResponse.getData());
        }
        List reportingCountForSeer = this.reportingRepository.getReportingCountForSeer(reportingQueryListInputBO);
        int total = 0;
        int process = 0;
        if (reportingCountForSeer != null && !reportingCountForSeer.isEmpty()) {
            for (SeerReportCountOutputBO bo : reportingCountForSeer) {
                total += bo.getCount().intValue();
                if (StringUtils.isEquals((String)bo.getReportingStatusId(), (String)"0")) continue;
                process += bo.getCount().intValue();
            }
            seerReportOutputDTO.setTotalNum(Integer.valueOf(total));
            seerReportOutputDTO.setProcessNum(Integer.valueOf(process));
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)seerReportOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<ReportingOutputDTO> getReportingDetail(IFWUser ifwUser, ReportingDetailQueryInputBO reportingDetailQueryInputBO) {
        if (StringUtils.isBlank((String)reportingDetailQueryInputBO.getTenantId())) {
            reportingDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportingDetailQueryInputBO.getTenantId());
        }
        IFWValidator.validate((Object)reportingDetailQueryInputBO);
        ReportingOutputDTO reportingOutputDTO = new ReportingOutputDTO();
        ReportingOutputBO reportingOutputBO = this.reportingRepository.getReportingDetail(reportingDetailQueryInputBO);
        if (reportingOutputBO == null) {
            return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(reportingOutputBO.getCreateBy());
        List userList = this.organizationRepository.queryUserDetailByUserId(userIdList, reportingDetailQueryInputBO.getTenantId(), reportingDetailQueryInputBO.getLanguageCode());
        if (reportingOutputBO != null) {
            List pictureList;
            List spaceList;
            String newTaskId = reportingOutputBO.getNewTaskId();
            ArrayList<String> spaceIdList = new ArrayList<String>();
            if (!StringUtils.isBlank((String)newTaskId)) {
                WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = new WorksheetDetailQueryInputBO();
                worksheetDetailQueryInputBO.setProjectId(reportingDetailQueryInputBO.getProjectId());
                worksheetDetailQueryInputBO.setTenantId(reportingDetailQueryInputBO.getTenantId());
                worksheetDetailQueryInputBO.setTaskId(newTaskId);
                worksheetDetailQueryInputBO.setLanguageCode(reportingDetailQueryInputBO.getLanguageCode());
                TemporaryTaskWorksheetWrapOutputBO temporaryTaskWorksheetDetail = this.worksheetRepository.getTemporaryTaskWorksheetDetail(worksheetDetailQueryInputBO);
                reportingOutputBO.setTemporaryTaskWorksheetWrap(temporaryTaskWorksheetDetail);
                List taskSpaceList = temporaryTaskWorksheetDetail.getTaskSpaceList();
                if (!CollectionUtils.isEmpty((Collection)taskSpaceList)) {
                    spaceIdList.addAll(taskSpaceList.stream().map(TaskSpaceInsertInputBO::getSpaceId).distinct().collect(Collectors.toList()));
                }
            }
            if (!StringUtils.isBlank((String)reportingOutputBO.getReportingSpaceId()) && !spaceIdList.contains(reportingOutputBO.getReportingSpaceId())) {
                spaceIdList.add(reportingOutputBO.getReportingSpaceId());
            }
            if (!CollectionUtils.isEmpty(spaceIdList) && !CollectionUtils.isEmpty((Collection)(spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, reportingDetailQueryInputBO.getTenantId(), reportingDetailQueryInputBO.getLanguageCode(), reportingDetailQueryInputBO.getProjectId())))) {
                List taskSpaceList = null;
                TemporaryTaskWorksheetWrapOutputBO temporaryTaskWorksheetWrap = reportingOutputBO.getTemporaryTaskWorksheetWrap();
                if (temporaryTaskWorksheetWrap != null) {
                    taskSpaceList = temporaryTaskWorksheetWrap.getTaskSpaceList();
                }
                for (ProjectSpacePathDTO dto : spaceList) {
                    if (StringUtils.isEquals((String)dto.getId(), (String)reportingOutputBO.getReportingSpaceId())) {
                        reportingOutputBO.setSpaceName(dto.getNameStr());
                    }
                    if (CollectionUtils.isEmpty((Collection)taskSpaceList)) continue;
                    for (TaskSpaceInsertInputBO bo : taskSpaceList) {
                        if (!StringUtils.isEquals((String)dto.getId(), (String)bo.getSpaceId())) continue;
                        bo.setTaskSpaceDescription(dto.getNameStr());
                    }
                }
            }
            reportingOutputDTO = (ReportingOutputDTO)IFWBeanCopyUtil.map((Object)reportingOutputBO, ReportingOutputDTO.class);
            if (userList != null && !userList.isEmpty()) {
                UserDeatilInfoOutputBO userDeatilInfoOutputBO = (UserDeatilInfoOutputBO)userList.get(0);
                reportingOutputDTO.setCreateName(userDeatilInfoOutputBO.getRealName());
            }
            if ((pictureList = reportingOutputBO.getPictureList()) != null && !pictureList.isEmpty()) {
                List collect = pictureList.stream().map(ReportingPictureOutputBO::getPictureUrl).collect(Collectors.toList());
                reportingOutputDTO.setPicList(collect);
            }
            if (!CollectionUtils.isEmpty((Collection)reportingOutputBO.getReportingAssetList())) {
                List reportingAssetList = reportingOutputBO.getReportingAssetList();
                List collect = reportingAssetList.stream().map(ReportingAssetOutputBO::getAssetId).distinct().collect(Collectors.toList());
                List assetName = this.configRepository.getAssetName(reportingDetailQueryInputBO.getTenantId(), reportingDetailQueryInputBO.getProjectId(), reportingDetailQueryInputBO.getLanguageCode(), collect);
                if (!CollectionUtils.isEmpty((Collection)assetName)) {
                    for (ReportingAssetOutputBO bo : reportingAssetList) {
                        for (QueryAssetListByIdsDTO dto : assetName) {
                            if (!StringUtils.isEquals((String)bo.getAssetId(), (String)dto.getAssetId())) continue;
                            bo.setAssetName(dto.getAssetName());
                        }
                    }
                }
                reportingOutputDTO.setReportingAssetList(IFWBeanCopyUtil.mapAsList((Iterable)reportingAssetList, ReportingAssetOutputDTO.class));
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)reportingOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> updateReporting(IFWUser ifwUser, ReportingUpdateInputBO reportingUpdateInputBO) {
        if (StringUtils.isBlank((String)reportingUpdateInputBO.getTenantId())) {
            reportingUpdateInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)reportingUpdateInputBO.getTenantId());
        }
        reportingUpdateInputBO.setUpdateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)reportingUpdateInputBO);
        if (StringUtils.isEquals((String)reportingUpdateInputBO.getReportingStatusId(), (String)"3") && StringUtils.isBlank((String)reportingUpdateInputBO.getRefuseReason())) {
            throw new BizException(PlatformCodeEnum.REASON_OF_NOT_NEED_TO_RESOLVE_CANNOT_NULL.getDesc(), PlatformCodeEnum.REASON_OF_NOT_NEED_TO_RESOLVE_CANNOT_NULL.getCode());
        }
        this.reportingRepository.updateReporting(reportingUpdateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }
}

