/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.tracker.bo.SendPushParamBO;
import com.ifourthwall.dbm.tracker.domain.TrackerPushRepository;
import com.ifourthwall.dbm.tracker.service.TaskService;
import com.ifourthwall.kafka.DataHandler;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushDataHandler
implements DataHandler {
    private static final Logger log = LoggerFactory.getLogger(PushDataHandler.class);
    @Resource(name="taskServiceImpl")
    TaskService taskService;
    @Resource(name="trackerPushRepository")
    TrackerPushRepository trackerPushRepository;

    public void handle(String jsonStrData) {
        log.info("\u6d88\u606f\u63a8\u9001\u63a5\u53d7\u5230kafka\u4f20\u53c2\uff1a" + jsonStrData);
        try {
            SendPushParamBO sendPushParamBO = (SendPushParamBO)JSONUtils.jacksonFromJson((String)jsonStrData, SendPushParamBO.class);
            if (sendPushParamBO != null) {
                this.trackerPushRepository.sendMessageByTemplate(sendPushParamBO);
            }
        }
        catch (BizException e) {
            log.info("PushDataHandler:" + e.getMessage());
        }
    }

    public boolean judge(String topic) {
        return StringUtils.equals((CharSequence)topic, (CharSequence)"dbm_tracker_send_push");
    }
}

