/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO;
import com.ifourthwall.dbm.project.dto.QueryAllDeptDTO;
import com.ifourthwall.dbm.task.dto.SingleStringOutDTO;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CopyPlanTaskInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryOperateInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryOutputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryRelationInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryTagInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryTagQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskCategoryUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskDetailOutputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskMonthInfoQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.PlanTaskValidTimeListInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryResEmployeeOutputBO;
import com.ifourthwall.dbm.tracker.bo.QuerySubTaskExecutorInputBO;
import com.ifourthwall.dbm.tracker.bo.ServiceSupplierInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.ServiceSupplierQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ServiceSupplierUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.SingleStringOutBO;
import com.ifourthwall.dbm.tracker.bo.TaskExecutorInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskSpaceOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionRelationQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateWarpQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.UpdatePlanTaskSubInputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.PlanTaskCategoryRepository;
import com.ifourthwall.dbm.tracker.domain.TaskTemplateRepository;
import com.ifourthwall.dbm.tracker.dto.CreateCategoryTagResultOutputDTO;
import com.ifourthwall.dbm.tracker.dto.MaintenanceTagDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PlanTaskCategoryOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PlanTaskDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PlanTaskMonthInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PlanTaskValidTimeOutputDTO;
import com.ifourthwall.dbm.tracker.dto.PlanTaskValidWithWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryResEmployeeOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TaskWorksheetOutputDTO;
import com.ifourthwall.dbm.tracker.service.PlanTaskCategoryService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import com.ifourthwall.dbm.tracker.utils.DateUtils;
import com.ifourthwall.dbm.user.dto.QueryPositionNameResDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="planTaskCategoryServiceImpl")
public class PlanTaskCategoryServiceImpl
implements PlanTaskCategoryService {
    @Resource(name="planTaskCategoryRepository")
    PlanTaskCategoryRepository planTaskCategoryRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="taskTemplateRepository")
    TaskTemplateRepository taskTemplateRepository;
    @Value(value="${robot.system.position.id}")
    private String robotPositionId;
    @Value(value="${robot.system.id}")
    private String robotId;
    @Resource(name="configRepository")
    ConfigRepository configRepository;

    public BaseResponse<Object> createPlanTaskCategory(IFWUser ifwUser, PlanTaskCategoryInsertInputBO planTaskCategoryInsertInputBO) {
        BaseResponse response;
        try {
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            if (StringUtils.isBlank((String)planTaskCategoryInsertInputBO.getTenantId())) {
                planTaskCategoryInsertInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryInsertInputBO.getTenantId());
            }
            planTaskCategoryInsertInputBO.setCreateBy(ifwUser.getUserId());
            planTaskCategoryInsertInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            IFWValidator.validate((Object)planTaskCategoryInsertInputBO);
            this.planTaskCategoryRepository.createPlanTaskCategory(planTaskCategoryInsertInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> updatePlanTaskCategory(IFWUser ifwUser, PlanTaskCategoryUpdateInputBO planTaskCategoryUpdateInputBO) {
        BaseResponse response;
        try {
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            if (StringUtils.isBlank((String)planTaskCategoryUpdateInputBO.getTenantId())) {
                planTaskCategoryUpdateInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryUpdateInputBO.getTenantId());
            }
            planTaskCategoryUpdateInputBO.setUpdateBy(ifwUser.getUserId());
            planTaskCategoryUpdateInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            IFWValidator.validate((Object)planTaskCategoryUpdateInputBO);
            this.planTaskCategoryRepository.updatePlanTaskCategoryName(planTaskCategoryUpdateInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<PlanTaskCategoryOutputDTO>> getPlanTaskCategoryList(IFWUser ifwUser, PlanTaskCategoryListQueryInputBO planTaskCategoryListQueryInputBO) {
        List collect;
        List userList;
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryListQueryInputBO.getTenantId())) {
            planTaskCategoryListQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryListQueryInputBO.getTenantId());
        }
        planTaskCategoryListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)planTaskCategoryListQueryInputBO);
        List planTaskCategoryList = this.planTaskCategoryRepository.getPlanTaskCategoryList(planTaskCategoryListQueryInputBO);
        if (planTaskCategoryList != null && !planTaskCategoryList.isEmpty() && (userList = this.organizationRepository.queryUserDetailByUserId(collect = planTaskCategoryList.stream().map(PlanTaskCategoryOutputBO::getCreateBy).collect(Collectors.toList()), planTaskCategoryListQueryInputBO.getTenantId(), planTaskCategoryListQueryInputBO.getLanguageCode())) != null && !userList.isEmpty()) {
            for (PlanTaskCategoryOutputBO bo : planTaskCategoryList) {
                for (UserDeatilInfoOutputBO userBO : userList) {
                    if (!StringUtils.isEquals((String)bo.getCreateBy(), (String)userBO.getUserId())) continue;
                    bo.setCreateName(userBO.getRealName());
                }
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)planTaskCategoryList, PlanTaskCategoryOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<MaintenanceTagDetailOutputDTO>> getPlanTaskCategoryTagDetail(IFWUser ifwUser, PlanTaskCategoryListQueryInputBO planTaskCategoryListQueryInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryListQueryInputBO.getTenantId())) {
            planTaskCategoryListQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryListQueryInputBO.getTenantId());
        }
        planTaskCategoryListQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)planTaskCategoryListQueryInputBO);
        List planTaskCategoryTagDetail = this.planTaskCategoryRepository.getPlanTaskCategoryTagDetail(planTaskCategoryListQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)planTaskCategoryTagDetail, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> operatePlanTaskCategory(IFWUser ifwUser, PlanTaskCategoryOperateInputBO planTaskCategoryOperateInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryOperateInputBO.getTenantId())) {
            planTaskCategoryOperateInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryOperateInputBO.getTenantId());
        }
        planTaskCategoryOperateInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        planTaskCategoryOperateInputBO.setUpdateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)planTaskCategoryOperateInputBO);
        this.planTaskCategoryRepository.operatePlanTaskCategory(planTaskCategoryOperateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<CreateCategoryTagResultOutputDTO> createPlanTaskCategoryTag(IFWUser ifwUser, PlanTaskCategoryTagInsertInputBO planTaskCategoryTagInsertInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryTagInsertInputBO.getTenantId())) {
            planTaskCategoryTagInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryTagInsertInputBO.getTenantId());
        }
        planTaskCategoryTagInsertInputBO.setCreateBy(ifwUser.getUserId());
        planTaskCategoryTagInsertInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)planTaskCategoryTagInsertInputBO);
        CreateCategoryTagResultOutputDTO createCategoryTagResultOutputDTO = new CreateCategoryTagResultOutputDTO();
        SingleStringOutBO singleStringOutBO = this.planTaskCategoryRepository.createPlanTaskCategoryTag(planTaskCategoryTagInsertInputBO);
        createCategoryTagResultOutputDTO.setId(singleStringOutBO.getId());
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)createCategoryTagResultOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> deletePlanTaskCategoryTag(IFWUser ifwUser, PlanTaskCategoryTagQueryInputBO planTaskCategoryTagQueryInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryTagQueryInputBO.getTenantId())) {
            planTaskCategoryTagQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryTagQueryInputBO.getTenantId());
        }
        planTaskCategoryTagQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        planTaskCategoryTagQueryInputBO.setUpdateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)planTaskCategoryTagQueryInputBO);
        this.planTaskCategoryRepository.deletePlanTaskCategoryTag(planTaskCategoryTagQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<CreateCategoryTagResultOutputDTO> updatePlanTaskCategoryTag(IFWUser ifwUser, PlanTaskCategoryTagInsertInputBO planTaskCategoryTagInsertInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryTagInsertInputBO.getTenantId())) {
            planTaskCategoryTagInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryTagInsertInputBO.getTenantId());
        }
        planTaskCategoryTagInsertInputBO.setUpdateBy(ifwUser.getUserId());
        planTaskCategoryTagInsertInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)planTaskCategoryTagInsertInputBO);
        CreateCategoryTagResultOutputDTO createCategoryTagResultOutputDTO = new CreateCategoryTagResultOutputDTO();
        this.planTaskCategoryRepository.updatePlanTaskCategoryTag(planTaskCategoryTagInsertInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)createCategoryTagResultOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    private List<String> getPositionName(TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        List queryResEmployeeOutputBOList;
        List positionIdList;
        List taskTemplatePermissionList;
        ArrayList<String> positionNameList = new ArrayList<String>();
        TaskTemplateWrapOutputBO taskTemplateDetail = this.taskTemplateRepository.getTaskTemplateDetail(taskTemplateWarpQueryInputBO);
        if (!(taskTemplateDetail == null || (taskTemplatePermissionList = taskTemplateDetail.getTaskTemplatePermissionList()) == null || taskTemplatePermissionList.isEmpty() || (positionIdList = taskTemplatePermissionList.stream().filter(new /* Unavailable Anonymous Inner Class!! */).map(TaskTemplatePermissionOutputBO::getPermissionSubjectPositionId).collect(Collectors.toList())) == null || positionIdList.isEmpty() || (queryResEmployeeOutputBOList = this.organizationRepository.queryPositionNameList(positionIdList, taskTemplateWarpQueryInputBO.getTenantId(), taskTemplateWarpQueryInputBO.getLanguageCode())) == null || queryResEmployeeOutputBOList.isEmpty())) {
            positionNameList.addAll(queryResEmployeeOutputBOList.stream().map(QueryPositionNameResDTO::getPositionName).collect(Collectors.toList()));
        }
        return positionNameList;
    }

    public BaseResponse<List<PlanTaskMonthInfoOutputDTO>> getPlanTaskWeekInfo(PlanTaskMonthInfoQueryInputBO planTaskMonthInfoQueryInputBO) {
        IFWValidator.validate((Object)planTaskMonthInfoQueryInputBO);
        List planTaskWeekInfo = this.planTaskCategoryRepository.getPlanTaskWeekInfo(planTaskMonthInfoQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)planTaskWeekInfo, PlanTaskMonthInfoOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<SingleStringOutDTO> createPlanTaskCategorySubTask(IFWUser ifwUser, PlanTaskCategoryRelationInsertInputBO planTaskCategoryRelationInsertInputBO) {
        BaseResponse response;
        try {
            CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
            if (planTaskCategoryRelationInsertInputBO.getTaskWrap() == null || planTaskCategoryRelationInsertInputBO.getTaskWrap().getTask() == null) {
                throw new BizException(PlatformCodeEnum.TASK_DETAIL_CANNOT_BE_NULL.getDesc(), PlatformCodeEnum.TASK_DETAIL_CANNOT_BE_NULL.getCode());
            }
            planTaskCategoryRelationInsertInputBO.getTaskWrap().getTask().setCreateBy(this.robotId);
            planTaskCategoryRelationInsertInputBO.getTaskWrap().getTask().setCreateByPositionId(this.robotPositionId);
            planTaskCategoryRelationInsertInputBO.getTaskWrap().getTask().setTenantId(planTaskCategoryRelationInsertInputBO.getTenantId());
            if (StringUtils.isBlank((String)planTaskCategoryRelationInsertInputBO.getTenantId())) {
                planTaskCategoryRelationInsertInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryRelationInsertInputBO.getTenantId());
            }
            planTaskCategoryRelationInsertInputBO.setPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
            planTaskCategoryRelationInsertInputBO.getTaskWrap().getTask().setTaskSource("1");
            IFWValidator.validate((Object)planTaskCategoryRelationInsertInputBO);
            SingleStringOutDTO singleStringOutDTO = this.planTaskCategoryRepository.createPlanTaskCategorySubTask(planTaskCategoryRelationInsertInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)singleStringOutDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> updatePlanTaskValidTime(IFWUser ifwUser, PlanTaskValidTimeListInputBO planTaskValidTimeListInputBO) {
        if (StringUtils.isBlank((String)planTaskValidTimeListInputBO.getTenantId())) {
            planTaskValidTimeListInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskValidTimeListInputBO.getTenantId());
        }
        IFWValidator.validate((Object)planTaskValidTimeListInputBO);
        this.planTaskCategoryRepository.updatePlanTaskValidTime(planTaskValidTimeListInputBO.getPlanTaskValidTimeList());
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<PlanTaskDetailOutputDTO>> getPlanTaskDetailList(IFWUser ifwUser, PlanTaskCategoryDetailQueryInputBO planTaskCategoryDetailQueryInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)planTaskCategoryDetailQueryInputBO.getTenantId())) {
            planTaskCategoryDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)planTaskCategoryDetailQueryInputBO.getTenantId());
        }
        planTaskCategoryDetailQueryInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)planTaskCategoryDetailQueryInputBO);
        List planTaskDetailList = this.planTaskCategoryRepository.getPlanTaskDetailList(planTaskCategoryDetailQueryInputBO);
        ArrayList result = new ArrayList();
        if (planTaskDetailList != null && !planTaskDetailList.isEmpty()) {
            List spaceList;
            List spaceIdList;
            List userDeatilInfoOutputBOList;
            List userIdCollect = planTaskDetailList.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getTaskExecutorList())).map(PlanTaskDetailOutputBO::getTaskExecutorList).flatMap(Collection::stream).map(TaskExecutorInsertInputBO::getTaskExecutorUserId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(userIdCollect) && !CollectionUtils.isEmpty((Collection)(userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdCollect, planTaskCategoryDetailQueryInputBO.getTenantId(), planTaskCategoryDetailQueryInputBO.getLanguageCode())))) {
                for (Object planTaskDetailOutputBO : planTaskDetailList) {
                    List taskExecutorList = planTaskDetailOutputBO.getTaskExecutorList();
                    if (CollectionUtils.isEmpty((Collection)taskExecutorList)) continue;
                    for (Object taskExecutorInsertInputBO : taskExecutorList) {
                        for (Object bo : userDeatilInfoOutputBOList) {
                            if (!StringUtils.isEquals((String)taskExecutorInsertInputBO.getTaskExecutorUserId(), (String)bo.getUserId())) continue;
                            taskExecutorInsertInputBO.setName(bo.getRealName());
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(spaceIdList = planTaskDetailList.stream().map(PlanTaskDetailOutputBO::getTaskSpaceList).flatMap(Collection::stream).map(TaskSpaceOutputBO::getSpaceId).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty((Collection)(spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, planTaskCategoryDetailQueryInputBO.getTenantId(), planTaskCategoryDetailQueryInputBO.getLanguageCode(), planTaskCategoryDetailQueryInputBO.getProjectId())))) {
                for (PlanTaskDetailOutputBO bo : planTaskDetailList) {
                    List taskSpaceList = bo.getTaskSpaceList();
                    if (CollectionUtils.isEmpty((Collection)taskSpaceList)) continue;
                    for (TaskSpaceOutputBO spaceBO : taskSpaceList) {
                        for (ProjectSpacePathDTO dto : spaceList) {
                            if (!StringUtils.isEquals((String)spaceBO.getSpaceId(), (String)dto.getId())) continue;
                            spaceBO.setTaskSpaceDescription(dto.getNameStr());
                        }
                    }
                }
            }
            result.addAll(IFWBeanCopyUtil.mapAsList((Iterable)planTaskDetailList, PlanTaskDetailOutputDTO.class));
            for (PlanTaskDetailOutputDTO dto : result) {
                List planTaskValidTimeList = dto.getPlanTaskValidTimeList();
                List taskWorksheetList = dto.getTaskWorksheetList();
                ArrayList<PlanTaskValidWithWorksheetOutputDTO> planTaskValidWithWorksheetList = new ArrayList<PlanTaskValidWithWorksheetOutputDTO>();
                if (planTaskValidTimeList != null && !planTaskValidTimeList.isEmpty()) {
                    for (PlanTaskValidTimeOutputDTO timeDTO : planTaskValidTimeList) {
                        PlanTaskValidWithWorksheetOutputDTO planTaskValidWithWorksheetOutputDTO = new PlanTaskValidWithWorksheetOutputDTO();
                        planTaskValidWithWorksheetOutputDTO.setPlanTaskId(timeDTO.getPlanTaskId());
                        planTaskValidWithWorksheetOutputDTO.setValidTime(timeDTO.getValidTime());
                        if (taskWorksheetList != null && !taskWorksheetList.isEmpty()) {
                            for (TaskWorksheetOutputDTO worksheetDTO : taskWorksheetList) {
                                Date createTime = worksheetDTO.getCreateTime();
                                if (StringUtils.isEquals((String)"6", (String)worksheetDTO.getWorksheetStatusId())) {
                                    if (worksheetDTO.getExpireTime() != null) {
                                        if (worksheetDTO.getExpireTime().getTime() > worksheetDTO.getUpdateTime().getTime()) {
                                            worksheetDTO.setExpiredFlag("1");
                                        } else {
                                            worksheetDTO.setExpiredFlag("0");
                                        }
                                    } else {
                                        worksheetDTO.setExpiredFlag("1");
                                    }
                                } else if (worksheetDTO.getExpireTime() != null) {
                                    if (worksheetDTO.getExpireTime().getTime() > new Date().getTime()) {
                                        worksheetDTO.setExpiredFlag("1");
                                    } else {
                                        worksheetDTO.setExpiredFlag("0");
                                    }
                                } else {
                                    worksheetDTO.setExpiredFlag("1");
                                }
                                Date validTime = timeDTO.getValidTime();
                                if (createTime == null || validTime == null || DateUtils.getWeekNo((Date)createTime) != DateUtils.getWeekNo((Date)validTime)) continue;
                                planTaskValidWithWorksheetOutputDTO.setTaskWorksheetOutputDTO(worksheetDTO);
                            }
                        }
                        planTaskValidWithWorksheetList.add(planTaskValidWithWorksheetOutputDTO);
                    }
                }
                dto.setPlanTaskValidWithWorksheetList(planTaskValidWithWorksheetList);
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> insertServiceSupplier(IFWUser ifwUser, ServiceSupplierInsertInputBO serviceSupplierInsertInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)serviceSupplierInsertInputBO.getTenantId())) {
            serviceSupplierInsertInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)serviceSupplierInsertInputBO.getTenantId());
        }
        serviceSupplierInsertInputBO.setCreateBy(ifwUser.getUserId());
        IFWValidator.validate((Object)serviceSupplierInsertInputBO);
        this.planTaskCategoryRepository.insertServiceSupplier(serviceSupplierInsertInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> deleteServiceSupplier(IFWUser ifwUser, ServiceSupplierQueryInputBO serviceSupplierQueryInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)serviceSupplierQueryInputBO.getTenantId())) {
            serviceSupplierQueryInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)serviceSupplierQueryInputBO.getTenantId());
        }
        this.planTaskCategoryRepository.deleteServiceSupplier(serviceSupplierQueryInputBO);
        IFWValidator.validate((Object)serviceSupplierQueryInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> updateServiceSupplier(IFWUser ifwUser, ServiceSupplierUpdateInputBO serviceSupplierUpdateInputBO) {
        CheckAccessUtils.checkIFWUserPosition((IFWUser)ifwUser);
        if (StringUtils.isBlank((String)serviceSupplierUpdateInputBO.getTenantId())) {
            serviceSupplierUpdateInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)serviceSupplierUpdateInputBO.getTenantId());
        }
        serviceSupplierUpdateInputBO.setUpdateBy(ifwUser.getUserId());
        this.planTaskCategoryRepository.updateServiceSupplier(serviceSupplierUpdateInputBO);
        IFWValidator.validate((Object)serviceSupplierUpdateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> updatePlanTaskCategorySubTask(IFWUser ifwUser, UpdatePlanTaskSubInputBO updatePlanTaskSubInputBO) {
        if (StringUtils.isBlank((String)updatePlanTaskSubInputBO.getTenantId())) {
            updatePlanTaskSubInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)updatePlanTaskSubInputBO.getTenantId());
        }
        if (ifwUser.getPositions() == null || ifwUser.getPositions().isEmpty()) {
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getCode(), (String)PlatformCodeEnum.USER_POSITION_INFO_IS_NULL.getDesc());
        }
        updatePlanTaskSubInputBO.getTaskWrap().setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        updatePlanTaskSubInputBO.getTaskWrap().setLanguageCode(updatePlanTaskSubInputBO.getLanguageCode());
        updatePlanTaskSubInputBO.getTaskWrap().setTenantId(updatePlanTaskSubInputBO.getTenantId());
        if (updatePlanTaskSubInputBO.getTaskWrap().getTask() != null) {
            updatePlanTaskSubInputBO.getTaskWrap().getTask().setTenantId(updatePlanTaskSubInputBO.getTenantId());
            updatePlanTaskSubInputBO.getTaskWrap().getTask().setCreateBy(ifwUser.getUserId());
            updatePlanTaskSubInputBO.getTaskWrap().getTask().setTaskSource("1");
        }
        IFWValidator.validate((Object)updatePlanTaskSubInputBO);
        this.planTaskCategoryRepository.updatePlanTaskCategorySubTask(updatePlanTaskSubInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<List<QueryResEmployeeOutputDTO>> getPPMExecutorByTemplateId(IFWUser ifwUser, QuerySubTaskExecutorInputBO querySubTaskExecutorInputBO) {
        if (StringUtils.isBlank((String)querySubTaskExecutorInputBO.getTenantId())) {
            querySubTaskExecutorInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)querySubTaskExecutorInputBO.getTenantId());
        }
        List queryResEmployeeOutputDTOList = new ArrayList();
        ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
        contactQueryInputBO.setProjectId(querySubTaskExecutorInputBO.getProjectId());
        contactQueryInputBO.setLanguageCode(querySubTaskExecutorInputBO.getLanguageCode());
        contactQueryInputBO.setTenantId(querySubTaskExecutorInputBO.getTenantId());
        List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
        if (!CollectionUtils.isEmpty((Collection)deptInfoList)) {
            List queryResEmployeeOutputBOList;
            List collect;
            List taskTemplatePermissionList;
            List deptIdList = deptInfoList.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
            TaskTemplatePermissionRelationQueryInputBO taskTemplatePermissionRelationQueryInputBO = (TaskTemplatePermissionRelationQueryInputBO)IFWBeanCopyUtil.map((Object)querySubTaskExecutorInputBO, TaskTemplatePermissionRelationQueryInputBO.class);
            ArrayList<String> positionIdList = new ArrayList<String>();
            positionIdList.add(this.robotPositionId);
            taskTemplatePermissionRelationQueryInputBO.setPermissionSubjectPositionIdList(positionIdList);
            taskTemplatePermissionRelationQueryInputBO.setPermissionTaskOperationId("8");
            TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO = new TaskTemplateWarpQueryInputBO();
            taskTemplateWarpQueryInputBO.setLanguageCode(querySubTaskExecutorInputBO.getLanguageCode());
            taskTemplateWarpQueryInputBO.setTaskTemplateId(querySubTaskExecutorInputBO.getTaskTemplateId());
            taskTemplateWarpQueryInputBO.setProjectId(querySubTaskExecutorInputBO.getProjectId());
            taskTemplateWarpQueryInputBO.setTenantId(querySubTaskExecutorInputBO.getTenantId());
            TaskTemplateWrapOutputBO taskTemplateDetail = this.taskTemplateRepository.getTaskTemplateDetail(taskTemplateWarpQueryInputBO);
            if (!(taskTemplateDetail == null || (taskTemplatePermissionList = taskTemplateDetail.getTaskTemplatePermissionList()) == null || taskTemplatePermissionList.isEmpty() || CollectionUtils.isEmpty(collect = taskTemplatePermissionList.stream().filter(item -> StringUtils.isEquals((String)"8", (String)item.getPermissionTaskOperationId())).map(TaskTemplatePermissionOutputBO::getPermissionSubjectPositionId).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(queryResEmployeeOutputBOList = this.organizationRepository.queryPositionAndEmployeeByPositionId(collect, querySubTaskExecutorInputBO.getTenantId(), querySubTaskExecutorInputBO.getLanguageCode()))))) {
                ArrayList filterList = new ArrayList();
                queryResEmployeeOutputBOList.stream().filter(item -> deptIdList.contains(item.getDeptId())).collect(Collectors.groupingBy(item -> item.getUserId() + "#" + item.getPositionId())).forEach((BiConsumer<String, List<QueryResEmployeeOutputBO>>)new /* Unavailable Anonymous Inner Class!! */);
                queryResEmployeeOutputDTOList = IFWBeanCopyUtil.mapAsList(filterList, QueryResEmployeeOutputDTO.class);
            }
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(queryResEmployeeOutputDTOList, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<PlanTaskCategoryOutputDTO> copyPlanTask(IFWUser ifwUser, CopyPlanTaskInputBO copyPlanTaskInputBO) {
        if (StringUtils.isBlank((String)copyPlanTaskInputBO.getTenantId())) {
            copyPlanTaskInputBO.setTenantId(ifwUser.getTenantId());
        } else {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)copyPlanTaskInputBO.getTenantId());
        }
        copyPlanTaskInputBO.setCreateBy(ifwUser.getUserId());
        copyPlanTaskInputBO.setPermissionSubjectPositionIdList(ifwUser.getPositions().stream().map(IFWPosition::getPositionId).collect(Collectors.toList()));
        IFWValidator.validate((Object)copyPlanTaskInputBO);
        PlanTaskCategoryOutputDTO planTaskCategoryOutputDTO = this.planTaskCategoryRepository.copyPlanTask(copyPlanTaskInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse((Object)planTaskCategoryOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }
}

