/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ProjectQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryReqEmployeeInputBO;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.dto.DeptUserInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryAllDeptOutputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryResEmployeeOutputDTO;
import com.ifourthwall.dbm.tracker.service.OrganizationService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="organizationServiceImpl")
public class OrganizationServiceImpl
implements OrganizationService {
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;

    public BaseResponse<List<DeptUserInfoOutputDTO>> getContactList(IFWUser ifwUser, ContactQueryInputBO contactQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)contactQueryInputBO.getTenantId())) {
                contactQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)contactQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)contactQueryInputBO);
            List deptIdList = this.organizationRepository.getDeptIdList(contactQueryInputBO);
            List contactList = this.organizationRepository.getContactList(deptIdList, contactQueryInputBO.getLanguageCode(), contactQueryInputBO.getTenantId());
            response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)contactList, DeptUserInfoOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<QueryAllDeptOutputDTO>> getProjectList(IFWUser ifwUser, ProjectQueryInputBO projectQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)projectQueryInputBO.getTenantId())) {
                projectQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)projectQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)projectQueryInputBO);
            List projectList = this.organizationRepository.getProjectList(projectQueryInputBO);
            List queryAllDeptOutputDTOS = new ArrayList();
            if (projectList != null) {
                queryAllDeptOutputDTOS = IFWBeanCopyUtil.mapAsList((Iterable)projectList, QueryAllDeptOutputDTO.class);
            }
            response = BaseResponseUtils.getSuccessResponse(queryAllDeptOutputDTOS, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<QueryResEmployeeOutputDTO>> queryPositionAndEmployeeByPositionId(IFWUser ifwUser, QueryReqEmployeeInputBO queryReqEmployeeInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)queryReqEmployeeInputBO.getTenantId())) {
                queryReqEmployeeInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryReqEmployeeInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryReqEmployeeInputBO);
            List queryResEmployeeOutputBOList = this.organizationRepository.queryPositionAndEmployeeByPositionId(queryReqEmployeeInputBO.getPositionIdList(), queryReqEmployeeInputBO.getTenantId(), queryReqEmployeeInputBO.getLanguageCode());
            List queryResEmployeeOutputDTOList = new ArrayList();
            if (queryResEmployeeOutputBOList != null) {
                queryResEmployeeOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)queryResEmployeeOutputBOList, QueryResEmployeeOutputDTO.class);
            }
            response = BaseResponseUtils.getSuccessResponse(queryResEmployeeOutputDTOList, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

