/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.DocQueryBO;
import com.ifourthwall.dbm.tracker.bo.GroupQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.KnowledgeSearchInputBO;
import com.ifourthwall.dbm.tracker.bo.RepoQueryBO;
import com.ifourthwall.dbm.tracker.bo.YuQueUserInfoQueryBO;
import com.ifourthwall.dbm.tracker.domain.KnowledgeRepository;
import com.ifourthwall.dbm.tracker.service.KnowledgeService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="knowledgeServiceImpl")
public class KnowledgeServiceImpl
implements KnowledgeService {
    @Resource(name="knowledgeRepository")
    KnowledgeRepository knowledgeRepository;

    public BaseResponse getYuqueUserInfo(IFWUser ifwUser) {
        BaseResponse response;
        try {
            YuQueUserInfoQueryBO yuQueUserInfoQueryBO = new YuQueUserInfoQueryBO();
            yuQueUserInfoQueryBO.setAuthToken(ifwUser.getKnowledgeBaseToken());
            IFWValidator.validate((Object)yuQueUserInfoQueryBO);
            Object map = this.knowledgeRepository.queryYuQueUserInfo(yuQueUserInfoQueryBO);
            response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse search(IFWUser ifwUser, KnowledgeSearchInputBO knowledgeSearchInputBO) {
        BaseResponse response;
        try {
            knowledgeSearchInputBO.setRelated(true);
            knowledgeSearchInputBO.setToken(ifwUser.getKnowledgeBaseToken());
            IFWValidator.validate((Object)knowledgeSearchInputBO);
            Object map = this.knowledgeRepository.search(knowledgeSearchInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse getTeamInfo(IFWUser ifwUser, GroupQueryInputBO groupQueryInputBO) {
        BaseResponse response;
        try {
            groupQueryInputBO.setToken(ifwUser.getKnowledgeBaseToken());
            IFWValidator.validate((Object)groupQueryInputBO);
            Object map = this.knowledgeRepository.getTeamInfo(groupQueryInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse queryRepoList(IFWUser ifwUser, RepoQueryBO repoQueryBO) {
        BaseResponse response;
        try {
            repoQueryBO.setToken(ifwUser.getKnowledgeBaseToken());
            IFWValidator.validate((Object)repoQueryBO);
            Object map = this.knowledgeRepository.queryRepoList(repoQueryBO);
            response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse queryDocList(IFWUser ifwUser, DocQueryBO docQueryBO) {
        BaseResponse response;
        try {
            docQueryBO.setToken(ifwUser.getKnowledgeBaseToken());
            IFWValidator.validate((Object)docQueryBO);
            int pageIndex = docQueryBO.getPageIndex();
            int pageSize = docQueryBO.getPageSize();
            if (pageIndex > 1) {
                docQueryBO.setOffset((pageIndex - 1) * pageSize + 1);
            } else {
                docQueryBO.setOffset(0);
            }
            Object map = this.knowledgeRepository.queryDocList(docQueryBO);
            response = BaseResponseUtils.getSuccessResponse((Object)map, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

