/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.WaitFeedBackQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetBatchCreateInputBO;
import com.ifourthwall.dbm.tracker.domain.JobRepository;
import com.ifourthwall.dbm.tracker.domain.WorksheetRepository;
import com.ifourthwall.dbm.tracker.service.JobService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="jobServiceImpl")
public class JobServiceImpl
implements JobService {
    @Resource(name="jobRepository")
    JobRepository jobRepository;
    @Resource(name="worksheetRepository")
    WorksheetRepository worksheetRepository;
    @Autowired
    RedisTemplate redisTemplate;

    public BaseResponse<Object> createWorksheetBatch(IFWUser ifwUser, WorksheetBatchCreateInputBO worksheetBatchCreateInputBO) {
        if (!StringUtils.isEquals((String)"0", (String)ifwUser.getRoleType()) && !StringUtils.isEquals((String)worksheetBatchCreateInputBO.getTenantId(), (String)ifwUser.getTenantId())) {
            throw new BizException(PlatformCodeEnum.NO_POSITION_ACCESS.getDesc(), PlatformCodeEnum.NO_POSITION_ACCESS.getCode());
        }
        IFWValidator.validate((Object)worksheetBatchCreateInputBO);
        this.worksheetRepository.createWorksheetBatch(worksheetBatchCreateInputBO);
        String pattern = RedisKeyPrefixUtil.getTrackerQueryHomeDataPrefix((String)((StringUtils.isEmpty((String)worksheetBatchCreateInputBO.getProjectId()) ? "" : worksheetBatchCreateInputBO.getProjectId()) + "*"));
        Set keys = this.redisTemplate.keys((Object)pattern);
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            this.redisTemplate.delete((Collection)keys);
        }
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse<Object> createPlanTaskWorksheetBatch(IFWUser ifwUser, WorksheetBatchCreateInputBO worksheetBatchCreateInputBO) {
        if (!StringUtils.isEquals((String)"0", (String)ifwUser.getRoleType()) && !StringUtils.isEquals((String)worksheetBatchCreateInputBO.getTenantId(), (String)ifwUser.getTenantId())) {
            throw new BizException(PlatformCodeEnum.NO_POSITION_ACCESS.getDesc(), PlatformCodeEnum.NO_POSITION_ACCESS.getCode());
        }
        IFWValidator.validate((Object)worksheetBatchCreateInputBO);
        this.worksheetRepository.createPlanTaskWorksheetBatch(worksheetBatchCreateInputBO);
        BaseResponse response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        return response;
    }

    public BaseResponse autoFeedBckWorksheet(IFWUser ifwUser, WaitFeedBackQueryInputBO waitFeedBackQueryBO) {
        BaseResponse response;
        try {
            if (!StringUtils.isEquals((String)"0", (String)ifwUser.getRoleType()) && !StringUtils.isEquals((String)waitFeedBackQueryBO.getTenantId(), (String)ifwUser.getTenantId())) {
                throw new BizException(PlatformCodeEnum.NO_POSITION_ACCESS.getDesc(), PlatformCodeEnum.NO_POSITION_ACCESS.getCode());
            }
            IFWValidator.validate((Object)waitFeedBackQueryBO);
            this.jobRepository.autoFeedBckWorksheet(waitFeedBackQueryBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse sendDailyWorksheetMessage(IFWUser ifwUser) {
        BaseResponse response;
        try {
            this.jobRepository.sendDailyWorksheetMessage();
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

