/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.MeterInfoInputBO;
import com.ifourthwall.dbm.tracker.domain.GodzillaRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.service.GodzillaService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.user.dto.UserInformationDTO;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="godzillaServiceImpl")
public class GodzillaServiceImpl
implements GodzillaService {
    @Resource(name="godzillaRepository")
    GodzillaRepository godzillaRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;

    public BaseResponse pushDataToGodzilla(IFWUser ifwUser, MeterInfoInputBO meterInfoInputBO) {
        BaseResponse response;
        try {
            meterInfoInputBO.setUserId(ifwUser.getUserId());
            IFWValidator.validate((Object)meterInfoInputBO);
            UserInformationDTO userInformationDTO = this.organizationRepository.queryUser(ifwUser.getUserId(), meterInfoInputBO.getTenantId(), meterInfoInputBO.getLanguageCode());
            meterInfoInputBO.setUserName(userInformationDTO.getEmployeeName());
            response = this.godzillaRepository.sendMeterDataToGodzilla(meterInfoInputBO);
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public void closeConnection() {
    }
}

