/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.asset.dto.TrackerOfflineDTO;
import com.ifourthwall.dbm.tracker.bo.BindCheckpointQuInputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointQueryByMacInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckpointRelationByIdBO;
import com.ifourthwall.dbm.tracker.bo.QueryNoMacQuInputBO;
import com.ifourthwall.dbm.tracker.bo.ReplaceCPQuBasisInputBO;
import com.ifourthwall.dbm.tracker.bo.TrackerOfflineQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.UntieCheckpointQuInputBO;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.TaskRepository;
import com.ifourthwall.dbm.tracker.dto.ApkOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CheckpointQueryByMacOutputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryNoMacOutputDTO;
import com.ifourthwall.dbm.tracker.service.ConfigService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.dubbo.common.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="configServiceImpl")
public class ConfigServiceImpl
implements ConfigService {
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Resource(name="taskRepository")
    TaskRepository taskRepository;

    public BaseResponse<List<CheckpointQueryByMacOutputDTO>> getCheckpointListByMac(IFWUser ifwUser, CheckpointQueryByMacInputBO checkpointQueryByMacInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)checkpointQueryByMacInputBO.getTenantId())) {
                checkpointQueryByMacInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)checkpointQueryByMacInputBO.getTenantId());
            }
            IFWValidator.validate((Object)checkpointQueryByMacInputBO);
            List checkpointQueryByMacOutputBOList = this.configRepository.getCheckpointListByMac(checkpointQueryByMacInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)IFWBeanCopyUtil.mapAsList((Iterable)checkpointQueryByMacOutputBOList, CheckpointQueryByMacOutputDTO.class), (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> replaceCheckpoint(IFWUser ifwUser, ReplaceCPQuBasisInputBO replaceCPQuBasisInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)replaceCPQuBasisInputBO.getTenantId())) {
                replaceCPQuBasisInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)replaceCPQuBasisInputBO.getTenantId());
            }
            replaceCPQuBasisInputBO.setUpdateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)replaceCPQuBasisInputBO);
            Object object = this.configRepository.replaceCheckpoint(replaceCPQuBasisInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)object, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> untieCheckpoint(IFWUser ifwUser, UntieCheckpointQuInputBO untieCheckpointQuInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)untieCheckpointQuInputBO.getTenantId())) {
                untieCheckpointQuInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)untieCheckpointQuInputBO.getTenantId());
            }
            untieCheckpointQuInputBO.setUpdateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)untieCheckpointQuInputBO);
            List checkpointIdList = this.taskRepository.selectByCheckpointId((QueryCheckpointRelationByIdBO)IFWBeanCopyUtil.map((Object)untieCheckpointQuInputBO, QueryCheckpointRelationByIdBO.class));
            if (checkpointIdList != null && !checkpointIdList.isEmpty()) {
                List allCheckpointList = untieCheckpointQuInputBO.getCheckpointId();
                allCheckpointList.removeAll(checkpointIdList);
                if (allCheckpointList != null && !allCheckpointList.isEmpty()) {
                    untieCheckpointQuInputBO.setCheckpointId(allCheckpointList);
                    Object object = this.configRepository.untieCheckpoint(untieCheckpointQuInputBO);
                    response = BaseResponseUtils.getSuccessResponse((Object)object, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
                } else {
                    response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.POINTS_ARE_IN_TASK.getCode(), (String)PlatformCodeEnum.POINTS_ARE_IN_TASK.getDesc());
                }
            } else {
                Object object = this.configRepository.untieCheckpoint(untieCheckpointQuInputBO);
                response = BaseResponseUtils.getSuccessResponse((Object)object, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
            }
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Object> bindCheckpoint(IFWUser ifwUser, BindCheckpointQuInputBO bindCheckpointQuInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)bindCheckpointQuInputBO.getTenantId())) {
                bindCheckpointQuInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)bindCheckpointQuInputBO.getTenantId());
            }
            bindCheckpointQuInputBO.setUpdateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)bindCheckpointQuInputBO);
            Object object = this.configRepository.bindCheckpoint(bindCheckpointQuInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)object, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<QueryNoMacOutputDTO>> getUnbindCheckpoint(IFWUser ifwUser, QueryNoMacQuInputBO queryNoMacQuInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)queryNoMacQuInputBO.getTenantId())) {
                queryNoMacQuInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryNoMacQuInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryNoMacQuInputBO);
            IFWPageInfo data = this.configRepository.getUnbindCheckpoint(queryNoMacQuInputBO);
            IFWPageInfo result = new IFWPageInfo();
            if (data != null) {
                result.setTotal(data.getTotal());
                result.setPageNum(data.getPageNum());
                result.setPageSize(data.getPageSize());
                if (data.getList() != null) {
                    result.setList(IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), QueryNoMacOutputDTO.class));
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<TrackerOfflineDTO> getCheckpointOfflinePackage(IFWUser ifwUser, TrackerOfflineQueryInputBO trackerOfflineQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((String)trackerOfflineQueryInputBO.getTenantId())) {
                trackerOfflineQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)trackerOfflineQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)trackerOfflineQueryInputBO);
            TrackerOfflineDTO checkpointOfflinePackage = this.configRepository.getCheckpointOfflinePackage(trackerOfflineQueryInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)checkpointOfflinePackage, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<ApkOutputDTO> getLastApk() {
        BaseResponse response;
        try {
            ApkOutputDTO lastApk = this.configRepository.getLastApk();
            response = BaseResponseUtils.getSuccessResponse((Object)lastApk, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

