/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.CommonExpressionsInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCommonExpressionsInputBO;
import com.ifourthwall.dbm.tracker.bo.UpdateCommonExpressionsBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.domain.CommonExpressionsRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.dto.CommonExpressionsOutputDTO;
import com.ifourthwall.dbm.tracker.service.CommonExpressionsService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="commonExpressionsServiceImpl")
public class CommonExpressionsServiceImpl
implements CommonExpressionsService {
    @Resource(name="commonExpressionsRepository")
    CommonExpressionsRepository commonExpressionsRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;

    public BaseResponse<IFWPageInfo<CommonExpressionsOutputDTO>> getCommonExpressionsList(IFWUser ifwUser, QueryCommonExpressionsInputBO queryCommonExpressionsInputBO) {
        BaseResponse response;
        try {
            List list;
            List userIdList;
            List userDeatilInfoOutputBOList;
            if (StringUtils.isBlank((CharSequence)queryCommonExpressionsInputBO.getTenantId())) {
                queryCommonExpressionsInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCommonExpressionsInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCommonExpressionsInputBO);
            IFWPageInfo data = this.commonExpressionsRepository.selectCommonExpressionsByPage(queryCommonExpressionsInputBO);
            if (data != null && !CollectionUtils.isEmpty((Collection)data.getList()) && !CollectionUtils.isEmpty((Collection)(userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(userIdList = (list = data.getList()).stream().map(CommonExpressionsOutputDTO::getCreateBy).distinct().collect(Collectors.toList()), queryCommonExpressionsInputBO.getTenantId(), queryCommonExpressionsInputBO.getLanguageCode())))) {
                for (CommonExpressionsOutputDTO dto : list) {
                    for (UserDeatilInfoOutputBO bo : userDeatilInfoOutputBOList) {
                        if (!StringUtils.equals((CharSequence)dto.getCreateBy(), (CharSequence)bo.getUserId())) continue;
                        dto.setCreateName(bo.getRealName());
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)data, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse insertCommonExpressions(IFWUser ifwUser, CommonExpressionsInputBO commonExpressionsInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)commonExpressionsInputBO.getTenantId())) {
                commonExpressionsInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)commonExpressionsInputBO.getTenantId());
            }
            commonExpressionsInputBO.setCreateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)commonExpressionsInputBO);
            this.commonExpressionsRepository.insertCommonExpressions(commonExpressionsInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse updateCommonExpressions(IFWUser ifwUser, UpdateCommonExpressionsBO updateCommonExpressionsBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)updateCommonExpressionsBO.getTenantId())) {
                updateCommonExpressionsBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)updateCommonExpressionsBO.getTenantId());
            }
            updateCommonExpressionsBO.setUpdateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)updateCommonExpressionsBO);
            this.commonExpressionsRepository.updateByCommonExpressionsId(updateCommonExpressionsBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse deleteCommonExpressions(IFWUser ifwUser, UpdateCommonExpressionsBO updateCommonExpressionsBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)updateCommonExpressionsBO.getTenantId())) {
                updateCommonExpressionsBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)updateCommonExpressionsBO.getTenantId());
            }
            updateCommonExpressionsBO.setUpdateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)updateCommonExpressionsBO);
            this.commonExpressionsRepository.deleteByCommonExpressionsId(updateCommonExpressionsBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

