/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.CheckpointStatisticsQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.domain.CheckpointRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.dto.CheckpointPatrolDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CheckpointPatrolOutputDTO;
import com.ifourthwall.dbm.tracker.service.CheckpointService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="checkpointServiceImpl")
public class CheckpointServiceImpl
implements CheckpointService {
    @Resource(name="checkpointRepository")
    CheckpointRepository checkpointRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;

    public BaseResponse<IFWPageInfo<CheckpointPatrolOutputDTO>> checkpointStatistics(IFWUser ifwUser, CheckpointStatisticsQueryInputBO checkpointStatisticsQueryInputBO) {
        BaseResponse response;
        try {
            List userDeatilInfoOutputBOList;
            List collect;
            List list;
            if (StringUtils.isBlank((CharSequence)checkpointStatisticsQueryInputBO.getTenantId())) {
                checkpointStatisticsQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)checkpointStatisticsQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)checkpointStatisticsQueryInputBO);
            IFWPageInfo pageInfo = this.checkpointRepository.queryCheckpointStatistics(checkpointStatisticsQueryInputBO);
            if (!(pageInfo == null || CollectionUtils.isEmpty((Collection)(list = pageInfo.getList())) || CollectionUtils.isEmpty(collect = list.stream().filter(item -> !CollectionUtils.isEmpty((Collection)item.getCheckpointPatrolDetailList())).map(CheckpointPatrolOutputDTO::getCheckpointPatrolDetailList).flatMap(Collection::stream).map(CheckpointPatrolDetailOutputDTO::getCreateBy).filter(item -> !StringUtils.isBlank((CharSequence)item)).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(userDeatilInfoOutputBOList = this.organizationRepository.queryUserDetailByUserId(collect, checkpointStatisticsQueryInputBO.getTenantId(), checkpointStatisticsQueryInputBO.getLanguageCode()))))) {
                for (UserDeatilInfoOutputBO userDeatilInfoOutputBO : userDeatilInfoOutputBOList) {
                    for (CheckpointPatrolOutputDTO dto : list) {
                        List checkpointPatrolDetailList = dto.getCheckpointPatrolDetailList();
                        if (CollectionUtils.isEmpty((Collection)checkpointPatrolDetailList)) continue;
                        for (CheckpointPatrolDetailOutputDTO checkpointPatrolDetailDTO : checkpointPatrolDetailList) {
                            if (!StringUtils.equals((CharSequence)userDeatilInfoOutputBO.getUserId(), (CharSequence)checkpointPatrolDetailDTO.getCreateBy())) continue;
                            checkpointPatrolDetailDTO.setCreateName(userDeatilInfoOutputBO.getRealName());
                        }
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

