/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWPosition;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.cache.RedisKeyPrefixUtil;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.project.dto.QueryAllDeptDTO;
import com.ifourthwall.dbm.task.dto.CargoStockInDetailDTO;
import com.ifourthwall.dbm.task.dto.CargoStockInRecordDTO;
import com.ifourthwall.dbm.task.dto.CargoStockOutDetailDTO;
import com.ifourthwall.dbm.task.dto.CargoStockOutRecordDTO;
import com.ifourthwall.dbm.task.dto.StockInWrapDTO;
import com.ifourthwall.dbm.task.dto.StockOutWrapDTO;
import com.ifourthwall.dbm.tracker.bo.ApprovalResultOutputDTO;
import com.ifourthwall.dbm.tracker.bo.CargoCommonStatisticsQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoStockOutCheckInputBO;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoInfoBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStatisticInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStockInRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStockOutRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryLowSafeStockInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockByCargoInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockInDetailBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutDetailBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutInfoDetailInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.StockInWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.StockOutWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.UpdateCargoInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.config.RedisLockHelper;
import com.ifourthwall.dbm.tracker.config.TranslationBean;
import com.ifourthwall.dbm.tracker.config.TranslationConfig;
import com.ifourthwall.dbm.tracker.domain.CargoRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.dto.CargoCommonStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockInInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockInRecordOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutByDayOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutInfoByIdOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutRecordOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ImportCargoInputDTO;
import com.ifourthwall.dbm.tracker.dto.StockInWrapOutputDTO;
import com.ifourthwall.dbm.tracker.dto.StockOutWrapOutputDTO;
import com.ifourthwall.dbm.tracker.service.CargoService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import com.ifourthwall.dbm.tracker.utils.DataUtils;
import com.ifourthwall.dbm.tracker.utils.DateUtils;
import com.ifourthwall.dbm.tracker.utils.ExcelUtils;
import com.ifourthwall.dbm.user.dto.QuPositionNameReqDTO;
import com.ifourthwall.dbm.user.dto.UserInformationDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="cargoServiceImpl")
public class CargoServiceImpl
implements CargoService {
    @Resource(name="cargoRepository")
    CargoRepository cargoRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Autowired
    RedisLockHelper redisLockHelper;
    @Autowired
    private TranslationConfig translationConfig;
    private static final int TIMEOUT = 10000;

    public BaseResponse createCargoModel(IFWUser ifwUser, CargoInfoInputBO cargoInfoInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)cargoInfoInputBO.getTenantId())) {
                cargoInfoInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)cargoInfoInputBO.getTenantId());
            }
            cargoInfoInputBO.setCreateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)cargoInfoInputBO);
            this.cargoRepository.createCargoModel(cargoInfoInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse updateCargoModel(IFWUser ifwUser, UpdateCargoInfoInputBO updateCargoInfoInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)updateCargoInfoInputBO.getTenantId())) {
                updateCargoInfoInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)updateCargoInfoInputBO.getTenantId());
            }
            updateCargoInfoInputBO.setUpdateBy(ifwUser.getUserId());
            IFWValidator.validate((Object)updateCargoInfoInputBO);
            this.cargoRepository.updateCargoModel(updateCargoInfoInputBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse importCargoModel(IFWUser ifwUser, MultipartFile file, ImportCargoInputDTO importCargoInputDTO) {
        BaseResponse response;
        try {
            IFWValidator.validate((Object)importCargoInputDTO);
            List list = ExcelUtils.importExcel((MultipartFile)file);
            ArrayList<CargoInfoInputBO> cargoInfoList = new ArrayList<CargoInfoInputBO>();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (Object[] obj : list) {
                    CargoInfoInputBO cargoInfoInputBO = new CargoInfoInputBO();
                    String cargoName = obj[0].toString();
                    String cargoSpecification = obj[1].toString();
                    String cargoUnit = obj[2].toString();
                    String cargoSafeStockStr = obj[3].toString();
                    BigDecimal cargoSafeStock = cargoSafeStockStr != null ? new BigDecimal(cargoSafeStockStr) : BigDecimal.ZERO;
                    String cargoSupplier = obj[4].toString();
                    String remark = null;
                    if (obj.length >= 6) {
                        remark = obj[5].toString();
                    }
                    cargoInfoInputBO.setCargoName(cargoName);
                    cargoInfoInputBO.setCargoSpecification(cargoSpecification);
                    cargoInfoInputBO.setCargoUnit(cargoUnit);
                    cargoInfoInputBO.setCargoSafeStock(cargoSafeStock);
                    cargoInfoInputBO.setCargoSupplier(cargoSupplier);
                    cargoInfoInputBO.setRemark(remark);
                    cargoInfoInputBO.setTenantId(importCargoInputDTO.getTenantId());
                    cargoInfoInputBO.setProjectId(importCargoInputDTO.getProjectId());
                    cargoInfoList.add(cargoInfoInputBO);
                }
            }
            if (!CollectionUtils.isEmpty(cargoInfoList)) {
                cargoInfoList.forEach(new /* Unavailable Anonymous Inner Class!! */);
                this.cargoRepository.importCargoModel(cargoInfoList);
            }
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<CargoInfoOutputDTO>> selectByCargoPage(IFWUser ifwUser, QueryCargoInfoBO queryCargoInfoBO) {
        BaseResponse response;
        try {
            List list;
            List collect;
            List userInfoList;
            if (StringUtils.isBlank((CharSequence)queryCargoInfoBO.getTenantId())) {
                queryCargoInfoBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoInfoBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCargoInfoBO);
            IFWPageInfo pageInfo = this.cargoRepository.selectByCargoPage(queryCargoInfoBO);
            if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList()) && !CollectionUtils.isEmpty((Collection)(userInfoList = this.organizationRepository.queryUserDetailByUserId(collect = (list = pageInfo.getList()).stream().map(CargoInfoOutputDTO::getCreateBy).distinct().collect(Collectors.toList()), queryCargoInfoBO.getTenantId(), queryCargoInfoBO.getLanguageCode())))) {
                for (CargoInfoOutputDTO dto : list) {
                    for (UserDeatilInfoOutputBO bo : userInfoList) {
                        if (!StringUtils.equals((CharSequence)dto.getCreateBy(), (CharSequence)bo.getUserId())) continue;
                        dto.setCreateName(bo.getRealName());
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public Workbook downloadCardModel(IFWUser ifwUser, BaseReqDTO baseReqDTO) {
        HSSFWorkbook sheets = new HSSFWorkbook();
        TranslationBean translationBean = StringUtils.equals((CharSequence)baseReqDTO.getLanguageCode(), (CharSequence)"CN") ? (TranslationBean)this.translationConfig.getList().get(0) : (StringUtils.equals((CharSequence)baseReqDTO.getLanguageCode(), (CharSequence)"JP") ? (TranslationBean)this.translationConfig.getList().get(2) : (TranslationBean)this.translationConfig.getList().get(1));
        Sheet sheet = sheets.createSheet(translationBean.getCargoModel());
        int rowNum = 0;
        int cellNum = 0;
        Row row = sheet.createRow(rowNum++);
        CellStyle style = sheets.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        Cell cellName = row.createCell(cellNum++);
        cellName.setCellValue((RichTextString)this.createCellText(translationBean.getCargoName(), (Workbook)sheets));
        cellName.setCellStyle(style);
        Cell cellNo = row.createCell(cellNum++);
        cellNo.setCellValue((RichTextString)this.createCellText(translationBean.getCargoSpecification(), (Workbook)sheets));
        cellNo.setCellStyle(style);
        Cell cellPhone = row.createCell(cellNum++);
        cellPhone.setCellValue((RichTextString)this.createCellText(translationBean.getCargoUnit(), (Workbook)sheets));
        cellPhone.setCellStyle(style);
        Cell safeStock = row.createCell(cellNum++);
        safeStock.setCellValue((RichTextString)this.createCellText(translationBean.getCargoSafeStock(), (Workbook)sheets));
        safeStock.setCellStyle(style);
        Cell supplier = row.createCell(cellNum++);
        supplier.setCellValue((RichTextString)this.createCellText(translationBean.getCargoSupplier(), (Workbook)sheets));
        supplier.setCellStyle(style);
        row.createCell(cellNum++).setCellValue(translationBean.getCargoRemark());
        return sheets;
    }

    private HSSFRichTextString createCellText(String value, Workbook workbook) {
        HSSFRichTextString str = new HSSFRichTextString("*" + value);
        Font font3 = workbook.createFont();
        font3.setBold(true);
        font3.setCharSet((byte)0);
        font3.setColor((short)10);
        str.applyFont(0, 1, font3);
        return str;
    }

    public BaseResponse insertStockInRecord(IFWUser ifwUser, StockInWrapInputBO stockInWrapInputBO) {
        BaseResponse response;
        long time = System.currentTimeMillis() + 10000L;
        if (!this.redisLockHelper.lock(RedisKeyPrefixUtil.getTrackerCargoStockIn((String)stockInWrapInputBO.getProjectId()), String.valueOf(time))) {
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.TRY_AGAIN_LATER.getCode(), (String)PlatformCodeEnum.TRY_AGAIN_LATER.getDesc());
        }
        try {
            if (StringUtils.isBlank((CharSequence)stockInWrapInputBO.getTenantId())) {
                stockInWrapInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)stockInWrapInputBO.getTenantId());
            }
            IFWValidator.validate((Object)stockInWrapInputBO);
            StockInWrapDTO stockInWrapDTO = new StockInWrapDTO();
            CargoStockInRecordDTO cargoStockInRecordDTO = new CargoStockInRecordDTO();
            cargoStockInRecordDTO.setCreateBy(ifwUser.getUserId());
            cargoStockInRecordDTO.setProjectId(stockInWrapInputBO.getProjectId());
            cargoStockInRecordDTO.setRemark(stockInWrapInputBO.getRemark());
            cargoStockInRecordDTO.setTenantId(stockInWrapInputBO.getTenantId());
            stockInWrapDTO.setCargoStockInRecord(cargoStockInRecordDTO);
            stockInWrapDTO.setCargoStockInDetailList(IFWBeanCopyUtil.mapAsList((Iterable)stockInWrapInputBO.getCargoStockInDetailList(), CargoStockInDetailDTO.class));
            this.cargoRepository.insertStockInRecord(stockInWrapDTO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        this.redisLockHelper.unlock(RedisKeyPrefixUtil.getTrackerCargoStockIn((String)stockInWrapInputBO.getProjectId()), String.valueOf(time));
        return response;
    }

    public BaseResponse insertStockOutRecord(IFWUser ifwUser, StockOutWrapInputBO stockOutWrapInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)stockOutWrapInputBO.getTenantId())) {
                stockOutWrapInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)stockOutWrapInputBO.getTenantId());
            }
            IFWValidator.validate((Object)stockOutWrapInputBO);
            StockOutWrapDTO stockOutWrapDTO = new StockOutWrapDTO();
            CargoStockOutRecordDTO cargoStockOutRecordDTO = new CargoStockOutRecordDTO();
            cargoStockOutRecordDTO.setCreateBy(ifwUser.getUserId());
            cargoStockOutRecordDTO.setProjectId(stockOutWrapInputBO.getProjectId());
            cargoStockOutRecordDTO.setRemark(stockOutWrapInputBO.getRemark());
            cargoStockOutRecordDTO.setTenantId(stockOutWrapInputBO.getTenantId());
            cargoStockOutRecordDTO.setTaskWorksheetId(stockOutWrapInputBO.getTaskWorksheetId());
            stockOutWrapDTO.setCargoStockOutRecord(cargoStockOutRecordDTO);
            stockOutWrapDTO.setCargoStockOutDetailList(IFWBeanCopyUtil.mapAsList((Iterable)stockOutWrapInputBO.getCargoStockOutDetailList(), CargoStockOutDetailDTO.class));
            if (!StringUtils.isBlank((CharSequence)stockOutWrapInputBO.getTaskWorksheetId())) {
                List positions = ifwUser.getPositions();
                if (CollectionUtils.isEmpty((Collection)positions)) {
                    return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.POSITION_ID_LIST_CANNOT_NULL.getCode(), (String)PlatformCodeEnum.POSITION_ID_LIST_CANNOT_NULL.getDesc());
                }
                List positionIdList = positions.stream().map(IFWPosition::getPositionId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(positionIdList)) {
                    return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.POSITION_ID_LIST_CANNOT_NULL.getCode(), (String)PlatformCodeEnum.POSITION_ID_LIST_CANNOT_NULL.getDesc());
                }
                stockOutWrapDTO.setSubjectPermissionPositionIdList(positionIdList);
            }
            this.cargoRepository.insertStockOutRecord(stockOutWrapDTO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<StockInWrapOutputDTO> getStockInDetail(IFWUser ifwUser, QueryStockInDetailBO queryStockInDetailBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryStockInDetailBO.getTenantId())) {
                queryStockInDetailBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryStockInDetailBO.getTenantId());
            }
            IFWValidator.validate((Object)queryStockInDetailBO);
            StockInWrapDTO stockInDetail = this.cargoRepository.getStockInDetail(queryStockInDetailBO);
            StockInWrapOutputDTO stockInWrapOutputDTO = (StockInWrapOutputDTO)IFWBeanCopyUtil.map((Object)stockInDetail, StockInWrapOutputDTO.class);
            if (stockInWrapOutputDTO != null && stockInWrapOutputDTO.getCargoStockInRecord() != null) {
                CargoStockInRecordOutputDTO cargoStockInRecord = stockInWrapOutputDTO.getCargoStockInRecord();
                UserInformationDTO userInformationDTO = this.organizationRepository.queryUser(cargoStockInRecord.getCreateBy(), queryStockInDetailBO.getTenantId(), queryStockInDetailBO.getLanguageCode());
                cargoStockInRecord.setCreateName(userInformationDTO.getEmployeeName());
                ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
                contactQueryInputBO.setLanguageCode(queryStockInDetailBO.getLanguageCode());
                contactQueryInputBO.setProjectId(queryStockInDetailBO.getProjectId());
                contactQueryInputBO.setTenantId(queryStockInDetailBO.getTenantId());
                List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
                if (!CollectionUtils.isEmpty((Collection)deptInfoList)) {
                    List collect = deptInfoList.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
                    QuPositionNameReqDTO quPositionNameReqDTO = new QuPositionNameReqDTO();
                    quPositionNameReqDTO.setUserId(cargoStockInRecord.getCreateBy());
                    quPositionNameReqDTO.setLanguageCode(queryStockInDetailBO.getLanguageCode());
                    quPositionNameReqDTO.setTenantId(queryStockInDetailBO.getTenantId());
                    quPositionNameReqDTO.setDeptIds(collect);
                    List quPositionNameResDTOS = this.organizationRepository.queryPositionInfo(quPositionNameReqDTO);
                    stockInWrapOutputDTO.setPositionList(quPositionNameResDTOS);
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)stockInWrapOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<StockOutWrapOutputDTO> getStockOutDetail(IFWUser ifwUser, QueryStockOutDetailBO queryStockOutDetailBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryStockOutDetailBO.getTenantId())) {
                queryStockOutDetailBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryStockOutDetailBO.getTenantId());
            }
            IFWValidator.validate((Object)queryStockOutDetailBO);
            StockOutWrapDTO stockOutDetail = this.cargoRepository.getStockOutDetail(queryStockOutDetailBO);
            StockOutWrapOutputDTO stockOutWrapOutputDTO = (StockOutWrapOutputDTO)IFWBeanCopyUtil.map((Object)stockOutDetail, StockOutWrapOutputDTO.class);
            if (stockOutWrapOutputDTO != null && stockOutWrapOutputDTO.getCargoStockOutRecord() != null) {
                CargoStockOutRecordOutputDTO cargoStockOutRecord = stockOutWrapOutputDTO.getCargoStockOutRecord();
                UserInformationDTO userInformationDTO = this.organizationRepository.queryUser(cargoStockOutRecord.getCreateBy(), queryStockOutDetailBO.getTenantId(), queryStockOutDetailBO.getLanguageCode());
                cargoStockOutRecord.setCreateName(userInformationDTO.getEmployeeName());
                ContactQueryInputBO contactQueryInputBO = new ContactQueryInputBO();
                contactQueryInputBO.setLanguageCode(queryStockOutDetailBO.getLanguageCode());
                contactQueryInputBO.setProjectId(queryStockOutDetailBO.getProjectId());
                contactQueryInputBO.setTenantId(queryStockOutDetailBO.getTenantId());
                List deptInfoList = this.organizationRepository.getDeptInfoList(contactQueryInputBO);
                if (!CollectionUtils.isEmpty((Collection)deptInfoList)) {
                    List collect = deptInfoList.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
                    QuPositionNameReqDTO quPositionNameReqDTO = new QuPositionNameReqDTO();
                    quPositionNameReqDTO.setUserId(cargoStockOutRecord.getCreateBy());
                    quPositionNameReqDTO.setLanguageCode(queryStockOutDetailBO.getLanguageCode());
                    quPositionNameReqDTO.setTenantId(queryStockOutDetailBO.getTenantId());
                    quPositionNameReqDTO.setDeptIds(collect);
                    List quPositionNameResDTOS = this.organizationRepository.queryPositionInfo(quPositionNameReqDTO);
                    stockOutWrapOutputDTO.setPositionList(quPositionNameResDTOS);
                }
                if (stockOutWrapOutputDTO.getCargoStockOutCheck() != null && !StringUtils.isBlank((CharSequence)stockOutWrapOutputDTO.getCargoStockOutCheck().getApprovalBy())) {
                    UserInformationDTO approvalInfo = this.organizationRepository.queryUser(stockOutWrapOutputDTO.getCargoStockOutCheck().getApprovalBy(), queryStockOutDetailBO.getTenantId(), queryStockOutDetailBO.getLanguageCode());
                    stockOutWrapOutputDTO.getCargoStockOutCheck().setApprovalName(approvalInfo.getEmployeeName());
                    if (!CollectionUtils.isEmpty((Collection)deptInfoList)) {
                        List collect = deptInfoList.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
                        QuPositionNameReqDTO quPositionNameReqDTO = new QuPositionNameReqDTO();
                        quPositionNameReqDTO.setUserId(stockOutWrapOutputDTO.getCargoStockOutCheck().getApprovalBy());
                        quPositionNameReqDTO.setLanguageCode(queryStockOutDetailBO.getLanguageCode());
                        quPositionNameReqDTO.setTenantId(queryStockOutDetailBO.getTenantId());
                        quPositionNameReqDTO.setDeptIds(collect);
                        List quPositionNameResDTOS = this.organizationRepository.queryPositionInfo(quPositionNameReqDTO);
                        stockOutWrapOutputDTO.getCargoStockOutCheck().setPositionList(quPositionNameResDTOS);
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)stockOutWrapOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<CargoStockInRecordOutputDTO>> getCargoStockInRecordList(IFWUser ifwUser, QueryCargoStockInRecordInputBO queryCargoStockInRecordInputBO) {
        BaseResponse response;
        try {
            List list;
            List collect;
            List userInfoList;
            if (StringUtils.isBlank((CharSequence)queryCargoStockInRecordInputBO.getTenantId())) {
                queryCargoStockInRecordInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoStockInRecordInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCargoStockInRecordInputBO);
            IFWPageInfo pageInfo = this.cargoRepository.getCargoStockInRecordList(queryCargoStockInRecordInputBO);
            if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList()) && !CollectionUtils.isEmpty((Collection)(userInfoList = this.organizationRepository.queryUserDetailByUserId(collect = (list = pageInfo.getList()).stream().map(CargoStockInRecordOutputDTO::getCreateBy).distinct().collect(Collectors.toList()), queryCargoStockInRecordInputBO.getTenantId(), queryCargoStockInRecordInputBO.getLanguageCode())))) {
                for (CargoStockInRecordOutputDTO dto : list) {
                    for (UserDeatilInfoOutputBO bo : userInfoList) {
                        if (!StringUtils.equals((CharSequence)dto.getCreateBy(), (CharSequence)bo.getUserId())) continue;
                        dto.setCreateName(bo.getRealName());
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<CargoStockOutRecordOutputDTO>> getCargoStockOutRecordList(IFWUser ifwUser, QueryCargoStockOutRecordInputBO queryCargoStockOutRecordInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryCargoStockOutRecordInputBO.getTenantId())) {
                queryCargoStockOutRecordInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoStockOutRecordInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCargoStockOutRecordInputBO);
            IFWPageInfo pageInfo = this.cargoRepository.getCargoStockOutRecordList(queryCargoStockOutRecordInputBO);
            if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                List userInfoList;
                List list = pageInfo.getList();
                List allUserIdList = new ArrayList();
                List collect = list.stream().map(CargoStockOutRecordOutputDTO::getCreateBy).distinct().collect(Collectors.toList());
                allUserIdList.addAll(collect);
                List approvalIdList = list.stream().filter(item -> !StringUtils.isBlank((CharSequence)item.getApprovalBy())).map(CargoStockOutRecordOutputDTO::getApprovalBy).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(approvalIdList)) {
                    List result = Stream.of(collect, approvalIdList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                    allUserIdList = result;
                }
                if (!CollectionUtils.isEmpty((Collection)(userInfoList = this.organizationRepository.queryUserDetailByUserId(allUserIdList, queryCargoStockOutRecordInputBO.getTenantId(), queryCargoStockOutRecordInputBO.getLanguageCode())))) {
                    for (CargoStockOutRecordOutputDTO dto : list) {
                        for (UserDeatilInfoOutputBO bo : userInfoList) {
                            if (StringUtils.equals((CharSequence)dto.getCreateBy(), (CharSequence)bo.getUserId())) {
                                dto.setCreateName(bo.getRealName());
                            }
                            if (StringUtils.isBlank((CharSequence)dto.getApprovalBy()) || !StringUtils.equals((CharSequence)dto.getApprovalBy(), (CharSequence)bo.getUserId())) continue;
                            dto.setApprovalByName(bo.getRealName());
                        }
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<ApprovalResultOutputDTO> approvalStockOut(IFWUser ifwUser, CargoStockOutCheckInputBO cargoStockOutCheckInputBO) {
        BaseResponse response;
        long time = System.currentTimeMillis() + 10000L;
        if (!this.redisLockHelper.lock(RedisKeyPrefixUtil.getTrackerCargoStockOut((String)cargoStockOutCheckInputBO.getProjectId()), String.valueOf(time))) {
            return BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.TRY_AGAIN_LATER.getCode(), (String)PlatformCodeEnum.TRY_AGAIN_LATER.getDesc());
        }
        try {
            if (StringUtils.isBlank((CharSequence)cargoStockOutCheckInputBO.getTenantId())) {
                cargoStockOutCheckInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)cargoStockOutCheckInputBO.getTenantId());
            }
            cargoStockOutCheckInputBO.setApprovalBy(ifwUser.getUserId());
            IFWValidator.validate((Object)cargoStockOutCheckInputBO);
            ApprovalResultOutputDTO approvalResultOutputDTO = this.cargoRepository.approvalStockOut(cargoStockOutCheckInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)approvalResultOutputDTO, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        this.redisLockHelper.unlock(RedisKeyPrefixUtil.getTrackerCargoStockOut((String)cargoStockOutCheckInputBO.getProjectId()), String.valueOf(time));
        return response;
    }

    public BaseResponse<IFWPageInfo<CargoDetailOutputDTO>> getCargoDetailList(IFWUser ifwUser, QueryCargoStatisticInputBO queryCargoStatisticInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryCargoStatisticInputBO.getTenantId())) {
                queryCargoStatisticInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoStatisticInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCargoStatisticInputBO);
            IFWPageInfo pageInfo = this.cargoRepository.getCargoDetailList(queryCargoStatisticInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<CargoDetailOutputDTO>> getLowSafeStock(IFWUser ifwUser, QueryLowSafeStockInputBO queryLowSafeStockInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryLowSafeStockInputBO.getTenantId())) {
                queryLowSafeStockInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryLowSafeStockInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryLowSafeStockInputBO);
            IFWPageInfo pageInfo = this.cargoRepository.getLowSafeStock(queryLowSafeStockInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<CargoStockOutByDayOutputDTO>> getCargoOutByDay(IFWUser ifwUser, QueryStockOutInfoInputBO queryStockOutInfoInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryStockOutInfoInputBO.getTenantId())) {
                queryStockOutInfoInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryStockOutInfoInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryStockOutInfoInputBO);
            List pageInfo = this.cargoRepository.getCargoOutByDay(queryStockOutInfoInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<CargoStockOutDetailOutputDTO>> getCargoStockOutInfoByDay(IFWUser ifwUser, QueryStockOutInfoDetailInputBO queryStockOutInfoInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryStockOutInfoInputBO.getTenantId())) {
                queryStockOutInfoInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryStockOutInfoInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryStockOutInfoInputBO);
            queryStockOutInfoInputBO.setStartDate(DateUtils.getFirstDateOfDay((Date)queryStockOutInfoInputBO.getDate()));
            queryStockOutInfoInputBO.setEndDate(DateUtils.getLastDateOfDay((Date)queryStockOutInfoInputBO.getDate()));
            List pageInfo = this.cargoRepository.getCargoStockOutInfoByDay(queryStockOutInfoInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<CargoCommonStatisticOutputDTO> getCargoCommonStatistics(IFWUser ifwUser, CargoCommonStatisticsQueryInputBO cargoCommonStatisticsQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)cargoCommonStatisticsQueryInputBO.getTenantId())) {
                cargoCommonStatisticsQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)cargoCommonStatisticsQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)cargoCommonStatisticsQueryInputBO);
            CargoCommonStatisticOutputDTO pageInfo = this.cargoRepository.getCargoCommonStatistics(cargoCommonStatisticsQueryInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<List<CargoDetailOutputDTO>> getCargoDetail(IFWUser ifwUser, CargoDetailQueryInputBO cargoDetailQueryInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)cargoDetailQueryInputBO.getTenantId())) {
                cargoDetailQueryInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)cargoDetailQueryInputBO.getTenantId());
            }
            IFWValidator.validate((Object)cargoDetailQueryInputBO);
            List result = this.cargoRepository.selectByCargoIdList(cargoDetailQueryInputBO);
            response = BaseResponseUtils.getSuccessResponse((Object)result, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<Workbook> exportCargoDetailList(IFWUser ifwUser, QueryCargoStatisticInputBO queryCargoStatisticInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryCargoStatisticInputBO.getTenantId())) {
                queryCargoStatisticInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoStatisticInputBO.getTenantId());
            }
            BaseResponse data = this.getCargoDetailList(ifwUser, queryCargoStatisticInputBO);
            IFWPageInfo pageInfo = (IFWPageInfo)data.getData();
            TranslationBean translationBean = StringUtils.equals((CharSequence)queryCargoStatisticInputBO.getLanguageCode(), (CharSequence)"CN") ? (TranslationBean)this.translationConfig.getList().get(0) : (StringUtils.equals((CharSequence)queryCargoStatisticInputBO.getLanguageCode(), (CharSequence)"JP") ? (TranslationBean)this.translationConfig.getList().get(2) : (TranslationBean)this.translationConfig.getList().get(1));
            HSSFWorkbook sheets = new HSSFWorkbook();
            Sheet sheet = sheets.createSheet(translationBean.getCargoData());
            int rowNum = 0;
            int cellNum = 0;
            Row row = sheet.createRow(rowNum++);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getCargoNo(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getCargoName(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getCargoSpecification(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getCargoUnit(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getCargoSafeStock(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getCargoStockNum(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getTotalCargoStockInNum(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getTotalCargoStockInPrice(), sheet);
            this.createCell((Workbook)sheets, row, cellNum++, translationBean.getTotalCargoStockOutNum(), sheet);
            List list = new ArrayList();
            if (pageInfo != null) {
                list = pageInfo.getList();
            }
            if (!CollectionUtils.isEmpty(list)) {
                for (CargoDetailOutputDTO dto : list) {
                    row = sheet.createRow(rowNum++);
                    cellNum = 0;
                    row.createCell(cellNum++).setCellValue(dto.getCargoNo());
                    row.createCell(cellNum++).setCellValue(dto.getCargoName());
                    row.createCell(cellNum++).setCellValue(dto.getCargoSpecification());
                    row.createCell(cellNum++).setCellValue(dto.getCargoUnit());
                    row.createCell(cellNum++).setCellValue(DataUtils.roundBigDecimal((BigDecimal)dto.getCargoSafeStock()).toString());
                    row.createCell(cellNum++).setCellValue(DataUtils.roundBigDecimal((BigDecimal)dto.getCargoStockNum()).toString());
                    row.createCell(cellNum++).setCellValue(DataUtils.roundBigDecimal((BigDecimal)dto.getTotalCargoStockInNum()).toString());
                    row.createCell(cellNum++).setCellValue(DataUtils.roundBigDecimal((BigDecimal)dto.getTotalCargoStockInPrice()).toString());
                    row.createCell(cellNum++).setCellValue(DataUtils.roundBigDecimal((BigDecimal)dto.getTotalCargoStockOutNum()).toString());
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)sheets, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public Cell createCell(Workbook sheets, Row row, int index, String value, Sheet sheet) {
        CellStyle style = sheets.createCellStyle();
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
        Cell cell = row.createCell(index);
        cell.setCellStyle(style);
        cell.setCellValue(value);
        sheet.setColumnWidth(index, (int)((double)value.getBytes().length * 1.2 * 256.0 > 3072.0 ? (double)value.getBytes().length * 1.2 * 256.0 : 3072.0));
        return cell;
    }

    public BaseResponse<IFWPageInfo<CargoStockInInfoOutputDTO>> getCargoStockInRecordByCargoIdList(IFWUser ifwUser, QueryStockByCargoInputBO queryCargoStockInRecordInputBO) {
        BaseResponse response;
        try {
            List list;
            List collect;
            List userInfoList;
            if (StringUtils.isBlank((CharSequence)queryCargoStockInRecordInputBO.getTenantId())) {
                queryCargoStockInRecordInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoStockInRecordInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCargoStockInRecordInputBO);
            IFWPageInfo pageInfo = this.cargoRepository.getCargoStockInRecordByCargoIdList(queryCargoStockInRecordInputBO);
            if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList()) && !CollectionUtils.isEmpty((Collection)(userInfoList = this.organizationRepository.queryUserDetailByUserId(collect = (list = pageInfo.getList()).stream().map(CargoStockInInfoOutputDTO::getCreateBy).distinct().collect(Collectors.toList()), queryCargoStockInRecordInputBO.getTenantId(), queryCargoStockInRecordInputBO.getLanguageCode())))) {
                for (CargoStockInInfoOutputDTO dto : list) {
                    for (UserDeatilInfoOutputBO bo : userInfoList) {
                        if (!StringUtils.equals((CharSequence)dto.getCreateBy(), (CharSequence)bo.getUserId())) continue;
                        dto.setCreateName(bo.getRealName());
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<CargoStockOutInfoByIdOutputDTO>> getCargoStockOutRecordByCargoIdList(IFWUser ifwUser, QueryStockByCargoInputBO queryCargoStockOutRecordInputBO) {
        BaseResponse response;
        try {
            if (StringUtils.isBlank((CharSequence)queryCargoStockOutRecordInputBO.getTenantId())) {
                queryCargoStockOutRecordInputBO.setTenantId(ifwUser.getTenantId());
            } else {
                CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)queryCargoStockOutRecordInputBO.getTenantId());
            }
            IFWValidator.validate((Object)queryCargoStockOutRecordInputBO);
            IFWPageInfo pageInfo = this.cargoRepository.getCargoStockOutRecordByCargoIdList(queryCargoStockOutRecordInputBO);
            if (pageInfo != null && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
                List userInfoList;
                List list = pageInfo.getList();
                List allUserIdList = new ArrayList();
                List collect = list.stream().map(CargoStockOutInfoByIdOutputDTO::getCreateBy).distinct().collect(Collectors.toList());
                allUserIdList.addAll(collect);
                List approvalIdList = list.stream().filter(item -> !StringUtils.isBlank((CharSequence)item.getApprovalBy())).map(CargoStockOutInfoByIdOutputDTO::getApprovalBy).distinct().collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(approvalIdList)) {
                    List result = Stream.of(collect, approvalIdList).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                    allUserIdList = result;
                }
                if (!CollectionUtils.isEmpty((Collection)(userInfoList = this.organizationRepository.queryUserDetailByUserId(allUserIdList, queryCargoStockOutRecordInputBO.getTenantId(), queryCargoStockOutRecordInputBO.getLanguageCode())))) {
                    for (CargoStockOutInfoByIdOutputDTO dto : list) {
                        for (UserDeatilInfoOutputBO bo : userInfoList) {
                            if (StringUtils.equals((CharSequence)dto.getCreateBy(), (CharSequence)bo.getUserId())) {
                                dto.setCreateName(bo.getRealName());
                            }
                            if (StringUtils.isBlank((CharSequence)dto.getApprovalBy()) || !StringUtils.equals((CharSequence)dto.getApprovalBy(), (CharSequence)bo.getUserId())) continue;
                            dto.setApprovalByName(bo.getRealName());
                        }
                    }
                }
            }
            response = BaseResponseUtils.getSuccessResponse((Object)pageInfo, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

