/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.service.impl;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWValidator;
import com.ifourthwall.dbm.tracker.bo.ApkInsertBO;
import com.ifourthwall.dbm.tracker.domain.ApkRepository;
import com.ifourthwall.dbm.tracker.dto.ApkOutputDTO;
import com.ifourthwall.dbm.tracker.dto.BaseCommonPageDTO;
import com.ifourthwall.dbm.tracker.service.ApkService;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import com.ifourthwall.dbm.tracker.utils.CheckAccessUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="apkServiceImpl")
public class ApkServiceImpl
implements ApkService {
    @Resource(name="apkRepository")
    ApkRepository apkRepository;

    public BaseResponse uploadApk(IFWUser ifwUser, ApkInsertBO apkInsertBO) {
        BaseResponse response;
        try {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)ifwUser.getTenantId());
            IFWValidator.validate((Object)apkInsertBO);
            this.apkRepository.uploadApk(apkInsertBO);
            response = BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }

    public BaseResponse<IFWPageInfo<ApkOutputDTO>> selectApkList(IFWUser ifwUser, BaseCommonPageDTO baseCommonPageDTO) {
        BaseResponse response;
        try {
            CheckAccessUtils.checkAccess((IFWUser)ifwUser, (String)ifwUser.getTenantId());
            IFWPageInfo apkList = this.apkRepository.getApkList(baseCommonPageDTO);
            response = BaseResponseUtils.getSuccessResponse((Object)apkList, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
        }
        catch (BizException bizException) {
            response = BaseResponseUtils.getFailResponse((String)bizException.getCode(), (String)bizException.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            response = BaseResponseUtils.getFailResponse((String)PlatformCodeEnum.SYS_ERROR.getCode(), (String)PlatformCodeEnum.SYS_ERROR.getDesc());
        }
        return response;
    }
}

