/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.QueryByDeptQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryCheckPointByDeptDTO;
import com.ifourthwall.dbm.asset.facade.CheckpoinAssetFacade;
import com.ifourthwall.dbm.task.dto.CheckPointScanInfoQueryDTO;
import com.ifourthwall.dbm.task.dto.DailyTaskWorkSheetListQueryDTO;
import com.ifourthwall.dbm.task.dto.DailyTaskWorkSheetWrapDTO;
import com.ifourthwall.dbm.task.dto.DailyWorksheetListQueryDTO;
import com.ifourthwall.dbm.task.dto.EventConsumptionDTO;
import com.ifourthwall.dbm.task.dto.ExportDailyWorksheetQueryDTO;
import com.ifourthwall.dbm.task.dto.ExportTemporaryWorksheetQueryDTO;
import com.ifourthwall.dbm.task.dto.HangUpWorksheetDTO;
import com.ifourthwall.dbm.task.dto.PatrolCheckQueryDTO;
import com.ifourthwall.dbm.task.dto.QueryDailyWorksheetScanDTO;
import com.ifourthwall.dbm.task.dto.QuerySpecialListBySpaceDTO;
import com.ifourthwall.dbm.task.dto.QueryTempWorksheetByCheckpointDTO;
import com.ifourthwall.dbm.task.dto.SeerWorksheetQueryDTO;
import com.ifourthwall.dbm.task.dto.SingleStringOutDTO;
import com.ifourthwall.dbm.task.dto.SingleWorksheetSummeryQueryDTO;
import com.ifourthwall.dbm.task.dto.SpaceSpecialDTO;
import com.ifourthwall.dbm.task.dto.SpaceSpecialQueryDTO;
import com.ifourthwall.dbm.task.dto.SpecialWorksheetDTO;
import com.ifourthwall.dbm.task.dto.TaskOperationQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskWorksheetDTO;
import com.ifourthwall.dbm.task.dto.TaskWorksheetListQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskWorksheetUpdateDTO;
import com.ifourthwall.dbm.task.dto.TempTaskWorksheetQueryDTO;
import com.ifourthwall.dbm.task.dto.TemporaryTaskWorksheetWrapDTO;
import com.ifourthwall.dbm.task.dto.UploadScanWrapDTO;
import com.ifourthwall.dbm.task.dto.WorksheetAndNumDTO;
import com.ifourthwall.dbm.task.dto.WorksheetAssignListQueryDTO;
import com.ifourthwall.dbm.task.dto.WorksheetBatchCreateDTO;
import com.ifourthwall.dbm.task.dto.WorksheetDetailQueryDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventPictureDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventPositionDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventUserDTO;
import com.ifourthwall.dbm.task.dto.WorksheetExecutorDTO;
import com.ifourthwall.dbm.task.dto.WorksheetOperateDTO;
import com.ifourthwall.dbm.task.dto.WorksheetQueryByAssetDTO;
import com.ifourthwall.dbm.task.dto.WorksheetQueryBySpaceDTO;
import com.ifourthwall.dbm.task.dto.WorksheetStatisticListDTO;
import com.ifourthwall.dbm.task.facade.SeerFacade;
import com.ifourthwall.dbm.task.facade.StatisticsFacade;
import com.ifourthwall.dbm.task.facade.WorkSheetFacade;
import com.ifourthwall.dbm.tracker.bo.AllWorksheetNumOutputBO;
import com.ifourthwall.dbm.tracker.bo.CheckPointScanInfoQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CommonWorksheetDetailOutputBO;
import com.ifourthwall.dbm.tracker.bo.CustomizeTaskCycleInputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetListOutputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.DailyWorksheetListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ExportDailyWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ExportTemporaryWorksheetOutputBO;
import com.ifourthwall.dbm.tracker.bo.ExportTemporaryWorksheetQueryBO;
import com.ifourthwall.dbm.tracker.bo.HangUpWorksheetInputBO;
import com.ifourthwall.dbm.tracker.bo.PatrolCheckInputBO;
import com.ifourthwall.dbm.tracker.bo.QuerySpecialListBySpaceInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryTempWorksheetByCheckpointInputBO;
import com.ifourthwall.dbm.tracker.bo.ScanDetailInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.ScanQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.SpaceSpecialQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskCheckPointRelationInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskExecutorInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskOperationQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskPictureInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWorksheetOutputBO;
import com.ifourthwall.dbm.tracker.bo.TemporaryTaskWorksheetWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.TemporyTaskWorkSheetListOutputBO;
import com.ifourthwall.dbm.tracker.bo.UploadScanResultOutputBO;
import com.ifourthwall.dbm.tracker.bo.UploadScanWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetAssignListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetBatchCreateInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetCountForSeerOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventSupperWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetExecutorOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetFinishQueryByMonthInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetListForSeerOutputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetOperateInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetQueryByAssetInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetQueryBySpaceInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetStatisticListInputBO;
import com.ifourthwall.dbm.tracker.dto.PatrolCheckResultOutputDTO;
import com.ifourthwall.dbm.tracker.dto.TempTaskWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.dto.WorksheetListOutlineForSeerOutputDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="worksheetRepository")
public class WorksheetRepository {
    private static final Logger log = LoggerFactory.getLogger(WorksheetRepository.class);
    @Reference(version="3.0.0", timeout=10000)
    WorkSheetFacade workSheetFacade;
    @Reference(version="3.0.0")
    StatisticsFacade statisticsFacade;
    @Reference(version="1.0.0")
    CheckpoinAssetFacade checkpoinAssetFacade;
    @Reference(version="3.0.0")
    SeerFacade seerFacade;

    public void createWorksheetBatch(WorksheetBatchCreateInputBO worksheetBatchCreateInputBO) {
        log.info("\u63a5\u53e3 createWorksheetBatch ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetBatchCreateInputBO);
        BaseResponse response = this.workSheetFacade.createWorksheetBatch((WorksheetBatchCreateDTO)IFWBeanCopyUtil.map((Object)worksheetBatchCreateInputBO, WorksheetBatchCreateDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createWorksheetBatch ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void createPlanTaskWorksheetBatch(WorksheetBatchCreateInputBO worksheetBatchCreateInputBO) {
        log.info("\u63a5\u53e3 createPlanTaskWorksheetBatch ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetBatchCreateInputBO);
        BaseResponse response = this.workSheetFacade.createPlanTaskWorksheetBatch((WorksheetBatchCreateDTO)IFWBeanCopyUtil.map((Object)worksheetBatchCreateInputBO, WorksheetBatchCreateDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createPlanTaskWorksheetBatch ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public AllWorksheetNumOutputBO getAllWorksheetFinishSum(WorksheetFinishQueryByMonthInputBO worksheetFinishQueryByMonthInputBO) {
        log.info("\u63a5\u53e3 getAllWorksheetFinishSum ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetFinishQueryByMonthInputBO);
        AllWorksheetNumOutputBO allWorksheetNumOutputBO = new AllWorksheetNumOutputBO();
        SingleWorksheetSummeryQueryDTO singleWorksheetSummeryQueryDTO = (SingleWorksheetSummeryQueryDTO)IFWBeanCopyUtil.map((Object)worksheetFinishQueryByMonthInputBO, SingleWorksheetSummeryQueryDTO.class);
        BaseResponse response = this.statisticsFacade.getAllWorksheetNum(singleWorksheetSummeryQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getAllWorksheetFinishSum ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        if (data != null && !data.isEmpty()) {
            for (WorksheetAndNumDTO worksheetAndNumDTO : data) {
                if (StringUtils.equals((CharSequence)worksheetAndNumDTO.getTaskTypeId(), (CharSequence)"1")) {
                    allWorksheetNumOutputBO.setTemporaryWorksheetFinishNum(worksheetAndNumDTO.getNum());
                    continue;
                }
                if (StringUtils.equals((CharSequence)worksheetAndNumDTO.getTaskTypeId(), (CharSequence)"2")) {
                    allWorksheetNumOutputBO.setStaticWorksheetFinishNum(worksheetAndNumDTO.getNum());
                    continue;
                }
                if (StringUtils.equals((CharSequence)worksheetAndNumDTO.getTaskTypeId(), (CharSequence)"3")) {
                    allWorksheetNumOutputBO.setPatrolWorksheetFinishNum(worksheetAndNumDTO.getNum());
                    continue;
                }
                if (!StringUtils.equals((CharSequence)worksheetAndNumDTO.getTaskTypeId(), (CharSequence)"4")) continue;
                allWorksheetNumOutputBO.setPlanWorksheetFinishNum(worksheetAndNumDTO.getNum());
            }
        }
        return allWorksheetNumOutputBO;
    }

    public IFWPageInfo<DailyTaskWorkSheetListOutputBO> getDailyTaskWorkSheetList(DailyTaskWorkSheetListQueryInputBO dailyTaskWorkSheetListQueryInputBO) {
        log.info("\u63a5\u53e3 getDailyTaskWorkSheetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)dailyTaskWorkSheetListQueryInputBO);
        BaseResponse response = this.workSheetFacade.getDailyTaskWorkSheetList((DailyTaskWorkSheetListQueryDTO)IFWBeanCopyUtil.map((Object)dailyTaskWorkSheetListQueryInputBO, DailyTaskWorkSheetListQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getDailyTaskWorkSheetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List dailyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), DailyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        result.setTotal(data.getTotal());
        result.setList(dailyTaskWorkSheetListOutputBOList);
        return result;
    }

    public IFWPageInfo<DailyTaskWorkSheetListOutputBO> getStatisticDailyWorksheetList(WorksheetStatisticListInputBO worksheetStatisticListInputBO) {
        log.info("\u63a5\u53e3 getStatisticDailyWorksheetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetStatisticListInputBO);
        BaseResponse response = this.workSheetFacade.getStatisticDailyWorksheetList((WorksheetStatisticListDTO)IFWBeanCopyUtil.map((Object)worksheetStatisticListInputBO, WorksheetStatisticListDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getStatisticDailyWorksheetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List dailyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), DailyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        result.setTotal(data.getTotal());
        result.setList(dailyTaskWorkSheetListOutputBOList);
        return result;
    }

    public IFWPageInfo<DailyTaskWorkSheetListOutputBO> getExportDailyWorksheetList(ExportDailyWorksheetQueryInputBO exportDailyWorksheetQueryInputBO) {
        log.info("\u63a5\u53e3 getExportDailyWorksheetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)exportDailyWorksheetQueryInputBO);
        BaseResponse response = this.workSheetFacade.getExportDailyWorksheetList((ExportDailyWorksheetQueryDTO)IFWBeanCopyUtil.map((Object)exportDailyWorksheetQueryInputBO, ExportDailyWorksheetQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getExportDailyWorksheetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List dailyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), DailyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        result.setTotal(data.getTotal());
        result.setList(dailyTaskWorkSheetListOutputBOList);
        return result;
    }

    public IFWPageInfo<TemporyTaskWorkSheetListOutputBO> getStatisticTempWorksheetList(WorksheetStatisticListInputBO worksheetStatisticListInputBO) {
        log.info("\u63a5\u53e3 getStatisticTempWorksheetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetStatisticListInputBO);
        BaseResponse response = this.workSheetFacade.getStatisticTempWorksheetList((WorksheetStatisticListDTO)IFWBeanCopyUtil.map((Object)worksheetStatisticListInputBO, WorksheetStatisticListDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getStatisticTempWorksheetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List temporyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), TemporyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(temporyTaskWorkSheetListOutputBOList);
        return result;
    }

    public IFWPageInfo<TemporyTaskWorkSheetListOutputBO> getTempTaskWorksheetList(TempTaskWorksheetQueryInputBO tempTaskWorksheetQueryInputBO) {
        log.info("\u63a5\u53e3 getTempTaskWorksheetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)tempTaskWorksheetQueryInputBO);
        BaseResponse response = this.workSheetFacade.getTempTaskWorksheetList((TempTaskWorksheetQueryDTO)IFWBeanCopyUtil.map((Object)tempTaskWorksheetQueryInputBO, TempTaskWorksheetQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTempTaskWorksheetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List temporyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), TemporyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(temporyTaskWorkSheetListOutputBOList);
        return result;
    }

    public IFWPageInfo<TemporyTaskWorkSheetListOutputBO> getTempWorksheetListByCheckpointId(QueryTempWorksheetByCheckpointInputBO queryTempWorksheetByCheckpointInputBO) {
        log.info("\u63a5\u53e3 getTempWorksheetListByCheckpointId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryTempWorksheetByCheckpointInputBO);
        BaseResponse response = this.workSheetFacade.getTempWorksheetListByCheckpointId((QueryTempWorksheetByCheckpointDTO)IFWBeanCopyUtil.map((Object)queryTempWorksheetByCheckpointInputBO, QueryTempWorksheetByCheckpointDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTempWorksheetListByCheckpointId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List temporyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), TemporyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(temporyTaskWorkSheetListOutputBOList);
        return result;
    }

    public IFWPageInfo<ExportTemporaryWorksheetOutputBO> getExportTemporaryWorksheetList(ExportTemporaryWorksheetQueryBO exportTemporaryWorksheetQueryBO) {
        log.info("\u63a5\u53e3 getExportTemporaryyWorksheetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)exportTemporaryWorksheetQueryBO);
        BaseResponse response = this.workSheetFacade.getExportTemporaryWorksheetList((ExportTemporaryWorksheetQueryDTO)IFWBeanCopyUtil.map((Object)exportTemporaryWorksheetQueryBO, ExportTemporaryWorksheetQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getExportTemporaryyWorksheetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List temporaryWorkSheetList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), ExportTemporaryWorksheetOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(temporaryWorkSheetList);
        return result;
    }

    public TemporaryTaskWorksheetWrapOutputBO getTemporaryTaskWorksheetDetail(WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        log.info("\u63a5\u53e3 getTemporaryTaskWorksheetDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetDetailQueryInputBO);
        BaseResponse response = this.workSheetFacade.getTemporaryTaskWorksheetDetail((WorksheetDetailQueryDTO)IFWBeanCopyUtil.map((Object)worksheetDetailQueryInputBO, WorksheetDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTemporaryTaskWorksheetDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        TemporaryTaskWorksheetWrapDTO data = (TemporaryTaskWorksheetWrapDTO)response.getData();
        TemporaryTaskWorksheetWrapOutputBO taskWorksheetWrapOutputBO = (TemporaryTaskWorksheetWrapOutputBO)IFWBeanCopyUtil.map((Object)data, TemporaryTaskWorksheetWrapOutputBO.class);
        return taskWorksheetWrapOutputBO;
    }

    public DailyTaskWorkSheetWrapOutputBO getDailyTaskWorksheetDetail(WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        log.info("\u63a5\u53e3 getDailyTaskWorksheetDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetDetailQueryInputBO);
        BaseResponse response = this.workSheetFacade.getDailyTaskWorksheetDetail((WorksheetDetailQueryDTO)IFWBeanCopyUtil.map((Object)worksheetDetailQueryInputBO, WorksheetDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getDailyTaskWorksheetDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        DailyTaskWorkSheetWrapDTO data = (DailyTaskWorkSheetWrapDTO)response.getData();
        DailyTaskWorkSheetWrapOutputBO dailyTaskWorkSheetWrapOutputBO = new DailyTaskWorkSheetWrapOutputBO();
        dailyTaskWorkSheetWrapOutputBO.setTask((TaskInsertInputBO)IFWBeanCopyUtil.map((Object)data.getTaskInsertDTO(), TaskInsertInputBO.class));
        if (data.getCustomizeTaskCycle() != null) {
            dailyTaskWorkSheetWrapOutputBO.setCustomizeTaskCycle((CustomizeTaskCycleInputBO)IFWBeanCopyUtil.map((Object)data.getCustomizeTaskCycle(), CustomizeTaskCycleInputBO.class));
        }
        if (data.getTaskCheckPointRelationInsertDTOList() != null) {
            dailyTaskWorkSheetWrapOutputBO.setTaskCheckPointRelationList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskCheckPointRelationInsertDTOList(), TaskCheckPointRelationInsertInputBO.class));
        }
        if (data.getTaskPictureInsertDTOList() != null) {
            dailyTaskWorkSheetWrapOutputBO.setTaskPictureList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskPictureInsertDTOList(), TaskPictureInsertInputBO.class));
        }
        if (data.getTaskWorksheetDTO() != null) {
            dailyTaskWorkSheetWrapOutputBO.setTaskWorksheet((TaskWorksheetOutputBO)IFWBeanCopyUtil.map((Object)data.getTaskWorksheetDTO(), TaskWorksheetOutputBO.class));
        }
        if (data.getWorksheetExecutorDTOList() != null) {
            dailyTaskWorkSheetWrapOutputBO.setWorksheetExecutorList(IFWBeanCopyUtil.mapAsList((Iterable)data.getWorksheetExecutorDTOList(), WorksheetExecutorOutputBO.class));
        }
        return dailyTaskWorkSheetWrapOutputBO;
    }

    public void deleteWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 deleteWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.deleteWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 deleteWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public List<TaskExecutorInsertInputBO> getWorksheetAssignList(WorksheetAssignListQueryInputBO worksheetAssignListQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskExecutorList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetAssignListQueryInputBO);
        BaseResponse response = this.workSheetFacade.getWorksheetAssignList((WorksheetAssignListQueryDTO)IFWBeanCopyUtil.map((Object)worksheetAssignListQueryInputBO, WorksheetAssignListQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskExecutorList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), TaskExecutorInsertInputBO.class);
    }

    public List<String> getWorksheetOperationList(TaskOperationQueryInputBO taskOperationQueryInputBO) {
        log.info("\u63a5\u53e3 getWorksheetOperationList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskOperationQueryInputBO);
        BaseResponse response = this.workSheetFacade.getWorksheetOperationList((TaskOperationQueryDTO)IFWBeanCopyUtil.map((Object)taskOperationQueryInputBO, TaskOperationQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getWorksheetOperationList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public void shareWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 shareWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.shareWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 shareWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void upgradeWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 upgradeWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.upgradeWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 upgradeWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void updateWorksheetLabel(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 updateWorksheetLabel ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.updateWorksheetLabel(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateWorksheetLabel ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void addConsumption(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 addConsumption ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.addConsumption(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 addConsumption ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void addFeedback(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 addFeedback ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.addFeedback(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 addFeedback ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void addWorksheetContent(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 addWorksheetContent ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.addWorksheetContent(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 addWorksheetContent ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void finishWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 finishWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.finishWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 finishWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void competeWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 competeWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.competeWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 competeWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void checkWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 checkWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.checkWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 checkWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void operateWorksheetKnowledge(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 operateWorksheetKnowledge ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.operateWorksheetKnowledge(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 operateWorksheetKnowledge ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void remindWorksheet(WorksheetOperateInputBO worksheetOperateInputBO) {
        log.info("\u63a5\u53e3 remindWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetOperateInputBO);
        WorksheetOperateDTO worksheetOperateDTO = this.convert(worksheetOperateInputBO);
        BaseResponse response = this.workSheetFacade.remindWorksheet(worksheetOperateDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 remindWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public UploadScanResultOutputBO uploadScanInfo(UploadScanWrapInputBO uploadScanWrapInputBO) {
        log.info("\u63a5\u53e3 remindWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)uploadScanWrapInputBO);
        UploadScanWrapDTO uploadScanWrapDTO = (UploadScanWrapDTO)IFWBeanCopyUtil.map((Object)uploadScanWrapInputBO, UploadScanWrapDTO.class);
        BaseResponse response = this.workSheetFacade.uploadScanInfo(uploadScanWrapDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 remindWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (UploadScanResultOutputBO)IFWBeanCopyUtil.map((Object)response.getData(), UploadScanResultOutputBO.class);
    }

    public List<WorksheetEventSupperWrapOutputBO> checkPointScanInfoBOList(CheckPointScanInfoQueryInputBO checkPointScanInfoQueryInputBO) {
        log.info("\u63a5\u53e3 checkPointScanInfoBOList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)checkPointScanInfoQueryInputBO);
        BaseResponse response = this.workSheetFacade.checkPointScanInfoBOList((CheckPointScanInfoQueryDTO)IFWBeanCopyUtil.map((Object)checkPointScanInfoQueryInputBO, CheckPointScanInfoQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 checkPointScanInfoBOList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List list = IFWBeanCopyUtil.mapAsList((Iterable)data, WorksheetEventSupperWrapOutputBO.class);
        return list;
    }

    public CommonWorksheetDetailOutputBO getCommonWorksheetDetail(WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        log.info("\u63a5\u53e3 getCommonWorksheetDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetDetailQueryInputBO);
        BaseResponse response = this.workSheetFacade.getCommonWorksheetDetail((WorksheetDetailQueryDTO)IFWBeanCopyUtil.map((Object)worksheetDetailQueryInputBO, WorksheetDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 checkPointScanInfoBOList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (CommonWorksheetDetailOutputBO)IFWBeanCopyUtil.map((Object)response.getData(), CommonWorksheetDetailOutputBO.class);
    }

    public IFWPageInfo<WorksheetListForSeerOutputBO> getWorksheetListForSeer(SeerWorksheetQueryInputBO seerWorksheetQueryInputBO) {
        log.info("\u63a5\u53e3 getWorksheetListForSeer ,\u63a5\u53d7\u53c2\u6570:{}", (Object)seerWorksheetQueryInputBO);
        BaseResponse response = this.workSheetFacade.getWorksheetListForSeer((SeerWorksheetQueryDTO)IFWBeanCopyUtil.map((Object)seerWorksheetQueryInputBO, SeerWorksheetQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getWorksheetListForSeer ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List worksheetList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), WorksheetListForSeerOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(worksheetList);
        return result;
    }

    public IFWPageInfo<WorksheetListForSeerOutputBO> getWorksheetByAssetIdForSeer(WorksheetQueryByAssetInputBO worksheetQueryByAssetInputBO) {
        log.info("\u63a5\u53e3 getWorksheetByAssetIdForSeer ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetQueryByAssetInputBO);
        BaseResponse response = this.workSheetFacade.getWorksheetByAssetIdForSeer((WorksheetQueryByAssetDTO)IFWBeanCopyUtil.map((Object)worksheetQueryByAssetInputBO, WorksheetQueryByAssetDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getWorksheetByAssetIdForSeer ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List worksheetList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), WorksheetListForSeerOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(worksheetList);
        return result;
    }

    public WorksheetCountForSeerOutputBO getWorksheetCountForSeer(SeerWorksheetQueryInputBO seerWorksheetQueryInputBO) {
        log.info("\u63a5\u53e3 getWorksheetCountForSeer ,\u63a5\u53d7\u53c2\u6570:{}", (Object)seerWorksheetQueryInputBO);
        BaseResponse response = this.workSheetFacade.getWorksheetCountForSeer((SeerWorksheetQueryDTO)IFWBeanCopyUtil.map((Object)seerWorksheetQueryInputBO, SeerWorksheetQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getWorksheetCountForSeer ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (WorksheetCountForSeerOutputBO)IFWBeanCopyUtil.map((Object)response.getData(), WorksheetCountForSeerOutputBO.class);
    }

    public SingleStringOutDTO getTaskTemplateByWorksheetId(WorksheetDetailQueryDTO worksheetDetailQueryDTO) {
        log.info("\u63a5\u53e3 getTaskTemplateByWorksheetId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetDetailQueryDTO);
        BaseResponse response = this.workSheetFacade.getTaskTemplateByWorksheetId(worksheetDetailQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskTemplateByWorksheetId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (SingleStringOutDTO)response.getData();
    }

    public List<WorksheetExecutorDTO> getWorksheetExecutor(WorksheetDetailQueryDTO worksheetDetailQueryDTO) {
        log.info("\u63a5\u53e3 getWorksheetExecutor ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetDetailQueryDTO);
        BaseResponse response = this.workSheetFacade.getWorksheetExecutor(worksheetDetailQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getWorksheetExecutor ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public List<TaskWorksheetDTO> getTaskWorksheetListByTaskId(TaskWorksheetListQueryDTO taskWorksheetListQueryDTO) {
        log.info("\u63a5\u53e3 getTaskWorksheetListByTaskId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskWorksheetListQueryDTO);
        BaseResponse response = this.workSheetFacade.getTaskWorksheetListByTaskId(taskWorksheetListQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskWorksheetListByTaskId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public IFWPageInfo<WorksheetListOutlineForSeerOutputDTO> queryWorksheetBySpace(WorksheetQueryBySpaceInputBO worksheetQueryBySpaceInputBO) {
        log.info("\u63a5\u53e3 queryWorksheetBySpace ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetQueryBySpaceInputBO);
        BaseResponse response = this.workSheetFacade.queryWorksheetBySpace((WorksheetQueryBySpaceDTO)IFWBeanCopyUtil.map((Object)worksheetQueryBySpaceInputBO, WorksheetQueryBySpaceDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryWorksheetBySpace ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List worksheetList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), WorksheetListOutlineForSeerOutputDTO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(worksheetList);
        return result;
    }

    public List<SpaceSpecialDTO> querySpecialBySpace(SpaceSpecialQueryInputBO spaceSpecialQueryInputBO) {
        log.info("\u63a5\u53e3 querySpecialBySpace ,\u63a5\u53d7\u53c2\u6570:{}", (Object)spaceSpecialQueryInputBO);
        BaseResponse response = this.workSheetFacade.querySpecialBySpace((SpaceSpecialQueryDTO)IFWBeanCopyUtil.map((Object)spaceSpecialQueryInputBO, SpaceSpecialQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 querySpecialBySpace ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public List<QueryCheckPointByDeptDTO> getCheckPointIdListByScan(ScanQueryInputBO scanQueryInputBO) {
        log.info("\u63a5\u53e3 getCheckPointIdListByScan ,\u63a5\u53d7\u53c2\u6570:{}", (Object)scanQueryInputBO);
        BaseResponse response = this.checkpoinAssetFacade.queryCheckPointByDept((QueryByDeptQueryDTO)IFWBeanCopyUtil.map((Object)scanQueryInputBO, QueryByDeptQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCheckPointIdListByScan ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    private WorksheetOperateDTO convert(WorksheetOperateInputBO worksheetOperateInputBO) {
        WorksheetOperateDTO worksheetOperateDTO = (WorksheetOperateDTO)IFWBeanCopyUtil.map((Object)worksheetOperateInputBO, WorksheetOperateDTO.class);
        worksheetOperateDTO.setEventConsumptionDTO((EventConsumptionDTO)IFWBeanCopyUtil.map((Object)worksheetOperateInputBO.getEventConsumption(), EventConsumptionDTO.class));
        worksheetOperateDTO.setTaskWorksheetUpdateDTO((TaskWorksheetUpdateDTO)IFWBeanCopyUtil.map((Object)worksheetOperateInputBO.getTaskWorksheet(), TaskWorksheetUpdateDTO.class));
        worksheetOperateDTO.setWorksheetEventDTO((WorksheetEventDTO)IFWBeanCopyUtil.map((Object)worksheetOperateInputBO.getWorksheetEvent(), WorksheetEventDTO.class));
        if (worksheetOperateInputBO.getWorksheetEventPictureList() != null) {
            worksheetOperateDTO.setWorksheetEventPictureDTOList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetOperateInputBO.getWorksheetEventPictureList(), WorksheetEventPictureDTO.class));
        }
        if (worksheetOperateInputBO.getWorksheetEventPositionList() != null) {
            worksheetOperateDTO.setWorksheetEventPositionDTOList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetOperateInputBO.getWorksheetEventPositionList(), WorksheetEventPositionDTO.class));
        }
        if (worksheetOperateInputBO.getWorksheetEventUserList() != null) {
            worksheetOperateDTO.setWorksheetEventUserDTOList(IFWBeanCopyUtil.mapAsList((Iterable)worksheetOperateInputBO.getWorksheetEventUserList(), WorksheetEventUserDTO.class));
        }
        return worksheetOperateDTO;
    }

    public IFWPageInfo<SpecialWorksheetDTO> getSpecialListBySpace(QuerySpecialListBySpaceInputBO querySpecialListBySpaceInputBO) {
        log.info("\u63a5\u53e3 getSpecialListBySpace ,\u63a5\u53d7\u53c2\u6570:{}", (Object)querySpecialListBySpaceInputBO);
        BaseResponse response = this.seerFacade.getSpecialListBySpace((QuerySpecialListBySpaceDTO)IFWBeanCopyUtil.map((Object)querySpecialListBySpaceInputBO, QuerySpecialListBySpaceDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getSpecialListBySpace ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (IFWPageInfo)response.getData();
    }

    public List<ScanDetailInfoOutputBO> getScanInfoByWorksheetId(WorksheetDetailQueryInputBO worksheetDetailQueryInputBO) {
        log.info("\u63a5\u53e3 getScanInfoByWorksheetId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetDetailQueryInputBO);
        BaseResponse response = this.workSheetFacade.getScanInfoByWorksheetId((QueryDailyWorksheetScanDTO)IFWBeanCopyUtil.map((Object)worksheetDetailQueryInputBO, QueryDailyWorksheetScanDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getScanInfoByWorksheetId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<Object> result = new ArrayList<ScanDetailInfoOutputBO>();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            result = IFWBeanCopyUtil.mapAsList((Iterable)data, ScanDetailInfoOutputBO.class);
        }
        return result;
    }

    public Object hangUpWorksheet(HangUpWorksheetInputBO hangUpWorksheetInputBO) {
        log.info("\u63a5\u53e3 hangUpWorksheet ,\u63a5\u53d7\u53c2\u6570:{}", (Object)hangUpWorksheetInputBO);
        BaseResponse response = this.workSheetFacade.hangUpWorksheet((HangUpWorksheetDTO)IFWBeanCopyUtil.map((Object)hangUpWorksheetInputBO, HangUpWorksheetDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 hangUpWorksheet ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData();
    }

    public IFWPageInfo<DailyTaskWorkSheetListOutputBO> getDailyWorksheetListForApp(DailyWorksheetListQueryInputBO dailyWorksheetListQueryInputBO) {
        log.info("\u63a5\u53e3 getDailyWorksheetListForApp ,\u63a5\u53d7\u53c2\u6570:{}", (Object)dailyWorksheetListQueryInputBO);
        BaseResponse response = this.workSheetFacade.getDailyWorksheetListForApp((DailyWorksheetListQueryDTO)IFWBeanCopyUtil.map((Object)dailyWorksheetListQueryInputBO, DailyWorksheetListQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getDailyWorksheetListForApp ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List dailyTaskWorkSheetListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), DailyTaskWorkSheetListOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        result.setTotal(data.getTotal());
        result.setList(dailyTaskWorkSheetListOutputBOList);
        return result;
    }

    public PatrolCheckResultOutputDTO patrolOnLineCheckPatrol(PatrolCheckInputBO patrolCheckInputBO) {
        log.info("\u63a5\u53e3 patrolOnLineCheckPatrol ,\u63a5\u53d7\u53c2\u6570:{}", (Object)patrolCheckInputBO);
        BaseResponse response = this.workSheetFacade.patrolOnLineCheckPatrol((PatrolCheckQueryDTO)IFWBeanCopyUtil.map((Object)patrolCheckInputBO, PatrolCheckQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 patrolOnLineCheckPatrol ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (PatrolCheckResultOutputDTO)IFWBeanCopyUtil.map((Object)response.getData(), PatrolCheckResultOutputDTO.class);
    }

    public PatrolCheckResultOutputDTO repairWorksheetStatusKafka() {
        log.info("\u63a5\u53e3 repairWorksheetStatusKafka ,\u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.workSheetFacade.repairWorksheetStatusKafka();
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 repairWorksheetStatusKafka ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (PatrolCheckResultOutputDTO)IFWBeanCopyUtil.map((Object)response.getData(), PatrolCheckResultOutputDTO.class);
    }
}

