/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.QueryScanResultByCheckpointIdDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventDetailQueryDTO;
import com.ifourthwall.dbm.task.dto.WorksheetEventWrapDTO;
import com.ifourthwall.dbm.task.facade.WorkSheetEventFacade;
import com.ifourthwall.dbm.tracker.bo.CheckpointScanResultOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryScanResultByCheckpointIdInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetEventWrapOutputBO;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="worksheetEventRepository")
public class WorksheetEventRepository {
    private static final Logger log = LoggerFactory.getLogger(WorksheetEventRepository.class);
    @Reference(version="3.0.0")
    WorkSheetEventFacade workSheetEventFacade;

    public WorksheetEventWrapOutputBO getWorksheetEventDetail(WorksheetEventDetailQueryInputBO worksheetEventDetailQueryInputBO) {
        BaseResponse response = this.workSheetEventFacade.getWorksheetEventDetail((WorksheetEventDetailQueryDTO)IFWBeanCopyUtil.map((Object)worksheetEventDetailQueryInputBO, WorksheetEventDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        WorksheetEventWrapDTO data = (WorksheetEventWrapDTO)response.getData();
        WorksheetEventWrapOutputBO worksheetEventWrapOutputBO = (WorksheetEventWrapOutputBO)IFWBeanCopyUtil.map((Object)data, WorksheetEventWrapOutputBO.class);
        return worksheetEventWrapOutputBO;
    }

    public IFWPageInfo<CheckpointScanResultOutputBO> getScanInfoByCheckpoint(QueryScanResultByCheckpointIdInputBO queryScanResultByCheckpointIdInputBO) {
        log.info("\u63a5\u53e3 getScanInfoByCheckpoint ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryScanResultByCheckpointIdInputBO);
        BaseResponse response = this.workSheetEventFacade.getScanInfoByCheckpoint((QueryScanResultByCheckpointIdDTO)IFWBeanCopyUtil.map((Object)queryScanResultByCheckpointIdInputBO, QueryScanResultByCheckpointIdDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getScanInfoByCheckpoint ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo result = new IFWPageInfo();
        ArrayList queryCheckPointListOutputBOList = new ArrayList();
        IFWPageInfo data = (IFWPageInfo)response.getData();
        if (data != null) {
            List list = data.getList();
            if (list != null && !list.isEmpty()) {
                queryCheckPointListOutputBOList.addAll(IFWBeanCopyUtil.mapAsList((Iterable)list, CheckpointScanResultOutputBO.class));
            }
            result.setList(queryCheckPointListOutputBOList);
            result.setPageSize(data.getPageSize());
            result.setPageNum(data.getPageNum());
            result.setTotal(data.getTotal());
        }
        return result;
    }
}

