/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.common.utils.IFWUUIDUtils;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.message.facade.dto.PushMessageReqDTO;
import com.ifourthwall.dbm.message.facade.service.MessageServiceFacade;
import com.ifourthwall.dbm.project.dto.GetProjectSpaceInfoQueryDTO;
import com.ifourthwall.dbm.project.dto.QueryProjectPageDTO;
import com.ifourthwall.dbm.tracker.bo.AliMessageContentBO;
import com.ifourthwall.dbm.tracker.bo.JPushMessageBO;
import com.ifourthwall.dbm.tracker.bo.QueryResEmployeeOutputBO;
import com.ifourthwall.dbm.tracker.bo.SendPushParamBO;
import com.ifourthwall.dbm.tracker.bo.SpaceMessageDTO;
import com.ifourthwall.dbm.tracker.bo.TaskAssetOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskInsertBO;
import com.ifourthwall.dbm.tracker.bo.TaskSpaceInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionExecutorQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWorksheetOutputBO;
import com.ifourthwall.dbm.tracker.bo.TemporaryTaskWorksheetWrapOutputBO;
import com.ifourthwall.dbm.tracker.bo.ThirdBindPushQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ThirdMessagePushWrapBO;
import com.ifourthwall.dbm.tracker.bo.TrackerMessageBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetExecutorOutputBO;
import com.ifourthwall.dbm.tracker.domain.ConfigRepository;
import com.ifourthwall.dbm.tracker.domain.OrganizationRepository;
import com.ifourthwall.dbm.tracker.domain.TaskRepository;
import com.ifourthwall.dbm.tracker.domain.ThirdBindPushRepository;
import com.ifourthwall.dbm.tracker.domain.WorksheetRepository;
import com.ifourthwall.dbm.tracker.dto.PositionDTO;
import com.ifourthwall.dbm.tracker.dto.TemporaryTaskWorksheetWrapOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ThirdPushBindOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ThirdPushWorksheetDetailDTO;
import com.ifourthwall.dbm.tracker.dto.WorksheetEventSupperWrapOutputDTO;
import com.ifourthwall.dbm.tracker.service.WorksheetService;
import com.ifourthwall.kafka.IFWKafkaClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="trackerPushRepository")
@DependsOn(value={"trackerConfiguration"})
public class TrackerPushRepository {
    private static final Logger log = LoggerFactory.getLogger(TrackerPushRepository.class);
    @Reference(version="1.0.0")
    MessageServiceFacade messageServiceFacade;
    @Resource(name="worksheetRepository")
    WorksheetRepository worksheetRepository;
    @Resource(name="taskRepository")
    TaskRepository taskRepository;
    @Resource(name="organizationRepository")
    OrganizationRepository organizationRepository;
    @Resource(name="configRepository")
    ConfigRepository configRepository;
    @Resource(name="thirdBindPushRepository")
    ThirdBindPushRepository thirdBindPushRepository;
    @Resource(name="worksheetServiceImpl")
    WorksheetService worksheetService;
    @Autowired
    RedisTemplate redisTemplate;
    @Resource(name="IFWKafkaClient-dbm_tracker_send_message_to_third")
    private IFWKafkaClient ifwKafkaClient;

    public void sendMessageByTemplate(SendPushParamBO sendPushParamBO) {
        TrackerMessageBO messageBO = this.getTrackerMessageBO(sendPushParamBO);
        List<Object> positionIdList = new ArrayList();
        List<Object> userIdList = new ArrayList();
        if (messageBO != null) {
            List queryResEmployeeOutputBOList;
            List worksheetExecutorList;
            TaskTemplatePermissionExecutorQueryInputBO taskTemplatePermissionExecutorQueryInputBO = new TaskTemplatePermissionExecutorQueryInputBO();
            taskTemplatePermissionExecutorQueryInputBO.setTaskTemplateId(messageBO.getTaskTemplateId());
            if (StringUtils.equals((CharSequence)"1", (CharSequence)messageBO.getWorksheetStatusId())) {
                taskTemplatePermissionExecutorQueryInputBO.setPermissionTaskOperationId("5");
            } else if (StringUtils.equals((CharSequence)"5", (CharSequence)messageBO.getWorksheetStatusId()) || StringUtils.equals((CharSequence)"3", (CharSequence)messageBO.getWorksheetStatusId())) {
                taskTemplatePermissionExecutorQueryInputBO.setPermissionTaskOperationId("11");
            } else if (StringUtils.equals((CharSequence)"4", (CharSequence)messageBO.getWorksheetStatusId())) {
                taskTemplatePermissionExecutorQueryInputBO.setPermissionTaskOperationId("18");
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)messageBO.getWorksheetStatusId()) && !CollectionUtils.isEmpty((Collection)(worksheetExecutorList = messageBO.getWorksheetExecutorList()))) {
                userIdList = worksheetExecutorList.stream().filter(item -> !StringUtils.isBlank((CharSequence)item.getExecutorUserId())).map(WorksheetExecutorOutputBO::getExecutorUserId).distinct().collect(Collectors.toList());
                positionIdList = worksheetExecutorList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getExecutorUserId()) && !StringUtils.isBlank((CharSequence)item.getExecutorPositionId())).map(WorksheetExecutorOutputBO::getExecutorPositionId).distinct().collect(Collectors.toList());
            }
            if (!StringUtils.equals((CharSequence)"2", (CharSequence)messageBO.getWorksheetStatusId())) {
                taskTemplatePermissionExecutorQueryInputBO.setLanguageCode(sendPushParamBO.getLanguageCode());
                taskTemplatePermissionExecutorQueryInputBO.setTenantId(sendPushParamBO.getTenantId());
                List taskExecutor = this.taskRepository.getTaskExecutor(taskTemplatePermissionExecutorQueryInputBO);
                if (!CollectionUtils.isEmpty((Collection)taskExecutor)) {
                    positionIdList = taskExecutor.stream().map(PositionDTO::getPositionId).collect(Collectors.toList());
                }
            }
            if (!CollectionUtils.isEmpty(positionIdList) && !CollectionUtils.isEmpty((Collection)(queryResEmployeeOutputBOList = this.organizationRepository.queryPositionAndEmployeeByPositionId(positionIdList, sendPushParamBO.getTenantId(), sendPushParamBO.getLanguageCode())))) {
                userIdList = queryResEmployeeOutputBOList.stream().map(QueryResEmployeeOutputBO::getUserId).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(userIdList)) {
                this.sendBatchPush(userIdList, this.getPushMessageReqDTO(sendPushParamBO), messageBO);
            }
        }
    }

    public PushMessageReqDTO getPushMessageReqDTO(SendPushParamBO sendPushParamBO) {
        PushMessageReqDTO pushMessageReqDTO = new PushMessageReqDTO();
        pushMessageReqDTO.setTenantId(sendPushParamBO.getTenantId());
        pushMessageReqDTO.setProjectId(sendPushParamBO.getProjectId());
        pushMessageReqDTO.setGodzillaDeviceTypes("0,1,2");
        pushMessageReqDTO.setMessageType("0");
        return pushMessageReqDTO;
    }

    public TrackerMessageBO getTrackerMessageBO(SendPushParamBO sendPushParamBO) {
        List taskAssetList;
        TrackerMessageBO trackerMessageBO = null;
        WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = new WorksheetDetailQueryInputBO();
        worksheetDetailQueryInputBO.setProjectId(sendPushParamBO.getProjectId());
        worksheetDetailQueryInputBO.setTenantId(sendPushParamBO.getTenantId());
        worksheetDetailQueryInputBO.setLanguageCode(sendPushParamBO.getLanguageCode());
        worksheetDetailQueryInputBO.setTaskId(sendPushParamBO.getTaskId());
        worksheetDetailQueryInputBO.setTaskWorksheetId(sendPushParamBO.getTaskWorksheetId());
        GetProjectSpaceInfoQueryDTO getProjectSpaceInfoQueryDTO = new GetProjectSpaceInfoQueryDTO();
        getProjectSpaceInfoQueryDTO.setProjectId(sendPushParamBO.getProjectId());
        getProjectSpaceInfoQueryDTO.setTenantId(sendPushParamBO.getTenantId());
        getProjectSpaceInfoQueryDTO.setLanguageCode(sendPushParamBO.getLanguageCode());
        QueryProjectPageDTO projectSpaceInfo = this.organizationRepository.getProjectSpaceInfo(getProjectSpaceInfoQueryDTO);
        TemporaryTaskWorksheetWrapOutputBO temporaryTaskWorksheetDetail = this.worksheetRepository.getTemporaryTaskWorksheetDetail(worksheetDetailQueryInputBO);
        if (temporaryTaskWorksheetDetail == null || temporaryTaskWorksheetDetail.getTask() == null || temporaryTaskWorksheetDetail.getTaskWorksheet() == null) {
            return null;
        }
        TaskWorksheetOutputBO taskWorksheet = temporaryTaskWorksheetDetail.getTaskWorksheet();
        List worksheetExecutorList = temporaryTaskWorksheetDetail.getWorksheetExecutorList();
        TaskInsertBO task = temporaryTaskWorksheetDetail.getTask();
        trackerMessageBO = new TrackerMessageBO();
        trackerMessageBO.setTaskWorksheetId(taskWorksheet.getTaskWorksheetId());
        trackerMessageBO.setWorksheetNo(taskWorksheet.getWorksheetNo());
        trackerMessageBO.setWorksheetStatusId(taskWorksheet.getWorksheetStatusId());
        trackerMessageBO.setCreateTime(new Date());
        trackerMessageBO.setSpecialFlag(taskWorksheet.getSpecicalFlag());
        trackerMessageBO.setTaskName(task.getTaskName());
        trackerMessageBO.setTaskTypeId(task.getTaskTypeId());
        trackerMessageBO.setProjectId(sendPushParamBO.getProjectId());
        trackerMessageBO.setTenantId(sendPushParamBO.getTenantId());
        if (projectSpaceInfo != null) {
            trackerMessageBO.setProjectName(projectSpaceInfo.getProjectName());
        }
        if (!CollectionUtils.isEmpty((Collection)worksheetExecutorList)) {
            trackerMessageBO.setWorksheetExecutorList(worksheetExecutorList);
        }
        trackerMessageBO.setTaskTemplateId(task.getTaskTemplateId());
        List taskSpaceList = temporaryTaskWorksheetDetail.getTaskSpaceList();
        if (!CollectionUtils.isEmpty((Collection)taskSpaceList)) {
            List spaceIdList = taskSpaceList.stream().map(TaskSpaceInsertInputBO::getSpaceId).collect(Collectors.toList());
            List spaceList = this.configRepository.querySpaceNameBySpaceList(spaceIdList, sendPushParamBO.getTenantId(), sendPushParamBO.getLanguageCode(), sendPushParamBO.getProjectId());
            trackerMessageBO.setSpaceMessageList(IFWBeanCopyUtil.mapAsList((Iterable)spaceList, SpaceMessageDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)(taskAssetList = temporaryTaskWorksheetDetail.getTaskAssetList()))) {
            List assetIdList = taskAssetList.stream().map(TaskAssetOutputBO::getAssetId).collect(Collectors.toList());
            List assetName = this.configRepository.getAssetName(sendPushParamBO.getTenantId(), sendPushParamBO.getProjectId(), sendPushParamBO.getLanguageCode(), assetIdList);
            if (!CollectionUtils.isEmpty((Collection)assetName)) {
                trackerMessageBO.setTaskAssetList(IFWBeanCopyUtil.mapAsList((Iterable)assetName, TaskAssetOutputBO.class));
            }
        }
        trackerMessageBO.setMessageType("0");
        return trackerMessageBO;
    }

    public void sendBatchPush(List<String> userIdList, PushMessageReqDTO pushMessageReqDTO, TrackerMessageBO trackerMessageBO) {
        if (!CollectionUtils.isEmpty(userIdList)) {
            log.info("\u672a\u53bb\u91cd{}", userIdList);
            HashSet<String> set = new HashSet<String>(userIdList);
            log.info("\u53bb\u91cd{}", set);
            ArrayList pushMessageReqDTOList = new ArrayList();
            set.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            log.info("\u53d1\u9001\u7ad9\u5185\u6d88\u606f{}", pushMessageReqDTOList);
            BaseResponse response = this.messageServiceFacade.batchPush(pushMessageReqDTOList);
            log.info("\u53d1\u9001\u7ad9\u5185\u6d88\u606f\u7ed3\u675f{}", (Object)response);
            JPushMessageBO pushMessageBO = new JPushMessageBO();
            pushMessageBO.setAliaList(new ArrayList<String>(set));
            pushMessageBO.setContent(JSONUtils.jacksonToJson((Object)IFWBeanCopyUtil.map((Object)trackerMessageBO, AliMessageContentBO.class)));
            log.info("\u53d1\u9001\u963f\u91cc\u4e91\u6d88\u606f{}", (Object)pushMessageBO);
            this.configRepository.sendPush(pushMessageBO);
            ThirdBindPushQueryInputBO thirdBindPushQueryInputBO = new ThirdBindPushQueryInputBO();
            thirdBindPushQueryInputBO.setTenantId(pushMessageReqDTO.getTenantId());
            List thirdPushBindOutputDTOS = this.thirdBindPushRepository.queryThirdPushBind(thirdBindPushQueryInputBO);
            if (!CollectionUtils.isEmpty((Collection)thirdPushBindOutputDTOS)) {
                log.info("\u5f00\u59cb\u53d1\u9001\u7b2c\u4e09\u65b9\u6d88\u606f{}");
                ThirdPushBindOutputDTO thirdPushBindOutputDTO = (ThirdPushBindOutputDTO)thirdPushBindOutputDTOS.get(0);
                WorksheetDetailQueryInputBO worksheetDetailQueryInputBO = new WorksheetDetailQueryInputBO();
                worksheetDetailQueryInputBO.setTaskWorksheetId(trackerMessageBO.getTaskWorksheetId());
                worksheetDetailQueryInputBO.setLanguageCode(thirdPushBindOutputDTO.getLanguageCode());
                worksheetDetailQueryInputBO.setTenantId(pushMessageReqDTO.getTenantId());
                worksheetDetailQueryInputBO.setProjectId(pushMessageReqDTO.getProjectId());
                IFWUser ifwUser = new IFWUser();
                ifwUser.setTenantId(pushMessageReqDTO.getTenantId());
                BaseResponse dtoBaseResponse = this.worksheetService.getTemporaryTaskWorksheetDetail(ifwUser, worksheetDetailQueryInputBO);
                TemporaryTaskWorksheetWrapOutputDTO data = (TemporaryTaskWorksheetWrapOutputDTO)dtoBaseResponse.getData();
                ThirdPushWorksheetDetailDTO pushData = null;
                if (data != null) {
                    pushData = (ThirdPushWorksheetDetailDTO)IFWBeanCopyUtil.map((Object)data, ThirdPushWorksheetDetailDTO.class);
                    List worksheetEventSupperWrapList = data.getWorksheetEventSupperWrapList();
                    if (!CollectionUtils.isEmpty((Collection)worksheetEventSupperWrapList)) {
                        WorksheetEventSupperWrapOutputDTO worksheetEventSupperWrapOutputDTO = (WorksheetEventSupperWrapOutputDTO)worksheetEventSupperWrapList.get(0);
                        pushData.setWorksheetEvent(worksheetEventSupperWrapOutputDTO);
                    }
                }
                ThirdMessagePushWrapBO thirdMessagePushWrapBO = new ThirdMessagePushWrapBO();
                thirdMessagePushWrapBO.setThirdPushBind(thirdPushBindOutputDTO);
                thirdMessagePushWrapBO.setThirdPushWorksheetDetail(pushData);
                thirdMessagePushWrapBO.setValidDate(new Date());
                thirdMessagePushWrapBO.setIndex(Integer.valueOf(0));
                thirdMessagePushWrapBO.setMessageId(IFWUUIDUtils.randomUUID());
                log.info("\u53d1\u9001\u7b2c\u4e09\u65b9\u6d88\u606f\u5230kafka{}", (Object)thirdMessagePushWrapBO);
                this.ifwKafkaClient.syncProduce(JSONUtils.jacksonToJson((Object)thirdMessagePushWrapBO));
                log.info("\u53d1\u9001\u7b2c\u4e09\u65b9\u6d88\u606f\u5230kafka\u7ed3\u675f{}");
            }
        }
    }
}

