/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.SentryQueryTaskQuDTO;
import com.ifourthwall.dbm.asset.facade.MonitorFacade;
import com.ifourthwall.dbm.security.dto.QuTaskTemplateIdReqDTO;
import com.ifourthwall.dbm.security.dto.task.QueryTemplateUseQuDTO;
import com.ifourthwall.dbm.security.facade.CameraTaskFacade;
import com.ifourthwall.dbm.security.facade.DeviceSpaceObjectFacade;
import com.ifourthwall.dbm.task.dto.ObjectPositionQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateInsertDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateInsertWrapDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateListByOperationQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplatePermissionRelationDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplatePermissionRelationQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateQueryByIdListDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateTagDetailQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateTagInsertDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateTagQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateTagUpdateDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateUpdateDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateUpdateWrapDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateWarpQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplateWrapDTO;
import com.ifourthwall.dbm.task.facade.TaskTemplateFacade;
import com.ifourthwall.dbm.tracker.bo.BaseInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateInsertWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionRelationQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateQueryByIdListInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagQueryDetailInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateTagUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateUpdateWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateWarpQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplateWrapOutputBO;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="taskTemplateRepository")
public class TaskTemplateRepository {
    private static final Logger log = LoggerFactory.getLogger(TaskTemplateRepository.class);
    @Reference(version="3.0.0")
    TaskTemplateFacade taskTemplateFacade;
    @Reference(version="1.0.0")
    MonitorFacade monitorFacade;
    @Reference(version="1.0.0")
    DeviceSpaceObjectFacade deviceSpaceObjectFacade;
    @Reference(version="1.0.0")
    CameraTaskFacade cameraTaskFacade;

    public void createTaskTemplateTag(TaskTemplateTagInsertInputBO taskTemplateTagInsertInputBO) {
        log.info("\u63a5\u53e3 createTaskTemplateTag ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateTagInsertInputBO);
        BaseResponse response = this.taskTemplateFacade.createTaskTemplateTag((TaskTemplateTagInsertDTO)IFWBeanCopyUtil.map((Object)taskTemplateTagInsertInputBO, TaskTemplateTagInsertDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createTaskTemplateTag ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void updateTaskTemplateTag(TaskTemplateTagUpdateInputBO taskTemplateTagUpdateInputBO) {
        log.info("\u63a5\u53e3 updateTaskTemplateTag ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateTagUpdateInputBO);
        BaseResponse response = this.taskTemplateFacade.updateTaskTemplateTag((TaskTemplateTagUpdateDTO)IFWBeanCopyUtil.map((Object)taskTemplateTagUpdateInputBO, TaskTemplateTagUpdateDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateTaskTemplateTag ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public TaskTemplateTagOutputBO queryTaskTemplateTagDetail(TaskTemplateTagQueryDetailInputBO taskTemplateTagQueryDetailInputBO) {
        log.info("\u63a5\u53e3 queryTaskTemplateTagDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateTagQueryDetailInputBO);
        BaseResponse response = this.taskTemplateFacade.queryTaskTemplateTagDetail((TaskTemplateTagDetailQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplateTagQueryDetailInputBO, TaskTemplateTagDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryTaskTemplateTagDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (TaskTemplateTagOutputBO)IFWBeanCopyUtil.map((Object)response.getData(), TaskTemplateTagOutputBO.class);
    }

    public List<TaskTemplateTagOutputBO> getTaskTemplateTagList(BaseInputBO baseInputBO) {
        log.info("\u63a5\u53e3 getTaskTemplateTagList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)baseInputBO);
        BaseResponse response = this.taskTemplateFacade.getTaskTemplateTagList((TaskTemplateTagQueryDTO)IFWBeanCopyUtil.map((Object)baseInputBO, TaskTemplateTagQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskTemplateTagList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), TaskTemplateTagOutputBO.class);
    }

    public List<TaskTemplateTagOutputBO> getTaskTemplateTagListByTaskTemplateId(TaskTemplateTagQueryInputBO taskTemplateTagQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskTemplateTagListByTaskTemplateId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateTagQueryInputBO);
        BaseResponse response = this.taskTemplateFacade.getTaskTemplateTagListByTaskTemplateId((TaskTemplateTagQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplateTagQueryInputBO, TaskTemplateTagQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskTemplateTagListByTaskTemplateId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), TaskTemplateTagOutputBO.class);
    }

    public void createTaskTemplate(TaskTemplateInsertWrapInputBO taskTemplateInsertWrapInputBO) {
        log.info("\u63a5\u53e3 createTaskTemplate ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateInsertWrapInputBO);
        TaskTemplateInsertWrapDTO taskTemplateInsertWrapDTO = new TaskTemplateInsertWrapDTO();
        TaskTemplateInsertDTO taskTemplateInsertDTO = (TaskTemplateInsertDTO)IFWBeanCopyUtil.map((Object)taskTemplateInsertWrapInputBO, TaskTemplateInsertDTO.class);
        List taskTemplatePermissionRelationDTOS = IFWBeanCopyUtil.mapAsList((Iterable)taskTemplateInsertWrapInputBO.getTaskTemplatePermissionList(), TaskTemplatePermissionRelationDTO.class);
        List taskTemplateTagList = taskTemplateInsertWrapInputBO.getTaskTemplateTagList();
        if (taskTemplateTagList != null && !taskTemplateTagList.isEmpty()) {
            ArrayList taskTemplateTagReleationDTOList = new ArrayList();
            taskTemplateTagList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
            taskTemplateInsertWrapDTO.setTaskTemplateTagReleationDTOList(taskTemplateTagReleationDTOList);
        }
        taskTemplateInsertWrapDTO.setTaskTemplateInsertDTO(taskTemplateInsertDTO);
        taskTemplateInsertWrapDTO.setTaskTemplatePermissionRelationDTOList(taskTemplatePermissionRelationDTOS);
        BaseResponse response = this.taskTemplateFacade.createTaskTemplate(taskTemplateInsertWrapDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createTaskTemplate ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public List<TaskTemplateOutputBO> getTaskTemplateList(TaskTemplateListQueryInputBO taskTemplateListQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskTemplateList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateListQueryInputBO);
        BaseResponse response = this.taskTemplateFacade.getTaskTemplateList((TaskTemplateListByOperationQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplateListQueryInputBO, TaskTemplateListByOperationQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskTemplateList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), TaskTemplateOutputBO.class);
    }

    public List<TaskTemplateOutputBO> selectTaskTemplateWithInvalidList(TaskTemplateListQueryInputBO taskTemplateListQueryInputBO) {
        log.info("\u63a5\u53e3 selectTaskTemplateWithInvalidList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateListQueryInputBO);
        BaseResponse response = this.taskTemplateFacade.selectTaskTemplateWithInvalidList((TaskTemplateListByOperationQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplateListQueryInputBO, TaskTemplateListByOperationQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 selectTaskTemplateWithInvalidList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), TaskTemplateOutputBO.class);
    }

    public TaskTemplateWrapOutputBO getTaskTemplateDetail(TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskTemplateDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateWarpQueryInputBO);
        BaseResponse response = this.taskTemplateFacade.getTaskTemplateDetail((TaskTemplateWarpQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplateWarpQueryInputBO, TaskTemplateWarpQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskTemplateDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        TaskTemplateWrapOutputBO taskTemplateWrapOutputBO = new TaskTemplateWrapOutputBO();
        TaskTemplateWrapDTO data = (TaskTemplateWrapDTO)response.getData();
        if (data != null) {
            TaskTemplateDTO taskTemplateDTO = data.getTaskTemplateDTO();
            List taskTemplatePermissionList = data.getTaskTemplatePermissionList();
            List taskTemplateTagDetailDTOList = data.getTaskTemplateTagDetailDTOList();
            if (taskTemplateDTO != null) {
                taskTemplateWrapOutputBO.setTaskTemplate((TaskTemplateOutputBO)IFWBeanCopyUtil.map((Object)taskTemplateDTO, TaskTemplateOutputBO.class));
            }
            if (taskTemplatePermissionList != null && !taskTemplatePermissionList.isEmpty()) {
                taskTemplateWrapOutputBO.setTaskTemplatePermissionList(IFWBeanCopyUtil.mapAsList((Iterable)taskTemplatePermissionList, TaskTemplatePermissionOutputBO.class));
            }
            if (taskTemplateTagDetailDTOList != null && !taskTemplateTagDetailDTOList.isEmpty()) {
                taskTemplateWrapOutputBO.setTaskTemplateTagList(IFWBeanCopyUtil.mapAsList((Iterable)taskTemplateTagDetailDTOList, TaskTemplateTagOutputBO.class));
            }
        }
        return taskTemplateWrapOutputBO;
    }

    public void deleteTaskTemplate(TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        log.info("\u63a5\u53e3 deleteTaskTemplate ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateWarpQueryInputBO);
        BaseResponse response = this.taskTemplateFacade.deleteTaskTemplate((TaskTemplateWarpQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplateWarpQueryInputBO, TaskTemplateWarpQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 deleteTaskTemplate ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public boolean sentryQueryTask(TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        log.info("\u63a5\u53e3 sentryQueryTask ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateWarpQueryInputBO);
        SentryQueryTaskQuDTO sentryQueryTaskQuDTO = new SentryQueryTaskQuDTO();
        ArrayList<String> taskTemplateId = new ArrayList<String>();
        sentryQueryTaskQuDTO.setLanguageCode(taskTemplateWarpQueryInputBO.getLanguageCode());
        sentryQueryTaskQuDTO.setTenantId(taskTemplateWarpQueryInputBO.getTenantId());
        taskTemplateId.add(taskTemplateWarpQueryInputBO.getTaskTemplateId());
        sentryQueryTaskQuDTO.setTaskTemplateId(taskTemplateId);
        BaseResponse response = this.monitorFacade.sentryQueryTask(sentryQueryTaskQuDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 sentryQueryTask ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (Boolean)response.getData();
    }

    public boolean queryTaskTempId(TaskTemplateWarpQueryInputBO taskTemplateWarpQueryInputBO) {
        log.info("\u63a5\u53e3 queryTaskTempId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateWarpQueryInputBO);
        QuTaskTemplateIdReqDTO sentryQueryTaskQuDTO = new QuTaskTemplateIdReqDTO();
        sentryQueryTaskQuDTO.setTenantId(taskTemplateWarpQueryInputBO.getTenantId());
        sentryQueryTaskQuDTO.setProjectId(taskTemplateWarpQueryInputBO.getProjectId());
        sentryQueryTaskQuDTO.setTaskTemplateId(taskTemplateWarpQueryInputBO.getTaskTemplateId());
        BaseResponse response = this.deviceSpaceObjectFacade.queryTaskTemplateId(sentryQueryTaskQuDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryTaskTempId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (Boolean)response.getData();
    }

    public boolean queryTemplateUse(QueryTemplateUseQuDTO queryTemplateUseQuDTO) {
        log.info("\u63a5\u53e3 queryTemplateUse ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryTemplateUseQuDTO);
        BaseResponse response = this.cameraTaskFacade.queryTemplateUse(queryTemplateUseQuDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryTemplateUse ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (Boolean)response.getData();
    }

    public void updateTaskTemplate(TaskTemplateUpdateWrapInputBO taskTemplateUpdateWrapInputBO) {
        log.info("\u63a5\u53e3 updateTaskTemplate ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateUpdateWrapInputBO);
        TaskTemplateUpdateWrapDTO taskTemplateUpdateWrapDTO = new TaskTemplateUpdateWrapDTO();
        taskTemplateUpdateWrapDTO.setTaskTemplateUpdateDTO((TaskTemplateUpdateDTO)IFWBeanCopyUtil.map((Object)taskTemplateUpdateWrapInputBO, TaskTemplateUpdateDTO.class));
        List taskTemplateTagList = taskTemplateUpdateWrapInputBO.getTaskTemplateTagList();
        ArrayList taskTemplateTagReleationDTOList = new ArrayList();
        if (taskTemplateTagList != null && !taskTemplateTagList.isEmpty()) {
            taskTemplateTagList.stream().forEach(new /* Unavailable Anonymous Inner Class!! */);
        }
        taskTemplateUpdateWrapDTO.setTaskTemplateTagReleationDTOList(taskTemplateTagReleationDTOList);
        taskTemplateUpdateWrapDTO.setTaskTemplatePermissionRelationDTOList(IFWBeanCopyUtil.mapAsList((Iterable)taskTemplateUpdateWrapInputBO.getTaskTemplatePermissionList(), TaskTemplatePermissionRelationDTO.class));
        BaseResponse response = this.taskTemplateFacade.updateTaskTemplate(taskTemplateUpdateWrapDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateTaskTemplate ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public List<String> getTaskTemplatePermissionByOperationId(TaskTemplatePermissionRelationQueryInputBO taskTemplatePermissionRelationQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskTemplatePermissionByOperationId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplatePermissionRelationQueryInputBO);
        BaseResponse response = this.taskTemplateFacade.getTaskTemplatePermissionByOperationId((TaskTemplatePermissionRelationQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplatePermissionRelationQueryInputBO, TaskTemplatePermissionRelationQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskTemplatePermissionByOperationId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public List<TaskTemplatePermissionOutputBO> selectTaskTemplateListByOperation(TaskTemplateQueryByIdListInputBO taskTemplateQueryByIdListInputBO) {
        log.info("\u63a5\u53e3 selectTaskTemplateListByOperation ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplateQueryByIdListInputBO);
        BaseResponse response = this.taskTemplateFacade.selectTaskTemplateListByOperation((TaskTemplateQueryByIdListDTO)IFWBeanCopyUtil.map((Object)taskTemplateQueryByIdListInputBO, TaskTemplateQueryByIdListDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 selectTaskTemplateListByOperation ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List<Object> result = new ArrayList<TaskTemplatePermissionOutputBO>();
        List data = (List)response.getData();
        if (data != null && !data.isEmpty()) {
            result = IFWBeanCopyUtil.mapAsList((Iterable)data, TaskTemplatePermissionOutputBO.class);
        }
        return result;
    }

    public List<String> getObjectPositionIdList(ObjectPositionQueryDTO objectPositionQueryDTO) {
        log.info("\u63a5\u53e3 getObjectPositionIdList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)objectPositionQueryDTO);
        BaseResponse response = this.taskTemplateFacade.getObjectPositionIdByOperationId(objectPositionQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getObjectPositionIdList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }
}

