/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.QueryCheckpointRelationByIdDTO;
import com.ifourthwall.dbm.task.dto.QueryWorksheetByUserDTO;
import com.ifourthwall.dbm.task.dto.ServiceSupplierListQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskDetailQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskListDTO;
import com.ifourthwall.dbm.task.dto.TaskListPageQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskOperateDTO;
import com.ifourthwall.dbm.task.dto.TaskTemplatePermissionExecutorQueryDTO;
import com.ifourthwall.dbm.task.dto.TaskWrapDetailDTO;
import com.ifourthwall.dbm.task.dto.TaskWrapInsertDTO;
import com.ifourthwall.dbm.task.dto.WorksheetByUserDTO;
import com.ifourthwall.dbm.task.dto.WorksheetScanQueryDTO;
import com.ifourthwall.dbm.task.facade.TaskFacade;
import com.ifourthwall.dbm.tracker.bo.CustomizeTaskCycleInputBO;
import com.ifourthwall.dbm.tracker.bo.DailyTaskWorkSheetListOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckpointRelationByIdBO;
import com.ifourthwall.dbm.tracker.bo.QueryWorksheetByUserInputBO;
import com.ifourthwall.dbm.tracker.bo.ServiceSupplierListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ServiceSupplierOutputBO;
import com.ifourthwall.dbm.tracker.bo.SingleStringOutBO;
import com.ifourthwall.dbm.tracker.bo.TaskAssetOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskCheckPointRelationInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskExecutorInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskListOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskListPageQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskOperateInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskPictureInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskSpaceInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskTemplatePermissionExecutorQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapDetailOutputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.TaskWrapUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetScanQueryInputBO;
import com.ifourthwall.dbm.tracker.dto.PositionDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="taskRepository")
public class TaskRepository {
    private static final Logger log = LoggerFactory.getLogger(TaskRepository.class);
    @Reference(version="3.0.0")
    TaskFacade taskFacade;

    public SingleStringOutBO createTask(TaskWrapInsertInputBO taskWrapInsertInputBO) {
        log.info("\u63a5\u53e3 createTask ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskWrapInsertInputBO);
        TaskWrapInsertDTO taskWrapInsertDTO = (TaskWrapInsertDTO)IFWBeanCopyUtil.map((Object)taskWrapInsertInputBO, TaskWrapInsertDTO.class);
        BaseResponse response = this.taskFacade.createTask(taskWrapInsertDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createTask ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (SingleStringOutBO)IFWBeanCopyUtil.map((Object)response.getData(), SingleStringOutBO.class);
    }

    public Object operateTask(TaskOperateInputBO taskOperateBO) {
        log.info("\u63a5\u53e3 operateTask ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskOperateBO);
        BaseResponse response = this.taskFacade.operateTask((TaskOperateDTO)IFWBeanCopyUtil.map((Object)taskOperateBO, TaskOperateDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 operateTask ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData();
    }

    public List<PositionDTO> getTaskExecutor(TaskTemplatePermissionExecutorQueryInputBO taskTemplatePermissionExecutorQueryBO) {
        log.info("\u63a5\u53e3 getTaskExecutor ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskTemplatePermissionExecutorQueryBO);
        BaseResponse response = this.taskFacade.getTaskExecutor((TaskTemplatePermissionExecutorQueryDTO)IFWBeanCopyUtil.map((Object)taskTemplatePermissionExecutorQueryBO, TaskTemplatePermissionExecutorQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskExecutor ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        ArrayList<PositionDTO> list = new ArrayList<PositionDTO>();
        if (data != null && !data.isEmpty()) {
            for (int i = 0; i < data.size(); ++i) {
                PositionDTO positionDTO = new PositionDTO();
                positionDTO.setPositionId((String)data.get(i));
                list.add(positionDTO);
            }
        }
        return list;
    }

    public void updateTask(TaskWrapUpdateInputBO taskWrapUpdateBO) {
        log.info("\u63a5\u53e3 updateTask ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskWrapUpdateBO);
        TaskWrapInsertDTO taskWrapInsertDTO = (TaskWrapInsertDTO)IFWBeanCopyUtil.map((Object)taskWrapUpdateBO, TaskWrapInsertDTO.class);
        BaseResponse response = this.taskFacade.updateTask(taskWrapInsertDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateTask ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public List<ServiceSupplierOutputBO> getServiceSupplierList(ServiceSupplierListQueryInputBO serviceSupplierListQueryInputBO) {
        log.info("\u63a5\u53e3 getServiceSupplierList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)serviceSupplierListQueryInputBO);
        BaseResponse response = this.taskFacade.getServiceSupplierList((ServiceSupplierListQueryDTO)IFWBeanCopyUtil.map((Object)serviceSupplierListQueryInputBO, ServiceSupplierListQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getServiceSupplierList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), ServiceSupplierOutputBO.class);
    }

    public TaskWrapDetailOutputBO getTaskDetail(TaskDetailQueryInputBO taskDetailQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskDetailQueryInputBO);
        BaseResponse response = this.taskFacade.getTaskDetail((TaskDetailQueryDTO)IFWBeanCopyUtil.map((Object)taskDetailQueryInputBO, TaskDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        TaskWrapDetailDTO data = (TaskWrapDetailDTO)response.getData();
        TaskWrapDetailOutputBO taskWrapDetailOutputBO = new TaskWrapDetailOutputBO();
        taskWrapDetailOutputBO.setTask((TaskInsertInputBO)IFWBeanCopyUtil.map((Object)data.getTaskInsertDTO(), TaskInsertInputBO.class));
        taskWrapDetailOutputBO.setServiceSupplier((ServiceSupplierOutputBO)IFWBeanCopyUtil.map((Object)data.getServiceSupplierInsertDTO(), ServiceSupplierOutputBO.class));
        taskWrapDetailOutputBO.setTaskCheckPointRelationList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskCheckPointRelationInsertDTOList(), TaskCheckPointRelationInsertInputBO.class));
        taskWrapDetailOutputBO.setTaskExecutorList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskExecutorInsertDTOList(), TaskExecutorInsertInputBO.class));
        taskWrapDetailOutputBO.setTaskPictureList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskPictureInsertDTOList(), TaskPictureInsertInputBO.class));
        taskWrapDetailOutputBO.setTaskSpaceList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskSpaceInsertDTOList(), TaskSpaceInsertInputBO.class));
        if (!CollectionUtils.isEmpty((Collection)data.getTaskAssetList())) {
            taskWrapDetailOutputBO.setTaskAssetList(IFWBeanCopyUtil.mapAsList((Iterable)data.getTaskAssetList(), TaskAssetOutputBO.class));
        }
        if (data.getCustomizeTaskCycle() != null) {
            taskWrapDetailOutputBO.setCustomizeTaskCycle((CustomizeTaskCycleInputBO)IFWBeanCopyUtil.map((Object)data.getCustomizeTaskCycle(), CustomizeTaskCycleInputBO.class));
        }
        return taskWrapDetailOutputBO;
    }

    public List<DailyTaskWorkSheetListOutputBO> getTaskListByCheckpointId(WorksheetScanQueryInputBO worksheetScanQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskListByCheckpointId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)worksheetScanQueryInputBO);
        BaseResponse response = this.taskFacade.getTaskListByCheckpointId((WorksheetScanQueryDTO)IFWBeanCopyUtil.map((Object)worksheetScanQueryInputBO, WorksheetScanQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskListByCheckpointId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), DailyTaskWorkSheetListOutputBO.class);
    }

    public IFWPageInfo<TaskListOutputBO> getTaskList(TaskListPageQueryInputBO taskListPageQueryInputBO) {
        log.info("\u63a5\u53e3 getTaskList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)taskListPageQueryInputBO);
        BaseResponse response = this.taskFacade.getTaskList((TaskListPageQueryDTO)IFWBeanCopyUtil.map((Object)taskListPageQueryInputBO, TaskListPageQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getTaskList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List taskListOutputBOList = new ArrayList();
        List list = data.getList();
        if (list != null && !list.isEmpty()) {
            taskListOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)list, TaskListOutputBO.class);
            for (TaskListDTO dto : list) {
                for (TaskListOutputBO bo : taskListOutputBOList) {
                    if (!StringUtils.isEquals((String)dto.getTaskId(), (String)bo.getTaskId())) continue;
                    List resultList = new ArrayList();
                    List taskCheckPointRelationInsertList = dto.getTaskCheckPointRelationInsertList();
                    if (taskCheckPointRelationInsertList != null && !taskCheckPointRelationInsertList.isEmpty()) {
                        resultList = IFWBeanCopyUtil.mapAsList((Iterable)taskCheckPointRelationInsertList, TaskCheckPointRelationInsertInputBO.class);
                    }
                    bo.setTaskCheckPointRelationList(resultList);
                }
            }
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setList(taskListOutputBOList);
        result.setTotal(data.getTotal());
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        return result;
    }

    public WorksheetByUserDTO queryWorksheetByUser(QueryWorksheetByUserInputBO queryWorksheetByUserInputBO) {
        log.info("\u63a5\u53e3 queryWorksheetByUser ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryWorksheetByUserInputBO);
        BaseResponse response = this.taskFacade.queryWorksheetByUser((QueryWorksheetByUserDTO)IFWBeanCopyUtil.map((Object)queryWorksheetByUserInputBO, QueryWorksheetByUserDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryWorksheetByUser ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (WorksheetByUserDTO)response.getData();
    }

    public List<String> selectByCheckpointId(QueryCheckpointRelationByIdBO queryCheckpointRelationByIdBO) {
        log.info("\u63a5\u53e3 selectByCheckpointId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCheckpointRelationByIdBO);
        BaseResponse response = this.taskFacade.selectByCheckpointId((QueryCheckpointRelationByIdDTO)IFWBeanCopyUtil.map((Object)queryCheckpointRelationByIdBO, QueryCheckpointRelationByIdDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 selectByCheckpointId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }
}

