/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.ReportingDTO;
import com.ifourthwall.dbm.task.dto.ReportingInsertDTO;
import com.ifourthwall.dbm.task.dto.ReportingQueryDTO;
import com.ifourthwall.dbm.task.dto.ReportingQueryListDTO;
import com.ifourthwall.dbm.task.dto.ReportingUpdateDTO;
import com.ifourthwall.dbm.task.facade.ReportingFacade;
import com.ifourthwall.dbm.tracker.bo.ReportingDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingInsertInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingOutputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingQueryListInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingUpdateInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerReportCountOutputBO;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="reportingRepository")
public class ReportingRepository {
    private static final Logger log = LoggerFactory.getLogger(ReportingRepository.class);
    @Reference(version="3.0.0")
    ReportingFacade reportingFacade;

    public void createReporting(ReportingInsertInputBO reportingInsertInputBO) {
        log.info("\u63a5\u53e3 createReporting ,\u63a5\u53d7\u53c2\u6570:{}", (Object)reportingInsertInputBO);
        BaseResponse response = this.reportingFacade.createReporting((ReportingInsertDTO)IFWBeanCopyUtil.map((Object)reportingInsertInputBO, ReportingInsertDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createReporting ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public IFWPageInfo<ReportingOutputBO> getReportingList(ReportingQueryListInputBO reportingQueryListInputBO) {
        log.info("\u63a5\u53e3 getReportingList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)reportingQueryListInputBO);
        BaseResponse response = this.reportingFacade.getReportingList((ReportingQueryListDTO)IFWBeanCopyUtil.map((Object)reportingQueryListInputBO, ReportingQueryListDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getReportingList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List reportingOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), ReportingOutputBO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setList(reportingOutputDTOList);
        result.setTotal(data.getTotal());
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        return result;
    }

    public List<SeerReportCountOutputBO> getReportingCountForSeer(ReportingQueryListInputBO reportingQueryListInputBO) {
        log.info("\u63a5\u53e3 getReportingCountForSeer ,\u63a5\u53d7\u53c2\u6570:{}", (Object)reportingQueryListInputBO);
        BaseResponse response = this.reportingFacade.getReportingCountForSeer((ReportingQueryListDTO)IFWBeanCopyUtil.map((Object)reportingQueryListInputBO, ReportingQueryListDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getReportingCountForSeer ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<Object> result = new ArrayList<SeerReportCountOutputBO>();
        if (data != null && !data.isEmpty()) {
            result = IFWBeanCopyUtil.mapAsList((Iterable)data, SeerReportCountOutputBO.class);
        }
        return result;
    }

    public ReportingOutputBO getReportingDetail(ReportingDetailQueryInputBO reportingDetailQueryInputBO) {
        log.info("\u63a5\u53e3 getReportingDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)reportingDetailQueryInputBO);
        BaseResponse response = this.reportingFacade.getReportingDetail((ReportingQueryDTO)IFWBeanCopyUtil.map((Object)reportingDetailQueryInputBO, ReportingQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getReportingDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        ReportingDTO data = (ReportingDTO)response.getData();
        ReportingOutputBO reportingOutputBO = (ReportingOutputBO)IFWBeanCopyUtil.map((Object)data, ReportingOutputBO.class);
        return reportingOutputBO;
    }

    public void updateReporting(ReportingUpdateInputBO reportingUpdateInputBO) {
        log.info("\u63a5\u53e3 updateReporting ,\u63a5\u53d7\u53c2\u6570:{}", (Object)reportingUpdateInputBO);
        BaseResponse response = this.reportingFacade.updateReporting((ReportingUpdateDTO)IFWBeanCopyUtil.map((Object)reportingUpdateInputBO, ReportingUpdateDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateReporting ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }
}

