/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.project.dto.GetProjectSpaceInfoQueryDTO;
import com.ifourthwall.dbm.project.dto.QueryAllDeptDTO;
import com.ifourthwall.dbm.project.dto.QueryAllDeptQueryDTO;
import com.ifourthwall.dbm.project.dto.QueryProjectPageDTO;
import com.ifourthwall.dbm.project.dto.project.QueryListByIdsDTO;
import com.ifourthwall.dbm.project.dto.project.QueryListByIdsQuDTO;
import com.ifourthwall.dbm.project.facade.ProjectFacade;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.DeptUserInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.ProjectQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryAllDeptOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryDeptPositionReqInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryDeptPositionResOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryResEmployeeOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserDeatilInfoOutputBO;
import com.ifourthwall.dbm.tracker.bo.UserInformationOutputBO;
import com.ifourthwall.dbm.user.dto.DeptUserInfoInDTO;
import com.ifourthwall.dbm.user.dto.FindPostitionByTenantIdDTO;
import com.ifourthwall.dbm.user.dto.GetUserDTO;
import com.ifourthwall.dbm.user.dto.PageUserReqDTO;
import com.ifourthwall.dbm.user.dto.PageUserResponseDTO;
import com.ifourthwall.dbm.user.dto.QuDeptInfoDTO;
import com.ifourthwall.dbm.user.dto.QuPositionNameReqDTO;
import com.ifourthwall.dbm.user.dto.QuPositionNameResDTO;
import com.ifourthwall.dbm.user.dto.QuUserAndPositionIdReqDTO;
import com.ifourthwall.dbm.user.dto.QuUserAndPositionIdResDTO;
import com.ifourthwall.dbm.user.dto.QueryDeptInfosReqDTO;
import com.ifourthwall.dbm.user.dto.QueryDeptPositionReqDTO;
import com.ifourthwall.dbm.user.dto.QueryPositionNameReqDTO;
import com.ifourthwall.dbm.user.dto.QueryPositionNameResDTO;
import com.ifourthwall.dbm.user.dto.QueryReqEmployeeDTO;
import com.ifourthwall.dbm.user.dto.QueryUserIdsReqDTO;
import com.ifourthwall.dbm.user.dto.QueryUserIdsResDTO;
import com.ifourthwall.dbm.user.dto.UserDeatilInfoInDTO;
import com.ifourthwall.dbm.user.dto.UserInformationDTO;
import com.ifourthwall.dbm.user.facade.PositionFacade;
import com.ifourthwall.dbm.user.facade.UserFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="organizationRepository")
public class OrganizationRepository {
    private static final Logger log = LoggerFactory.getLogger(OrganizationRepository.class);
    @Reference(version="1.0.0")
    ProjectFacade projectFacade;
    @Reference(version="1.0.0")
    UserFacade userFacade;
    @Reference(version="1.0.0")
    PositionFacade positionFacade;

    public List<QueryDeptPositionResOutputBO> queryDeptAndPositionByPositionIds(QueryDeptPositionReqInputBO queryDeptPositionReqInputBO) {
        log.info("\u63a5\u53e3 queryDeptAndPositionByPositionIds ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryDeptPositionReqInputBO);
        BaseResponse response = this.positionFacade.queryDeptAndPositionByPositionIds((QueryDeptPositionReqDTO)IFWBeanCopyUtil.map((Object)queryDeptPositionReqInputBO, QueryDeptPositionReqDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryDeptAndPositionByPositionIds ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        if (response.getData() != null && !((List)response.getData()).isEmpty()) {
            return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), QueryDeptPositionResOutputBO.class);
        }
        return null;
    }

    public List<QueryResEmployeeOutputBO> querySharePosition(QueryReqEmployeeDTO queryReqEmployeeDTO) {
        log.info("\u63a5\u53e3 querySharePosition ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryReqEmployeeDTO);
        BaseResponse response = this.positionFacade.queryPositionAndEmployeeNameByPositionId(queryReqEmployeeDTO);
        log.info("\u63a5\u53e3 querySharePosition ,\u8fd4\u56de\u7ed3\u679c:{}", (Object)queryReqEmployeeDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        if (response.getData() != null) {
            return IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), QueryResEmployeeOutputBO.class);
        }
        return null;
    }

    public List<QueryResEmployeeOutputBO> queryPositionAndEmployeeByPositionId(List<String> positionIdList, String tenantId, String languageCode) {
        QueryReqEmployeeDTO queryReqEmployeeDTO = new QueryReqEmployeeDTO();
        queryReqEmployeeDTO.setPositionIds(positionIdList);
        queryReqEmployeeDTO.setTenantId(tenantId);
        queryReqEmployeeDTO.setLanguageCode(languageCode);
        log.info("\u63a5\u53e3 queryPositionAndEmployeeByPositionId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryReqEmployeeDTO);
        BaseResponse response = this.positionFacade.queryPositionAndEmployeeByPositionId(queryReqEmployeeDTO);
        log.info("\u63a5\u53e3 queryPositionAndEmployeeByPositionId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        List<Object> queryResEmployeeOutputBOList = new ArrayList<QueryResEmployeeOutputBO>();
        if (response.getData() != null) {
            List data = (List)response.getData();
            queryResEmployeeOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), QueryResEmployeeOutputBO.class);
        }
        return queryResEmployeeOutputBOList;
    }

    public List<QueryPositionNameResDTO> queryPositionNameList(List<String> positionIdList, String tenantId, String languageCode) {
        QueryPositionNameReqDTO queryReqEmployeeDTO = new QueryPositionNameReqDTO();
        queryReqEmployeeDTO.setPositionIds(positionIdList);
        queryReqEmployeeDTO.setTenantId(tenantId);
        queryReqEmployeeDTO.setLanguageCode(languageCode);
        log.info("\u63a5\u53e3 queryPositionNameList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryReqEmployeeDTO);
        BaseResponse response = this.positionFacade.queryPositionNameByPositionIds(queryReqEmployeeDTO);
        log.info("\u63a5\u53e3 queryPositionNameList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        List data = (List)response.getData();
        return data;
    }

    public List<UserInformationOutputBO> queryListUserAndFindUser(String createName, String tenantId, String languageCode) {
        PageUserReqDTO pageUserReqDTO = new PageUserReqDTO();
        pageUserReqDTO.setEmployeeName(createName);
        pageUserReqDTO.setTenantId(tenantId);
        pageUserReqDTO.setLanguageCode(languageCode);
        pageUserReqDTO.setPageNum(Integer.valueOf(0));
        pageUserReqDTO.setPageSize(Integer.valueOf(0));
        log.info("\u63a5\u53e3 queryListUserAndFindUser ,\u63a5\u53d7\u53c2\u6570:{}", (Object)pageUserReqDTO);
        BaseResponse response = this.userFacade.queryListUserAndFindUser(pageUserReqDTO);
        log.info("\u63a5\u53e3 queryListUserAndFindUser ,\u63a5\u53d7\u53c2\u6570:{}", (Object)response);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        if (response.getData() != null) {
            ArrayList<UserInformationOutputBO> userListData = new ArrayList<UserInformationOutputBO>();
            List userList = ((PageUserResponseDTO)response.getData()).getUserListData();
            if (userList != null && !userList.isEmpty()) {
                userListData.addAll(IFWBeanCopyUtil.mapAsList((Iterable)userList, UserInformationOutputBO.class));
            }
            return userListData;
        }
        return null;
    }

    public List<UserDeatilInfoOutputBO> queryUserDetailByUserId(List<String> userIdList, String tenantId, String languageCode) {
        log.info("\u63a5\u53e3 queryUserDetailByUserId ,\u63a5\u53d7\u53c2\u6570:{}", userIdList);
        UserDeatilInfoInDTO userDeatilInfoInDTO = new UserDeatilInfoInDTO();
        userDeatilInfoInDTO.setUserIds(userIdList);
        userDeatilInfoInDTO.setLanguageCode(languageCode);
        BaseResponse response = this.userFacade.queryUserDetailByUserId(userDeatilInfoInDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 queryUserDetailByUserId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<Object> userDeatilInfoOutputBOList = new ArrayList<UserDeatilInfoOutputBO>();
        if (data != null && !data.isEmpty()) {
            userDeatilInfoOutputBOList = IFWBeanCopyUtil.mapAsList((Iterable)data, UserDeatilInfoOutputBO.class);
        }
        return userDeatilInfoOutputBOList;
    }

    public List<String> getDeptIdList(ContactQueryInputBO contactQueryInputBO) {
        log.info("\u63a5\u53e3 getDeptIdList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)contactQueryInputBO);
        BaseResponse response = this.projectFacade.queryAllDept((QueryAllDeptQueryDTO)IFWBeanCopyUtil.map((Object)contactQueryInputBO, QueryAllDeptQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getDeptIdList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<String> deptIdList = new ArrayList<String>();
        if (data != null && !data.isEmpty()) {
            deptIdList = data.stream().map(QueryAllDeptDTO::getDeptId).collect(Collectors.toList());
        }
        return deptIdList;
    }

    public List<QueryAllDeptDTO> getDeptInfoList(ContactQueryInputBO contactQueryInputBO) {
        log.info("\u63a5\u53e3 getDeptInfoList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)contactQueryInputBO);
        BaseResponse response = this.projectFacade.queryAllDept((QueryAllDeptQueryDTO)IFWBeanCopyUtil.map((Object)contactQueryInputBO, QueryAllDeptQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getDeptInfoList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        return data;
    }

    public List<QueryAllDeptOutputBO> getProjectList(ProjectQueryInputBO projectQueryInputBO) {
        log.info("\u63a5\u53e3 getProjectList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)projectQueryInputBO);
        BaseResponse response = this.projectFacade.queryAllDept((QueryAllDeptQueryDTO)IFWBeanCopyUtil.map((Object)projectQueryInputBO, QueryAllDeptQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getProjectList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData() != null ? IFWBeanCopyUtil.mapAsList((Iterable)((Iterable)response.getData()), QueryAllDeptOutputBO.class) : null;
    }

    public List<QueryListByIdsDTO> getProjectNameByList(QueryListByIdsQuDTO queryListByIdsQuDTO) {
        log.info("\u63a5\u53e3 getProjectNameByList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryListByIdsQuDTO);
        BaseResponse response = this.projectFacade.queryListByIds(queryListByIdsQuDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getProjectNameByList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData() != null ? (List)response.getData() : null;
    }

    public List<DeptUserInfoOutputBO> getContactList(List<String> deptIdList, String languageCode, String tenantId) {
        DeptUserInfoInDTO deptUserInfoInDTO = new DeptUserInfoInDTO();
        deptUserInfoInDTO.setDeptIds(deptIdList);
        deptUserInfoInDTO.setLanguageCode(languageCode);
        deptUserInfoInDTO.setTenantId(tenantId);
        log.info("\u63a5\u53e3 getContactList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)deptUserInfoInDTO);
        BaseResponse response = this.userFacade.queryProjectUserDeptIds(deptUserInfoInDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getContactList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        if (data != null) {
            return IFWBeanCopyUtil.mapAsList((Iterable)data, DeptUserInfoOutputBO.class);
        }
        return new ArrayList<DeptUserInfoOutputBO>();
    }

    public List<String> queryUserIdsByEmployeeName(String name, String languageCode, String tenantId) {
        log.info("\u63a5\u53e3 queryUserIdsByEmployeeName ,\u63a5\u53d7\u53c2\u6570:{}", (Object)name);
        QueryUserIdsReqDTO queryUserIdsReqDTO = new QueryUserIdsReqDTO();
        queryUserIdsReqDTO.setEmployeeName(name);
        queryUserIdsReqDTO.setTenantId(tenantId);
        queryUserIdsReqDTO.setLanguageCode(languageCode);
        BaseResponse response = this.userFacade.queryUserIdsByEmployeeName(queryUserIdsReqDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 queryUserIdsByEmployeeName ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        QueryUserIdsResDTO data = (QueryUserIdsResDTO)response.getData();
        return data != null ? data.getUserIds() : null;
    }

    public UserInformationDTO queryUser(String userId, String tenantId, String languageCode) {
        log.info("\u63a5\u53e3 queryUser ,\u63a5\u53d7\u53c2\u6570:{}", (Object)userId);
        GetUserDTO getUserDTO = new GetUserDTO();
        getUserDTO.setUserId(userId);
        getUserDTO.setTenantId(tenantId);
        getUserDTO.setLanguageCode(languageCode);
        BaseResponse response = this.userFacade.queryUser(getUserDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 queryUser ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        if (data != null && !data.isEmpty()) {
            return (UserInformationDTO)data.get(0);
        }
        return null;
    }

    public List<FindPostitionByTenantIdDTO> findListPositionByTenant(String tenantId, String userId) {
        FindPostitionByTenantIdDTO findPostitionByTenantIdDTO = new FindPostitionByTenantIdDTO();
        findPostitionByTenantIdDTO.setTenantId(tenantId);
        findPostitionByTenantIdDTO.setUserId(userId);
        log.info("\u63a5\u53e3 findListPositionByTenant ,\u63a5\u53d7\u53c2\u6570:{}", (Object)findPostitionByTenantIdDTO);
        BaseResponse response = this.positionFacade.findListPositionByTenantId(findPostitionByTenantIdDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 findListPositionByTenant ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        return data;
    }

    public List<QuDeptInfoDTO> queryDeptByPositionIds(QueryDeptInfosReqDTO queryDeptInfosReqDTO) {
        log.info("\u63a5\u53e3 queryDeptByPositionIds ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryDeptInfosReqDTO);
        BaseResponse response = this.positionFacade.queryDeptByPositionIds(queryDeptInfosReqDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 queryDeptByPositionIds ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        return data;
    }

    public List<QuPositionNameResDTO> queryPositionInfo(QuPositionNameReqDTO quPositionNameReqDTO) {
        log.info("\u63a5\u53e3 queryPositionInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)quPositionNameReqDTO);
        BaseResponse response = this.positionFacade.queryPositionInfo(quPositionNameReqDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 queryPositionInfo ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        return data;
    }

    public QueryProjectPageDTO getProjectSpaceInfo(GetProjectSpaceInfoQueryDTO getProjectSpaceInfoQueryDTO) {
        log.info("\u63a5\u53e3 getProjectSpaceInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)getProjectSpaceInfoQueryDTO);
        BaseResponse response = this.projectFacade.getProjectSpaceInfo(getProjectSpaceInfoQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 getProjectSpaceInfo ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        QueryProjectPageDTO data = (QueryProjectPageDTO)response.getData();
        return data;
    }

    public QuUserAndPositionIdResDTO selectUserIdAndPositionId(QuUserAndPositionIdReqDTO quUserAndPositionIdReqDTO) {
        log.info("\u63a5\u53e3 selectUserIdAndPositionId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)quUserAndPositionIdReqDTO);
        BaseResponse response = this.userFacade.selectUserIdAndPositionId(quUserAndPositionIdReqDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetCode(), response.getRetMsg());
        }
        log.info("\u63a5\u53e3 selectUserIdAndPositionId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        QuUserAndPositionIdResDTO data = (QuUserAndPositionIdResDTO)response.getData();
        return data;
    }
}

