/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.tracker.bo.DocQueryBO;
import com.ifourthwall.dbm.tracker.bo.GroupQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.KnowledgeSearchInputBO;
import com.ifourthwall.dbm.tracker.bo.RepoQueryBO;
import com.ifourthwall.dbm.tracker.bo.YuQueUserInfoQueryBO;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="knowledgeRepository")
public class KnowledgeRepository {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeRepository.class);
    public static final String yuQueBaseUrl = "https://www.yuque.com/api/v2";
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).build();

    public Request synGet(String url, String json, String token) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            builder.header("User-Agent", "tracker");
            builder.header("X-Auth-Token", token);
            builder.header("Content-Type", "application/json");
        }
        builder.method("GET", null);
        Request request = builder.build();
        return request;
    }

    private Object synSend(String url, String json, String token) {
        Request request = this.synGet(url, json, token);
        log.info("\u5373\u5c06\u53d1\u9001\u8bf7\u6c42\u8bed\u96c0URL:{}", (Object)url);
        Response response = null;
        try {
            response = client.newCall(request).execute();
            String content = response.body().string();
            log.info("\u8bf7\u6c42\u8bed\u96c0api:{}\u6210\u529f,\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)url, (Object)content);
            Map result = (Map)JSONUtils.jacksonFromJson((String)content, HashMap.class);
            return this.handleResult(result);
        }
        catch (IOException e) {
            log.error("\u8bed\u96c0api\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Object handleResult(Map<String, Object> result) {
        if (result != null && result.containsKey("data")) {
            return result.get("data");
        }
        return null;
    }

    public Object queryYuQueUserInfo(YuQueUserInfoQueryBO yuQueUserInfoQueryBO) {
        log.info("queryYuQueUserInfo\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)yuQueUserInfoQueryBO);
        String queryUserInfo = "https://www.yuque.com/api/v2/user";
        Object result = this.synSend(queryUserInfo, "", yuQueUserInfoQueryBO.getAuthToken());
        log.info("queryYuQueUserInfo\uff0c\u8fd4\u56de\u7ed3\u679c{}", result);
        return result;
    }

    public Object search(KnowledgeSearchInputBO knowledgeSearchInputBO) {
        log.info("search\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)knowledgeSearchInputBO);
        String queryUserInfo = "https://www.yuque.com/api/v2/search?q=" + knowledgeSearchInputBO.getQ() + "&type=" + knowledgeSearchInputBO.getType() + "&related=true";
        Object result = this.synSend(queryUserInfo, "", knowledgeSearchInputBO.getToken());
        log.info("search\uff0c\u8fd4\u56de\u7ed3\u679c{}", result);
        return result;
    }

    public Object getTeamInfo(GroupQueryInputBO groupQueryInputBO) {
        log.info("getTeamInfo\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)groupQueryInputBO);
        String queryUserInfo = "https://www.yuque.com/api/v2/users/" + groupQueryInputBO.getLogin() + "/groups";
        Object result = this.synSend(queryUserInfo, "", groupQueryInputBO.getToken());
        log.info("getTeamInfo\uff0c\u8fd4\u56de\u7ed3\u679c{}", result);
        return result;
    }

    public Object queryRepoList(RepoQueryBO repoQueryBO) {
        log.info("queryRepoList\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)repoQueryBO);
        String queryUserInfo = repoQueryBO.getType().equals("1") ? "https://www.yuque.com/api/v2/groups/" + repoQueryBO.getLogin() + "/repos?type=all" : "https://www.yuque.com/api/v2/users/" + repoQueryBO.getLogin() + "/repos?type=all";
        Object result = this.synSend(queryUserInfo, "", repoQueryBO.getToken());
        log.info("queryRepoList\uff0c\u8fd4\u56de\u7ed3\u679c{}", result);
        return result;
    }

    public Object queryDocList(DocQueryBO docQueryBO) {
        log.info("queryDocList\uff0c\u8bf7\u6c42\u53c2\u6570{}", (Object)docQueryBO);
        String queryUserInfo = "https://www.yuque.com/api/v2/repos/" + docQueryBO.getReposId() + "/docs?offset=" + docQueryBO.getOffset();
        Object result = this.synSend(queryUserInfo, "", docQueryBO.getToken());
        log.info("queryDocList\uff0c\u8fd4\u56de\u7ed3\u679c{}", result);
        return result;
    }
}

