/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.JSONUtils;
import com.ifourthwall.dbm.tracker.bo.MeterInfoInputBO;
import com.ifourthwall.dbm.tracker.domain.ThirdBindPushRepository;
import com.ifourthwall.dbm.tracker.dto.ThirdPushBindOutputDTO;
import com.ifourthwall.dbm.tracker.dto.ThirdPushWorksheetDetailDTO;
import com.ifourthwall.dbm.tracker.utils.BaseResponseUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="godzillaRepository")
public class GodzillaRepository {
    private static final Logger log = LoggerFactory.getLogger(GodzillaRepository.class);
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).build();
    @Value(value="${godzilla.upload.meter.url}")
    private String godzillaUrl;
    @Resource(name="thirdBindPushRepository")
    ThirdBindPushRepository thirdBindPushRepository;

    public Request synPost(String url, String json, String token) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new RuntimeException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request.Builder builder = new Request.Builder();
        builder.url(url);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            builder.header("Authorization", token);
        }
        builder.method("POST", body);
        Request request = builder.build();
        return request;
    }

    private Map<String, Object> synSend(String url, String json, String token) {
        Request request = this.synPost(url, json, token);
        log.info("\u5373\u5c06\u53d1\u9001URL:{}", (Object)url);
        Response response = null;
        try {
            response = client.newCall(request).execute();
            String content = response.body().string();
            log.info("\u53d1\u9001URL:{}\u6210\u529f,\u8fd4\u56de\u7684\u6570\u636e:{}", (Object)url, (Object)content);
            Map result = (Map)JSONUtils.jacksonFromJson((String)content, HashMap.class);
            return result;
        }
        catch (IOException e) {
            log.error("\u53d1\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void handleFailedResult(Map<String, Object> result, String errorMsg, String errorCode) {
        if (!((Boolean)result.get("flag")).booleanValue()) {
            log.warn("\u8c03\u7528godzilla\u63a5\u53e3\u5931\u8d25,\u9519\u8bef\u539f\u56e0:{},\u9519\u8bef\u7f16\u7801:{}", result.get("msg"), result.get("code"));
            throw new BizException(errorMsg, errorCode);
        }
    }

    public BaseResponse sendMeterDataToGodzilla(MeterInfoInputBO meterInfoInputBO) {
        String url = this.godzillaUrl + meterInfoInputBO.getDeviceId();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", meterInfoInputBO.getUserId());
        param.put("userName", meterInfoInputBO.getUserName());
        param.put("remark", meterInfoInputBO.getRemark() != null ? meterInfoInputBO.getRemark() : "");
        param.put(meterInfoInputBO.getDataPointId(), meterInfoInputBO.getValue());
        log.info("tracker\u5411\u54e5\u65af\u62c9\u53d1\u9001\u6284\u8868\u6570\u636e\uff0c\u8bf7\u6c42\u53c2\u6570{}", param);
        String sentInfo = JSONUtils.jacksonToJson(param);
        log.info("json:" + sentInfo);
        Map result = null;
        result = this.synSend(url, sentInfo, "");
        this.handleFailedResult(result, "\u53d1\u9001\u6284\u8868\u6570\u636e\u5931\u8d25", "13");
        return BaseResponseUtils.getSuccessResponse(null, (String)PlatformCodeEnum.EXECUTE_SUCCESS.getCode());
    }

    public Map<String, Object> sendWorksheetMessageToThird(ThirdPushBindOutputDTO thirdPushBindOutputDTO, ThirdPushWorksheetDetailDTO data) {
        log.info("tracker\u5411\u7b2c\u4e09\u65b9\u53d1\u9001\u8bf7\u6c42\u53c2\u6570{}", (Object)data);
        String worksheetInfo = JSONUtils.jacksonToJson((Object)data);
        log.info("json:" + worksheetInfo);
        Map result = null;
        result = this.synSend(thirdPushBindOutputDTO.getCallBackUrl(), worksheetInfo, thirdPushBindOutputDTO.getToken());
        return result;
    }
}

