/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.asset.dto.BindCheckpointQuDTO;
import com.ifourthwall.dbm.asset.dto.DailyTaskListQueryDTO;
import com.ifourthwall.dbm.asset.dto.PageDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetInfoDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetInfoQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetListByIdsDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetListByIdsQuDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetListDTO;
import com.ifourthwall.dbm.asset.dto.QueryAssetListQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryByDeptQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryCheckPointListQueryDTO;
import com.ifourthwall.dbm.asset.dto.QueryNoMacQuDTO;
import com.ifourthwall.dbm.asset.dto.QueryNoMonitorQuDTO;
import com.ifourthwall.dbm.asset.dto.ReplaceCPQuBasisDTO;
import com.ifourthwall.dbm.asset.dto.TrackerOfflineDTO;
import com.ifourthwall.dbm.asset.dto.TrackerOfflineQuDTO;
import com.ifourthwall.dbm.asset.dto.UntieCheckpointQuDTO;
import com.ifourthwall.dbm.asset.facade.AssetFacade;
import com.ifourthwall.dbm.asset.facade.CheckpoinAssetFacade;
import com.ifourthwall.dbm.project.dto.GetNewPathBatchQueryDTO;
import com.ifourthwall.dbm.project.dto.GetSonSpaceDTO;
import com.ifourthwall.dbm.project.dto.GetSonSpaceQueryDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpaceBaseDTO;
import com.ifourthwall.dbm.project.dto.ProjectSpacePathDTO;
import com.ifourthwall.dbm.project.dto.QueryNextSonListDTO;
import com.ifourthwall.dbm.project.dto.QueryNextSonListQuDTO;
import com.ifourthwall.dbm.project.dto.QuerySonSpaceListDTO;
import com.ifourthwall.dbm.project.dto.QuerySonSpaceListQuDTO;
import com.ifourthwall.dbm.project.dto.QuerySpaceInfoQueryDTO;
import com.ifourthwall.dbm.project.facade.ProjectSpaceFacade;
import com.ifourthwall.dbm.project.facade.ProjectSpaceTwoFacade;
import com.ifourthwall.dbm.task.facade.ApkFacade;
import com.ifourthwall.dbm.tracker.bo.BindCheckpointQuInputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointListOutputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointQueryByMacInputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointQueryByMacOutputBO;
import com.ifourthwall.dbm.tracker.bo.CheckpointScanOutlineQueryBO;
import com.ifourthwall.dbm.tracker.bo.JPushMessageBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCheckPointListQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryNoMacOutputBO;
import com.ifourthwall.dbm.tracker.bo.QueryNoMacQuInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryWorksheetByAssetInputBO;
import com.ifourthwall.dbm.tracker.bo.ReplaceCPQuBasisInputBO;
import com.ifourthwall.dbm.tracker.bo.SeerAssetOutputBO;
import com.ifourthwall.dbm.tracker.bo.SeerQuerySpecialBySpaceInputBO;
import com.ifourthwall.dbm.tracker.bo.TrackerOfflineQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.UntieCheckpointQuInputBO;
import com.ifourthwall.dbm.tracker.dto.ApkOutputDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="configRepository")
public class ConfigRepository {
    private static final Logger log = LoggerFactory.getLogger(ConfigRepository.class);
    @Reference(version="1.0.0")
    CheckpoinAssetFacade checkpoinAssetFacade;
    @Reference(version="1.0.0")
    ProjectSpaceFacade projectSpaceFacade;
    @Reference(version="1.0.0")
    ProjectSpaceTwoFacade projectSpaceTwoFacade;
    @Reference(version="1.0.0")
    AssetFacade assetFacade;
    @Value(value="${ali.push.appkey}")
    private long aliAppKey;
    @Value(value="${ali.push.appkey.id}")
    private String appKeyId;
    @Value(value="${ali.push.accesskey.secret}")
    private String secret;
    @Reference(version="3.0.0")
    ApkFacade apkFacade;

    public List<CheckpointQueryByMacOutputBO> getCheckpointListByMac(CheckpointQueryByMacInputBO checkpointQueryByMacInputBO) {
        log.info("\u63a5\u53e3 getCheckpointListByMac ,\u63a5\u53d7\u53c2\u6570:{}", (Object)checkpointQueryByMacInputBO);
        BaseResponse response = this.checkpoinAssetFacade.queryByMac((QueryByDeptQueryDTO)IFWBeanCopyUtil.map((Object)checkpointQueryByMacInputBO, QueryByDeptQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCheckpointListByMac ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        ArrayList<CheckpointQueryByMacOutputBO> result = new ArrayList<CheckpointQueryByMacOutputBO>();
        if (data != null) {
            result.addAll(IFWBeanCopyUtil.mapAsList((Iterable)data, CheckpointQueryByMacOutputBO.class));
        }
        return result;
    }

    public Object replaceCheckpoint(ReplaceCPQuBasisInputBO replaceCPQuBasisInputBO) {
        log.info("\u63a5\u53e3 replaceCheckpoint ,\u63a5\u53d7\u53c2\u6570:{}", (Object)replaceCPQuBasisInputBO);
        BaseResponse response = this.checkpoinAssetFacade.replaceCheckpoint((ReplaceCPQuBasisDTO)IFWBeanCopyUtil.map((Object)replaceCPQuBasisInputBO, ReplaceCPQuBasisDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 replaceCheckpoint ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData();
    }

    public Object untieCheckpoint(UntieCheckpointQuInputBO untieCheckpointQuInputBO) {
        log.info("\u63a5\u53e3 untieCheckpoint ,\u63a5\u53d7\u53c2\u6570:{}", (Object)untieCheckpointQuInputBO);
        BaseResponse response = this.checkpoinAssetFacade.untieCheckpoint((UntieCheckpointQuDTO)IFWBeanCopyUtil.map((Object)untieCheckpointQuInputBO, UntieCheckpointQuDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 untieCheckpoint ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData();
    }

    public Object bindCheckpoint(BindCheckpointQuInputBO bindCheckpointQuInputBO) {
        log.info("\u63a5\u53e3 bindCheckpoint ,\u63a5\u53d7\u53c2\u6570:{}", (Object)bindCheckpointQuInputBO);
        BaseResponse response = this.checkpoinAssetFacade.bindCheckpoint((BindCheckpointQuDTO)IFWBeanCopyUtil.map((Object)bindCheckpointQuInputBO, BindCheckpointQuDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 bindCheckpoint ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return response.getData();
    }

    public IFWPageInfo<QueryNoMacOutputBO> getUnbindCheckpoint(QueryNoMacQuInputBO queryNoMacQuInputBO) {
        log.info("\u63a5\u53e3 getUnbindCheckpoint ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryNoMacQuInputBO);
        BaseResponse response = this.checkpoinAssetFacade.queryNoMac((QueryNoMacQuDTO)IFWBeanCopyUtil.map((Object)queryNoMacQuInputBO, QueryNoMacQuDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getUnbindCheckpoint ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        PageDTO data = (PageDTO)response.getData();
        IFWPageInfo result = new IFWPageInfo();
        if (data != null) {
            result.setTotal(data.getTotal());
            result.setPageNum(data.getPageNum());
            result.setPageSize(data.getPageSize());
            if (data.getResult() != null) {
                result.setList(IFWBeanCopyUtil.mapAsList((Iterable)data.getResult(), QueryNoMacOutputBO.class));
            }
        }
        return result;
    }

    public IFWPageInfo<QueryCheckPointListOutputBO> getCheckpointList(QueryCheckPointListQueryInputBO queryCheckPointListQueryInputBO) {
        queryCheckPointListQueryInputBO.setValid(Integer.valueOf(1));
        log.info("\u63a5\u53e3 getCheckpointList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCheckPointListQueryInputBO);
        BaseResponse response = this.checkpoinAssetFacade.queryCheckPointList((QueryCheckPointListQueryDTO)IFWBeanCopyUtil.map((Object)queryCheckPointListQueryInputBO, QueryCheckPointListQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCheckpointList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        ArrayList queryCheckPointListOutputBOList = new ArrayList();
        IFWPageInfo result = new IFWPageInfo();
        IFWPageInfo data = (IFWPageInfo)response.getData();
        if (data != null) {
            List list = data.getList();
            if (list != null && !list.isEmpty()) {
                queryCheckPointListOutputBOList.addAll(IFWBeanCopyUtil.mapAsList((Iterable)list, QueryCheckPointListOutputBO.class));
            }
            result.setList(queryCheckPointListOutputBOList);
            result.setPageSize(data.getPageSize());
            result.setPageNum(data.getPageNum());
            result.setTotal(data.getTotal());
        }
        return result;
    }

    public TrackerOfflineDTO getCheckpointOfflinePackage(TrackerOfflineQueryInputBO trackerOfflineQueryInputBO) {
        log.info("\u63a5\u53e3 getCheckpointOfflinePackage ,\u63a5\u53d7\u53c2\u6570:{}", (Object)trackerOfflineQueryInputBO);
        BaseResponse response = this.checkpoinAssetFacade.trackerOffline((TrackerOfflineQuDTO)IFWBeanCopyUtil.map((Object)trackerOfflineQueryInputBO, TrackerOfflineQuDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCheckpointOfflinePackage ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (TrackerOfflineDTO)response.getData();
    }

    public IFWPageInfo<CheckpointListOutputBO> getCheckpointListFromTotal(CheckpointScanOutlineQueryBO checkpointScanOutlineQueryBO) {
        log.info("\u63a5\u53e3 getCheckpointList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)checkpointScanOutlineQueryBO);
        DailyTaskListQueryDTO dailyTaskListQueryDTO = (DailyTaskListQueryDTO)IFWBeanCopyUtil.map((Object)checkpointScanOutlineQueryBO, DailyTaskListQueryDTO.class);
        dailyTaskListQueryDTO.setCheckPointName(checkpointScanOutlineQueryBO.getCheckpointName());
        BaseResponse response = this.checkpoinAssetFacade.dailyTaskList(dailyTaskListQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCheckpointList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo result = new IFWPageInfo();
        ArrayList checkpointListOutputBOList = new ArrayList();
        IFWPageInfo data = (IFWPageInfo)response.getData();
        if (data != null) {
            List list = data.getList();
            if (list != null && !list.isEmpty()) {
                checkpointListOutputBOList.addAll(IFWBeanCopyUtil.mapAsList((Iterable)list, CheckpointListOutputBO.class));
            }
            result.setList(checkpointListOutputBOList);
            result.setPageSize(data.getPageSize());
            result.setPageNum(data.getPageNum());
            result.setTotal(data.getTotal());
        }
        return result;
    }

    public List<ProjectSpacePathDTO> querySpaceNameBySpaceList(List<String> spaceIdList, String tenantId, String languageCode, String projectId) {
        GetNewPathBatchQueryDTO getSonSpaceQueryDTO = new GetNewPathBatchQueryDTO();
        getSonSpaceQueryDTO.setTenantId(tenantId);
        getSonSpaceQueryDTO.setProjectSpaceId(spaceIdList);
        getSonSpaceQueryDTO.setProjectId(projectId);
        getSonSpaceQueryDTO.setLanguageCode(languageCode);
        log.info("\u63a5\u53e3 querySpaceNameBySpaceList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)getSonSpaceQueryDTO);
        BaseResponse response = this.projectSpaceTwoFacade.newSpaceSplit(getSonSpaceQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 querySpaceNameBySpaceList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public ProjectSpaceBaseDTO querySpaceInfo(QuerySpaceInfoQueryDTO spaceId) {
        log.info("\u63a5\u53e3 querySpaceInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)spaceId);
        BaseResponse response = this.projectSpaceFacade.querySpaceInfo(spaceId);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 querySpaceInfo ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (ProjectSpaceBaseDTO)response.getData();
    }

    public List<QueryAssetListDTO> getAssetList(String tenantId, String projectId, List<String> spaceIdList, String languageCode) {
        IFWPageInfo data;
        QueryAssetListQueryDTO queryAssetListQueryDTO = new QueryAssetListQueryDTO();
        queryAssetListQueryDTO.setTenantId(tenantId);
        queryAssetListQueryDTO.setLanguageCode(languageCode);
        queryAssetListQueryDTO.setProjectId(projectId);
        queryAssetListQueryDTO.setSpaceId(spaceIdList);
        List<Object> result = new ArrayList<QueryAssetListDTO>();
        log.info("\u63a5\u53e3 getAssetList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryAssetListQueryDTO);
        BaseResponse response = this.assetFacade.queryAssetList(queryAssetListQueryDTO);
        log.info("\u63a5\u53e3 getAssetList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        if (response.isFlag() && (data = (IFWPageInfo)response.getData()) != null) {
            result = data.getList();
        }
        return result;
    }

    public void sendPush(JPushMessageBO jPushMessageBO) {
        log.info("\u63a5\u53e3sendAliPush\u63a5\u53d7\u53c2\u6570:{}", (Object)jPushMessageBO);
        try {
            List aliaList;
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)this.appKeyId, (String)this.secret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            if (jPushMessageBO != null && !CollectionUtils.isEmpty((Collection)(aliaList = jPushMessageBO.getAliaList()))) {
                String accountStr = StringUtils.join((Object[])aliaList.toArray(), (String)",");
                PushRequest pushRequest = new PushRequest();
                pushRequest.setProtocol(ProtocolType.HTTPS);
                pushRequest.setMethod(MethodType.POST);
                pushRequest.setAppKey(Long.valueOf(this.aliAppKey));
                pushRequest.setTarget("ACCOUNT");
                pushRequest.setTargetValue(accountStr);
                pushRequest.setPushType("MESSAGE");
                pushRequest.setDeviceType("ALL");
                pushRequest.setTitle("Tracker");
                pushRequest.setBody(jPushMessageBO.getContent());
                pushRequest.setAndroidNotifyType("BOTH");
                pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
                pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
                pushRequest.setAndroidMusic("default");
                PushResponse pushResponse = (PushResponse)client.getAcsResponse((AcsRequest)pushRequest);
                log.info("RequestId: " + pushResponse.getRequestId() + ", MessageID: " + pushResponse.getMessageId());
            }
        }
        catch (ServerException e) {
            log.error("\u963f\u91cc\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
        }
        catch (ClientException e) {
            log.error("\u963f\u91cc\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public List<String> getSonSpace(String spaceId) {
        GetSonSpaceQueryDTO getSonSpaceQueryDTO = new GetSonSpaceQueryDTO();
        getSonSpaceQueryDTO.setSpaceId(spaceId);
        log.info("\u63a5\u53e3 getSonSpace ,\u63a5\u53d7\u53c2\u6570:{}", (Object)getSonSpaceQueryDTO);
        BaseResponse response = this.projectSpaceFacade.getSonpace(getSonSpaceQueryDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getSonSpace ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        if (response.getData() != null) {
            return ((GetSonSpaceDTO)response.getData()).getSpaceId();
        }
        return null;
    }

    public List<QuerySonSpaceListDTO> querySonSpaceList(String tenantId, String languageCode, List<String> spaceIdList) {
        QuerySonSpaceListQuDTO querySonSpaceListQuDTO = new QuerySonSpaceListQuDTO();
        querySonSpaceListQuDTO.setSpaceId(spaceIdList);
        querySonSpaceListQuDTO.setLanguageCode(languageCode);
        querySonSpaceListQuDTO.setTenantId(tenantId);
        log.info("\u63a5\u53e3 querySonSpaceList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)querySonSpaceListQuDTO);
        BaseResponse response = this.projectSpaceFacade.querySonSpaceList(querySonSpaceListQuDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 querySonSpaceList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }

    public IFWPageInfo<SeerAssetOutputBO> queryNoMonitorAsset(QueryNoMonitorQuDTO queryNoMonitorQuDTO) {
        log.info("\u63a5\u53e3 queryNoMonitorAsset ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryNoMonitorQuDTO);
        BaseResponse response = this.assetFacade.queryNoMonitor(queryNoMonitorQuDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryNoMonitorAsset ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo result = new IFWPageInfo();
        ArrayList list = new ArrayList();
        IFWPageInfo data = (IFWPageInfo)response.getData();
        if (data != null) {
            List queryNoMonitorDTOList = data.getList();
            result.setPageSize(data.getPageSize());
            result.setPageNum(data.getPageNum());
            result.setTotal(data.getTotal());
            if (queryNoMonitorDTOList != null) {
                list.addAll(IFWBeanCopyUtil.mapAsList((Iterable)queryNoMonitorDTOList, SeerAssetOutputBO.class));
            }
            result.setList(list);
        }
        return result;
    }

    public ApkOutputDTO getLastApk() {
        log.info("\u63a5\u53e3 getLastApk ,\u63a5\u53d7\u53c2\u6570:{}");
        BaseResponse response = this.apkFacade.queryLastApk();
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getLastApk ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (ApkOutputDTO)IFWBeanCopyUtil.map((Object)response.getData(), ApkOutputDTO.class);
    }

    public List<String> queryNextSonList(SeerQuerySpecialBySpaceInputBO seerQuerySpecialBySpaceInputBO) {
        log.info("\u63a5\u53e3 queryNextSonList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)seerQuerySpecialBySpaceInputBO);
        BaseResponse response = this.projectSpaceFacade.queryNextSonList((QueryNextSonListQuDTO)IFWBeanCopyUtil.map((Object)seerQuerySpecialBySpaceInputBO, QueryNextSonListQuDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryNextSonList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        QueryNextSonListDTO data = (QueryNextSonListDTO)response.getData();
        if (data != null) {
            return data.getSpaceId();
        }
        return null;
    }

    public QueryAssetInfoDTO queryAssetInfo(QueryWorksheetByAssetInputBO queryWorksheetByAssetInputBO) {
        log.info("\u63a5\u53e3 queryAssetInfo ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryWorksheetByAssetInputBO);
        BaseResponse response = this.assetFacade.queryAssetInfo((QueryAssetInfoQueryDTO)IFWBeanCopyUtil.map((Object)queryWorksheetByAssetInputBO, QueryAssetInfoQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryAssetInfo ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (QueryAssetInfoDTO)response.getData();
    }

    public List<QueryAssetListByIdsDTO> getAssetName(String tenantId, String projectId, String languageCode, List<String> assetIds) {
        QueryAssetListByIdsQuDTO dto = new QueryAssetListByIdsQuDTO();
        dto.setAssetIds(assetIds);
        dto.setProjectId(projectId);
        dto.setTenantId(tenantId);
        dto.setLanguageCode(languageCode);
        log.info("\u63a5\u53e3 getAssetName ,\u63a5\u53d7\u53c2\u6570:{}", (Object)dto);
        BaseResponse response = this.assetFacade.queryAssetListByIds(dto);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryAssetInfo ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (List)response.getData();
    }
}

