/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.CommonExpressionsDTO;
import com.ifourthwall.dbm.task.dto.QueryCommonExpressionsDTO;
import com.ifourthwall.dbm.task.dto.UpdateCommonExpressionsDTO;
import com.ifourthwall.dbm.task.facade.CommonExpressionsFacade;
import com.ifourthwall.dbm.tracker.bo.CommonExpressionsInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCommonExpressionsInputBO;
import com.ifourthwall.dbm.tracker.bo.UpdateCommonExpressionsBO;
import com.ifourthwall.dbm.tracker.dto.CommonExpressionsOutputDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="commonExpressionsRepository")
public class CommonExpressionsRepository {
    private static final Logger log = LoggerFactory.getLogger(CommonExpressionsRepository.class);
    @Reference(version="3.0.0")
    CommonExpressionsFacade commonExpressionsFacade;

    public IFWPageInfo<CommonExpressionsOutputDTO> selectCommonExpressionsByPage(QueryCommonExpressionsInputBO queryCommonExpressionsInputBO) {
        log.info("\u63a5\u53e3 selectCommonExpressionsByPage ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCommonExpressionsInputBO);
        BaseResponse response = this.commonExpressionsFacade.selectCommonExpressionsByPage((QueryCommonExpressionsDTO)IFWBeanCopyUtil.map((Object)queryCommonExpressionsInputBO, QueryCommonExpressionsDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 selectCommonExpressionsByPage ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List commonExpressionsOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            commonExpressionsOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CommonExpressionsOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(commonExpressionsOutputDTOList);
        return result;
    }

    public void insertCommonExpressions(CommonExpressionsInputBO commonExpressionsInputBO) {
        log.info("\u63a5\u53e3 insertCommonExpressions ,\u63a5\u53d7\u53c2\u6570:{}", (Object)commonExpressionsInputBO);
        BaseResponse response = this.commonExpressionsFacade.insertCommonExpressions((CommonExpressionsDTO)IFWBeanCopyUtil.map((Object)commonExpressionsInputBO, CommonExpressionsDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 insertCommonExpressions ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void deleteByCommonExpressionsId(UpdateCommonExpressionsBO updateCommonExpressionsBO) {
        log.info("\u63a5\u53e3 deleteByCommonExpressionsId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)updateCommonExpressionsBO);
        BaseResponse response = this.commonExpressionsFacade.deleteByCommonExpressionsId((UpdateCommonExpressionsDTO)IFWBeanCopyUtil.map((Object)updateCommonExpressionsBO, UpdateCommonExpressionsDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 deleteByCommonExpressionsId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void updateByCommonExpressionsId(UpdateCommonExpressionsBO updateCommonExpressionsBO) {
        log.info("\u63a5\u53e3 updateByCommonExpressionsId ,\u63a5\u53d7\u53c2\u6570:{}", (Object)updateCommonExpressionsBO);
        BaseResponse response = this.commonExpressionsFacade.updateByCommonExpressionsId((UpdateCommonExpressionsDTO)IFWBeanCopyUtil.map((Object)updateCommonExpressionsBO, UpdateCommonExpressionsDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateByCommonExpressionsId ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }
}

