/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.CheckpointStatisticsQueryDTO;
import com.ifourthwall.dbm.task.facade.CheckpointFacade;
import com.ifourthwall.dbm.tracker.bo.CheckpointStatisticsQueryInputBO;
import com.ifourthwall.dbm.tracker.dto.CheckpointPatrolOutputDTO;
import java.util.List;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="checkpointRepository")
public class CheckpointRepository {
    private static final Logger log = LoggerFactory.getLogger(CheckpointRepository.class);
    @Reference(version="3.0.0")
    CheckpointFacade checkpointFacade;

    public IFWPageInfo<CheckpointPatrolOutputDTO> queryCheckpointStatistics(CheckpointStatisticsQueryInputBO checkpointStatisticsQueryInputBO) {
        log.info("\u63a5\u53e3 queryCheckpointStatistics ,\u63a5\u53d7\u53c2\u6570:{}", (Object)checkpointStatisticsQueryInputBO);
        BaseResponse response = this.checkpointFacade.queryCheckpointStatistics((CheckpointStatisticsQueryDTO)IFWBeanCopyUtil.map((Object)checkpointStatisticsQueryInputBO, CheckpointStatisticsQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 queryCheckpointStatistics ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List reportingOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CheckpointPatrolOutputDTO.class);
        IFWPageInfo result = new IFWPageInfo();
        result.setList(reportingOutputDTOList);
        result.setTotal(data.getTotal());
        result.setPageSize(data.getPageSize());
        result.setPageNum(data.getPageNum());
        return result;
    }
}

