/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.CargoCommonStatisticDTO;
import com.ifourthwall.dbm.task.dto.CargoDetailQueryDTO;
import com.ifourthwall.dbm.task.dto.CargoInfoDTO;
import com.ifourthwall.dbm.task.dto.CargoStockOutCheckDTO;
import com.ifourthwall.dbm.task.dto.QueryCargoInfoDTO;
import com.ifourthwall.dbm.task.dto.QueryCargoStatisticDTO;
import com.ifourthwall.dbm.task.dto.QueryCargoStockInRecordDTO;
import com.ifourthwall.dbm.task.dto.QueryCargoStockOutRecordDTO;
import com.ifourthwall.dbm.task.dto.QueryLowSafeStockDTO;
import com.ifourthwall.dbm.task.dto.QueryStockInDetailDTO;
import com.ifourthwall.dbm.task.dto.QueryStockOutDetailDTO;
import com.ifourthwall.dbm.task.dto.QueryStockOutInfoDTO;
import com.ifourthwall.dbm.task.dto.StockInWrapDTO;
import com.ifourthwall.dbm.task.dto.StockOutWrapDTO;
import com.ifourthwall.dbm.task.dto.UpdateCargoInfoDTO;
import com.ifourthwall.dbm.task.facade.CargoInfoFacade;
import com.ifourthwall.dbm.task.facade.CargoStatisticFacade;
import com.ifourthwall.dbm.task.facade.StockInOutFacade;
import com.ifourthwall.dbm.tracker.bo.ApprovalResultOutputDTO;
import com.ifourthwall.dbm.tracker.bo.CargoCommonStatisticsQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoStockOutCheckInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoInfoBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStatisticInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStockInRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStockOutRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryLowSafeStockInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockByCargoInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockInDetailBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutDetailBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutInfoDetailInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.UpdateCargoInfoInputBO;
import com.ifourthwall.dbm.tracker.dto.CargoCommonStatisticOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockInInfoOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockInRecordOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutByDayOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutDetailOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutInfoByIdOutputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutRecordOutputDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="cargoRepository")
public class CargoRepository {
    private static final Logger log = LoggerFactory.getLogger(CargoRepository.class);
    @Reference(version="3.0.0")
    CargoInfoFacade cargoInfoFacade;
    @Reference(version="3.0.0")
    StockInOutFacade stockInOutFacade;
    @Reference(version="3.0.0")
    CargoStatisticFacade cargoStatisticFacade;

    public void createCargoModel(CargoInfoInputBO cargoInfoInputBO) {
        log.info("\u63a5\u53e3 createCargoModel ,\u63a5\u53d7\u53c2\u6570:{}", (Object)cargoInfoInputBO);
        BaseResponse response = this.cargoInfoFacade.createCargoModel((CargoInfoDTO)IFWBeanCopyUtil.map((Object)cargoInfoInputBO, CargoInfoDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 createCargoModel ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void updateCargoModel(UpdateCargoInfoInputBO updateCargoInfoInputBO) {
        log.info("\u63a5\u53e3 updateCargoModel ,\u63a5\u53d7\u53c2\u6570:{}", (Object)updateCargoInfoInputBO);
        BaseResponse response = this.cargoInfoFacade.updateCargoModel((UpdateCargoInfoDTO)IFWBeanCopyUtil.map((Object)updateCargoInfoInputBO, UpdateCargoInfoDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 updateCargoModel ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public IFWPageInfo<CargoInfoOutputDTO> selectByCargoPage(QueryCargoInfoBO queryCargoInfoBO) {
        log.info("\u63a5\u53e3 selectByCargoPage ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCargoInfoBO);
        BaseResponse response = this.cargoInfoFacade.selectByPage((QueryCargoInfoDTO)IFWBeanCopyUtil.map((Object)queryCargoInfoBO, QueryCargoInfoDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 selectByCargoPage ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoInfoOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoInfoOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoInfoOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoInfoOutputDTOList);
        return result;
    }

    public void importCargoModel(List<CargoInfoInputBO> cargoInfoInputBOList) {
        log.info("\u63a5\u53e3 importCargoModel ,\u63a5\u53d7\u53c2\u6570:{}", cargoInfoInputBOList);
        BaseResponse response = this.cargoInfoFacade.createCargoModelBatch(IFWBeanCopyUtil.mapAsList(cargoInfoInputBOList, CargoInfoDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 importCargoModel ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void insertStockInRecord(StockInWrapDTO stockInWrapDTO) {
        log.info("\u63a5\u53e3 insertStockInRecord ,\u63a5\u53d7\u53c2\u6570:{}", (Object)stockInWrapDTO);
        BaseResponse response = this.stockInOutFacade.insertStockInRecord(stockInWrapDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 insertStockInRecord ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public void insertStockOutRecord(StockOutWrapDTO stockOutWrapDTO) {
        log.info("\u63a5\u53e3 insertStockOutRecord ,\u63a5\u53d7\u53c2\u6570:{}", (Object)stockOutWrapDTO);
        BaseResponse response = this.stockInOutFacade.insertStockOutRecord(stockOutWrapDTO);
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 insertStockOutRecord ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public StockInWrapDTO getStockInDetail(QueryStockInDetailBO queryStockInDetailBO) {
        log.info("\u63a5\u53e3 getStockInDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryStockInDetailBO);
        BaseResponse response = this.stockInOutFacade.getStockInDetail((QueryStockInDetailDTO)IFWBeanCopyUtil.map((Object)queryStockInDetailBO, QueryStockInDetailDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getStockInDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (StockInWrapDTO)response.getData();
    }

    public StockOutWrapDTO getStockOutDetail(QueryStockOutDetailBO queryStockOutDetailBO) {
        log.info("\u63a5\u53e3 getStockOutDetail ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryStockOutDetailBO);
        BaseResponse response = this.stockInOutFacade.getStockOutDetail((QueryStockOutDetailDTO)IFWBeanCopyUtil.map((Object)queryStockOutDetailBO, QueryStockOutDetailDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getStockOutDetail ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (StockOutWrapDTO)response.getData();
    }

    public IFWPageInfo<CargoStockInRecordOutputDTO> getCargoStockInRecordList(QueryCargoStockInRecordInputBO queryCargoStockInRecordInputBO) {
        log.info("\u63a5\u53e3 getCargoStockInRecordList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCargoStockInRecordInputBO);
        BaseResponse response = this.stockInOutFacade.getCargoStockInRecordList((QueryCargoStockInRecordDTO)IFWBeanCopyUtil.map((Object)queryCargoStockInRecordInputBO, QueryCargoStockInRecordDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoStockInRecordList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoInfoOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoInfoOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoStockInRecordOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoInfoOutputDTOList);
        return result;
    }

    public IFWPageInfo<CargoStockOutRecordOutputDTO> getCargoStockOutRecordList(QueryCargoStockOutRecordInputBO queryCargoStockOutRecordInputBO) {
        log.info("\u63a5\u53e3 getCargoStockOutRecordList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCargoStockOutRecordInputBO);
        BaseResponse response = this.stockInOutFacade.getCargoStockOutRecordList((QueryCargoStockOutRecordDTO)IFWBeanCopyUtil.map((Object)queryCargoStockOutRecordInputBO, QueryCargoStockOutRecordDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoStockOutRecordList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoInfoOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoInfoOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoStockOutRecordOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoInfoOutputDTOList);
        return result;
    }

    public ApprovalResultOutputDTO approvalStockOut(CargoStockOutCheckInputBO cargoStockOutCheckInputBO) {
        log.info("\u63a5\u53e3 approvalStockOut ,\u63a5\u53d7\u53c2\u6570:{}", (Object)cargoStockOutCheckInputBO);
        BaseResponse response = this.stockInOutFacade.approvalStockOut((CargoStockOutCheckDTO)IFWBeanCopyUtil.map((Object)cargoStockOutCheckInputBO, CargoStockOutCheckDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 approvalStockOut ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        return (ApprovalResultOutputDTO)IFWBeanCopyUtil.map((Object)response.getData(), ApprovalResultOutputDTO.class);
    }

    public IFWPageInfo<CargoDetailOutputDTO> getCargoDetailList(QueryCargoStatisticInputBO queryCargoStatisticInputBO) {
        log.info("\u63a5\u53e3 getCargoDetailList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryCargoStatisticInputBO);
        BaseResponse response = this.cargoStatisticFacade.getCargoDetailList((QueryCargoStatisticDTO)IFWBeanCopyUtil.map((Object)queryCargoStatisticInputBO, QueryCargoStatisticDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoDetailList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoDetailOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoDetailOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoDetailOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoDetailOutputDTOList);
        return result;
    }

    public IFWPageInfo<CargoDetailOutputDTO> getLowSafeStock(QueryLowSafeStockInputBO queryLowSafeStockInputBO) {
        log.info("\u63a5\u53e3 getLowSafeStock ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryLowSafeStockInputBO);
        BaseResponse response = this.cargoStatisticFacade.getLowSafeStock((QueryLowSafeStockDTO)IFWBeanCopyUtil.map((Object)queryLowSafeStockInputBO, QueryLowSafeStockDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getLowSafeStock ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoDetailOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoDetailOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoDetailOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoDetailOutputDTOList);
        return result;
    }

    public List<CargoStockOutByDayOutputDTO> getCargoOutByDay(QueryStockOutInfoInputBO queryStockOutInfoInputBO) {
        log.info("\u63a5\u53e3 getCargoOutByDay ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryStockOutInfoInputBO);
        BaseResponse response = this.cargoStatisticFacade.getCargoOutByDay((QueryStockOutInfoDTO)IFWBeanCopyUtil.map((Object)queryStockOutInfoInputBO, QueryStockOutInfoDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoOutByDay ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<Object> result = new ArrayList<CargoStockOutByDayOutputDTO>();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            result = IFWBeanCopyUtil.mapAsList((Iterable)data, CargoStockOutByDayOutputDTO.class);
        }
        return result;
    }

    public List<CargoStockOutDetailOutputDTO> getCargoStockOutInfoByDay(QueryStockOutInfoDetailInputBO queryStockOutInfoInputBO) {
        log.info("\u63a5\u53e3 getCargoStockOutInfoByDay ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryStockOutInfoInputBO);
        BaseResponse response = this.cargoStatisticFacade.getCargoStockOutInfoByDay((QueryStockOutInfoDTO)IFWBeanCopyUtil.map((Object)queryStockOutInfoInputBO, QueryStockOutInfoDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoStockOutInfoByDay ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<Object> result = new ArrayList<CargoStockOutDetailOutputDTO>();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            result = IFWBeanCopyUtil.mapAsList((Iterable)data, CargoStockOutDetailOutputDTO.class);
        }
        return result;
    }

    public CargoCommonStatisticOutputDTO getCargoCommonStatistics(CargoCommonStatisticsQueryInputBO cargoCommonStatisticsQueryInputBO) {
        log.info("\u63a5\u53e3 getCargoCommonStatistics ,\u63a5\u53d7\u53c2\u6570:{}", (Object)cargoCommonStatisticsQueryInputBO);
        BaseResponse response = this.cargoStatisticFacade.getCargoCommonStatistics((QueryLowSafeStockDTO)IFWBeanCopyUtil.map((Object)cargoCommonStatisticsQueryInputBO, QueryLowSafeStockDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoCommonStatistics ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        CargoCommonStatisticDTO data = (CargoCommonStatisticDTO)response.getData();
        return (CargoCommonStatisticOutputDTO)IFWBeanCopyUtil.map((Object)data, CargoCommonStatisticOutputDTO.class);
    }

    public List<CargoDetailOutputDTO> selectByCargoIdList(CargoDetailQueryInputBO cargoDetailQueryInputBO) {
        log.info("\u63a5\u53e3 selectByCargoIdList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)cargoDetailQueryInputBO);
        BaseResponse response = this.cargoInfoFacade.selectByCargoIdList((CargoDetailQueryDTO)IFWBeanCopyUtil.map((Object)cargoDetailQueryInputBO, CargoDetailQueryDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 selectByCargoIdList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List data = (List)response.getData();
        List<Object> result = new ArrayList<CargoDetailOutputDTO>();
        if (!CollectionUtils.isEmpty((Collection)data)) {
            result = IFWBeanCopyUtil.mapAsList((Iterable)data, CargoDetailOutputDTO.class);
        }
        return result;
    }

    public IFWPageInfo<CargoStockInInfoOutputDTO> getCargoStockInRecordByCargoIdList(QueryStockByCargoInputBO queryStockByCargoInputBO) {
        log.info("\u63a5\u53e3 getCargoStockInRecordByCargoIdList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryStockByCargoInputBO);
        BaseResponse response = this.stockInOutFacade.getCargoStockInByCargoId((QueryCargoStockInRecordDTO)IFWBeanCopyUtil.map((Object)queryStockByCargoInputBO, QueryCargoStockInRecordDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoStockInRecordByCargoIdList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoInfoOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoInfoOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoStockInInfoOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoInfoOutputDTOList);
        return result;
    }

    public IFWPageInfo<CargoStockOutInfoByIdOutputDTO> getCargoStockOutRecordByCargoIdList(QueryStockByCargoInputBO queryStockByCargoInputBO) {
        log.info("\u63a5\u53e3 getCargoStockOutRecordByCargoIdList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)queryStockByCargoInputBO);
        BaseResponse response = this.stockInOutFacade.getCargoStockOutByCargoId((QueryCargoStockOutRecordDTO)IFWBeanCopyUtil.map((Object)queryStockByCargoInputBO, QueryCargoStockOutRecordDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 getCargoStockOutRecordByCargoIdList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        IFWPageInfo data = (IFWPageInfo)response.getData();
        List cargoInfoOutputDTOList = new ArrayList();
        if (data != null && !CollectionUtils.isEmpty((Collection)data.getList())) {
            cargoInfoOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)data.getList(), CargoStockOutInfoByIdOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(cargoInfoOutputDTOList);
        return result;
    }
}

