/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.domain;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.common.exception.BizException;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.task.dto.ApkDTO;
import com.ifourthwall.dbm.task.dto.PageCommonDTO;
import com.ifourthwall.dbm.task.facade.ApkFacade;
import com.ifourthwall.dbm.tracker.bo.ApkInsertBO;
import com.ifourthwall.dbm.tracker.dto.ApkOutputDTO;
import com.ifourthwall.dbm.tracker.dto.BaseCommonPageDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository(value="apkRepository")
public class ApkRepository {
    private static final Logger log = LoggerFactory.getLogger(ApkRepository.class);
    @Reference(version="3.0.0")
    ApkFacade apkFacade;

    public void uploadApk(ApkInsertBO apkInsertBO) {
        log.info("\u63a5\u53e3 uploadApk ,\u63a5\u53d7\u53c2\u6570:{}", (Object)apkInsertBO);
        BaseResponse response = this.apkFacade.insertApk((ApkDTO)IFWBeanCopyUtil.map((Object)apkInsertBO, ApkDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        log.info("\u63a5\u53e3 uploadApk ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
    }

    public IFWPageInfo<ApkOutputDTO> getApkList(BaseCommonPageDTO baseCommonPageDTO) {
        log.info("\u63a5\u53e3 getApkList ,\u63a5\u53d7\u53c2\u6570:{}", (Object)baseCommonPageDTO);
        BaseResponse response = this.apkFacade.getApkList((PageCommonDTO)IFWBeanCopyUtil.map((Object)baseCommonPageDTO, PageCommonDTO.class));
        if (!response.isFlag()) {
            throw new BizException(response.getRetMsg(), response.getRetCode());
        }
        IFWPageInfo data = (IFWPageInfo)response.getData();
        log.info("\u63a5\u53e3 getApkList ,\u8fd4\u56de\u7ed3\u679c:{}", response.getData());
        List list = data.getList();
        List apkOutputDTOList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            apkOutputDTOList = IFWBeanCopyUtil.mapAsList((Iterable)list, ApkOutputDTO.class);
        }
        IFWPageInfo result = new IFWPageInfo();
        result.setTotal(data.getTotal());
        result.setPageNum(data.getPageNum());
        result.setPageSize(data.getPageSize());
        result.setList(apkOutputDTOList);
        return result;
    }
}

