/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.tracker.bo.ContactQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ProjectQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryReqEmployeeInputBO;
import com.ifourthwall.dbm.tracker.dto.ContactQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.ProjectQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryReqEmployeeInputDTO;
import com.ifourthwall.dbm.tracker.service.OrganizationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Tracker App(\u901a\u8baf\u5f55\u76f8\u5173)"}, value="OrganizationController")
@RestController
@RequestMapping(value={"/dbm/tracker/organization"})
public class OrganizationController {
    private static final Logger log = LoggerFactory.getLogger(OrganizationController.class);
    @Resource(name="organizationServiceImpl")
    OrganizationService organizationService;

    @ApiOperation(value="\u67e5\u8be2\u8054\u7cfb\u4eba\u5217\u8868", notes="fpc")
    @PostMapping(value={"/get/contact/list"})
    public ResponseEntity<BaseResponse> getContactList(IFWUser ifwUser, @RequestBody ContactQueryInputDTO contactQueryInputDTO) {
        log.info("\u63a5\u53e3 /api/organization/get/contact/list \u8bf7\u6c42\u53c2\u6570{}", (Object)contactQueryInputDTO);
        BaseResponse response = this.organizationService.getContactList(ifwUser, (ContactQueryInputBO)IFWBeanCopyUtil.map((Object)contactQueryInputDTO, ContactQueryInputBO.class));
        log.info("\u63a5\u53e3 /api/organization/get/contact/list \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u67e5\u8be2\u9879\u76ee\u5217\u8868--(\u5f03\u7528\uff0c\u76f4\u63a5\u8c03ProjectBackend)", notes="fpc")
    @PostMapping(value={"/get/project/list"})
    public ResponseEntity<BaseResponse> getProjectList(IFWUser ifwUser, @RequestBody ProjectQueryInputDTO projectQueryInputDTO) {
        log.info("\u63a5\u53e3 /api/organization/get/project/list \u8bf7\u6c42\u53c2\u6570{}", (Object)projectQueryInputDTO);
        BaseResponse response = this.organizationService.getProjectList(ifwUser, (ProjectQueryInputBO)IFWBeanCopyUtil.map((Object)projectQueryInputDTO, ProjectQueryInputBO.class));
        log.info("\u63a5\u53e3 /api/organization/get/project/list \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636e\u5c97\u4f4did\u67e5\u8be2\u5bf9\u5e94\u7684\u4eba\u5458\u4fe1\u606f", notes="fpc")
    @PostMapping(value={"/get/employee/list"})
    public ResponseEntity<BaseResponse> queryPositionAndEmployeeByPositionId(IFWUser ifwUser, @RequestBody QueryReqEmployeeInputDTO queryReqEmployeeInputDTO) {
        log.info("\u63a5\u53e3 /api/organization/get/employee/list \u8bf7\u6c42\u53c2\u6570{}", (Object)queryReqEmployeeInputDTO);
        BaseResponse response = this.organizationService.queryPositionAndEmployeeByPositionId(ifwUser, (QueryReqEmployeeInputBO)IFWBeanCopyUtil.map((Object)queryReqEmployeeInputDTO, QueryReqEmployeeInputBO.class));
        log.info("\u63a5\u53e3 /api/organization/get/employee/list \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

