/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.tracker.bo.DocQueryBO;
import com.ifourthwall.dbm.tracker.bo.GroupQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.KnowledgeSearchInputBO;
import com.ifourthwall.dbm.tracker.bo.RepoQueryBO;
import com.ifourthwall.dbm.tracker.dto.DocQueryDTO;
import com.ifourthwall.dbm.tracker.dto.GroupQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.KnowledgeSearchInputDTO;
import com.ifourthwall.dbm.tracker.dto.RepoQueryDTO;
import com.ifourthwall.dbm.tracker.service.KnowledgeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u77e5\u8bc6\u5e93\u76f8\u5173"}, value="KnowledgeController")
@RestController
@RequestMapping(value={"/dbm/tracker/knowledge"})
public class KnowledgeController {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeController.class);
    @Resource(name="knowledgeServiceImpl")
    KnowledgeService knowledgeService;

    @ApiOperation(value="\u67e5\u8be2\u8be5\u7528\u6237\u8bed\u96c0\u4e0a\u7684\u57fa\u672c\u4fe1\u606f(\u9009\u62e9\u6587\u6863\u4e4b\u524d\u5148\u5224\u65ad\u5728\u8bed\u96c0\u4e0a\u6709\u6ca1\u6709\u6ce8\u518c\u5e76\u548cdbm\u7ed1\u5b9a)", notes="fpc")
    @PostMapping(value={"/query/user/info"})
    public ResponseEntity<BaseResponse> createWorksheetBatch(IFWUser ifwUser) {
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/user/info \u8bf7\u6c42\u53c2\u6570{}", (Object)"");
        BaseResponse response = this.knowledgeService.getYuqueUserInfo(ifwUser);
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/user/info \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u77e5\u8bc6\u5e93\u6587\u641c\u7d22", notes="fpc")
    @PostMapping(value={"/search"})
    public ResponseEntity<BaseResponse> search(IFWUser ifwUser, @RequestBody KnowledgeSearchInputDTO knowledgeSearchInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/search \u8bf7\u6c42\u53c2\u6570{}", (Object)knowledgeSearchInputDTO);
        BaseResponse response = this.knowledgeService.search(ifwUser, (KnowledgeSearchInputBO)IFWBeanCopyUtil.map((Object)knowledgeSearchInputDTO, KnowledgeSearchInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/search \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u67e5\u770b\u52a0\u5165\u56e2\u961f\u4fe1\u606f", notes="fpc")
    @PostMapping(value={"/query/group"})
    public ResponseEntity<BaseResponse> getTeamInfo(IFWUser ifwUser, @RequestBody GroupQueryInputDTO groupQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/group \u8bf7\u6c42\u53c2\u6570{}", (Object)groupQueryInputDTO);
        BaseResponse response = this.knowledgeService.getTeamInfo(ifwUser, (GroupQueryInputBO)IFWBeanCopyUtil.map((Object)groupQueryInputDTO, GroupQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/group \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u7528\u6237/\u56e2\u961f\u7684\u77e5\u8bc6\u5e93\u5217\u8868")
    @PostMapping(value={"/query/repo/list"})
    public ResponseEntity<BaseResponse> queryRepoList(IFWUser ifwUser, @RequestBody RepoQueryDTO repoQueryDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/repo/list \u8bf7\u6c42\u53c2\u6570{}", (Object)repoQueryDTO);
        BaseResponse response = this.knowledgeService.queryRepoList(ifwUser, (RepoQueryBO)IFWBeanCopyUtil.map((Object)repoQueryDTO, RepoQueryBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/repo/list \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u77e5\u8bc6\u5e93\u4e0b\u7684\u6587\u6863\u4fe1\u606f")
    @PostMapping(value={"/query/doc/list"})
    public ResponseEntity<BaseResponse> queryDocList(IFWUser ifwUser, @RequestBody DocQueryDTO docQueryDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/doc/list \u8bf7\u6c42\u53c2\u6570{}", (Object)docQueryDTO);
        BaseResponse response = this.knowledgeService.queryDocList(ifwUser, (DocQueryBO)IFWBeanCopyUtil.map((Object)docQueryDTO, DocQueryBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/knowledge/query/doc/list \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

