/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.tracker.bo.WaitFeedBackQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.WorksheetBatchCreateInputBO;
import com.ifourthwall.dbm.tracker.dto.WorksheetBatchCreateInputDTO;
import com.ifourthwall.dbm.tracker.service.JobService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Job\u6267\u884c\u76f8\u5173"}, value="JobController")
@RestController
@RequestMapping(value={"/dbm/tracker/job"})
public class JobController {
    private static final Logger log = LoggerFactory.getLogger(JobController.class);
    @Resource(name="jobServiceImpl")
    JobService jobService;

    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u5de5\u5355(\u65e5\u5e38\u4efb\u52a1)", notes="fpc")
    @PostMapping(value={"/daily/create/batch"})
    public ResponseEntity<BaseResponse> createWorksheetBatch(IFWUser ifwUser, @RequestBody WorksheetBatchCreateInputDTO worksheetBatchCreateInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/job/daily/create/batch \u8bf7\u6c42\u53c2\u6570{}", (Object)worksheetBatchCreateInputDTO);
        BaseResponse response = this.jobService.createWorksheetBatch(ifwUser, (WorksheetBatchCreateInputBO)IFWBeanCopyUtil.map((Object)worksheetBatchCreateInputDTO, WorksheetBatchCreateInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/job/daily/create/batch \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6279\u91cf\u751f\u6210\u5de5\u5355\uff08\u8ba1\u5212\u4efb\u52a1\uff09", notes="fpc")
    @PostMapping(value={"/plan/create/batch"})
    public ResponseEntity<BaseResponse> createPlanTaskWorksheetBatch(IFWUser ifwUser, @RequestBody WorksheetBatchCreateInputDTO worksheetBatchCreateInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/job/plan/create/batch \u8bf7\u6c42\u53c2\u6570{}", (Object)worksheetBatchCreateInputDTO);
        BaseResponse response = this.jobService.createPlanTaskWorksheetBatch(ifwUser, (WorksheetBatchCreateInputBO)IFWBeanCopyUtil.map((Object)worksheetBatchCreateInputDTO, WorksheetBatchCreateInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/job/plan/create/batch \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u81ea\u52a8\u53cd\u9988", notes="fpc")
    @PostMapping(value={"/auto/feedback"})
    public ResponseEntity<BaseResponse> autoFeedBack(IFWUser ifwUser, @RequestBody WorksheetBatchCreateInputDTO worksheetBatchCreateInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/job/auto/feedback \u8bf7\u6c42\u53c2\u6570{}", (Object)worksheetBatchCreateInputDTO);
        BaseResponse response = this.jobService.autoFeedBckWorksheet(ifwUser, (WaitFeedBackQueryInputBO)IFWBeanCopyUtil.map((Object)worksheetBatchCreateInputDTO, WaitFeedBackQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/job/auto/feedback \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u53d1\u9001\u65e5\u5e38\u4efb\u52a1\u6d88\u606f", notes="fpc")
    @PostMapping(value={"/send/daily/message"})
    public ResponseEntity<BaseResponse> sendDailyWorksheetMessage(IFWUser ifwUser) {
        log.info("\u63a5\u53e3 /dbm/tracker/job/send/daily/message \u8bf7\u6c42\u53c2\u6570{}");
        BaseResponse response = this.jobService.sendDailyWorksheetMessage(ifwUser);
        log.info("\u63a5\u53e3 /dbm/tracker/job/send/daily/message \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

