/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.controller;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.tracker.bo.ExportDailyWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.ExportTemporaryWorksheetQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryScanResultByCheckpointIdInputBO;
import com.ifourthwall.dbm.tracker.bo.ReportingQueryListInputBO;
import com.ifourthwall.dbm.tracker.dto.ExportDailyWorksheetQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.ExportTemporaryWorksheetQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryScanResultByCheckpointIdInputDTO;
import com.ifourthwall.dbm.tracker.dto.ReportingQueryListInputDTO;
import com.ifourthwall.dbm.tracker.service.ReportingService;
import com.ifourthwall.dbm.tracker.service.WorksheetEventService;
import com.ifourthwall.dbm.tracker.service.WorksheetService;
import com.ifourthwall.dbm.tracker.utils.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"tracker\u5bfc\u51faexcel\u8868\u683c"}, value="ConfigController")
@RestController
@RequestMapping(value={"/dbm/tracker/excel"})
public class ExcelController {
    private static final Logger log = LoggerFactory.getLogger(ExcelController.class);
    @Resource(name="worksheetServiceImpl")
    WorksheetService worksheetService;
    @Resource(name="worksheetEventServiceImpl")
    WorksheetEventService worksheetEventService;
    @Resource(name="reportingServiceImpl")
    ReportingService reportingService;
    @Resource
    HttpServletResponse response;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u51fa\u4e34\u65f6\u4efb\u52a1\u5de5\u5355\u6570\u636e", notes="fpc")
    @PostMapping(value={"/get/temporary/worksheet"})
    public ResponseEntity<BaseResponse> getExportTemporaryWorksheetList(IFWUser ifwUser, @RequestBody ExportTemporaryWorksheetQueryInputDTO exportTemporaryWorksheetQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/get/temporary/worksheet \u8bf7\u6c42\u53c2\u6570{}", (Object)exportTemporaryWorksheetQueryInputDTO);
        BaseResponse response = this.worksheetService.getExportTemporaryWorksheetList(ifwUser, (ExportTemporaryWorksheetQueryInputBO)IFWBeanCopyUtil.map((Object)exportTemporaryWorksheetQueryInputDTO, ExportTemporaryWorksheetQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/get/temporary/worksheet \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u4e34\u65f6\u4efb\u52a1\u5de5\u5355excel\u8868\u683c", notes="fpc")
    @PostMapping(value={"/export/temporary/worksheet"})
    public ResponseEntity<BaseResponse> exportTemporaryWorksheetList(IFWUser ifwUser, @RequestBody ExportTemporaryWorksheetQueryInputDTO exportTemporaryWorksheetQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/temporary/worksheet \u8bf7\u6c42\u53c2\u6570{}", (Object)exportTemporaryWorksheetQueryInputDTO);
        BaseResponse data = this.worksheetService.exportTemporaryWorksheetList(ifwUser, (ExportTemporaryWorksheetQueryInputBO)IFWBeanCopyUtil.map((Object)exportTemporaryWorksheetQueryInputDTO, ExportTemporaryWorksheetQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/temporary/worksheet \u76f8\u5e94\u6570\u636e{}", (Object)data);
        ExcelUtils.exportExcelData((Workbook)((Workbook)data.getData()), (String)"\u4e34\u65f6\u4efb\u52a1\u5de5\u5355\u5bfc\u51fa", (HttpServletResponse)this.response);
        return null;
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5bfc\u51fa\u65e5\u5e38\u4efb\u52a1\u5de5\u5355\u6570\u636e", notes="fpc")
    @PostMapping(value={"/get/daily/worksheet"})
    public ResponseEntity<BaseResponse> getExportDailyWorksheetList(IFWUser ifwUser, @RequestBody ExportDailyWorksheetQueryInputDTO exportDailyWorksheetQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/get/daily/worksheet \u8bf7\u6c42\u53c2\u6570{}", (Object)exportDailyWorksheetQueryInputDTO);
        BaseResponse response = this.worksheetService.getExportDailyWorksheetList(ifwUser, (ExportDailyWorksheetQueryInputBO)IFWBeanCopyUtil.map((Object)exportDailyWorksheetQueryInputDTO, ExportDailyWorksheetQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/get/daily/worksheet \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u65e5\u5e38\u4efb\u52a1\u5de5\u5355excel\u8868\u683c", notes="fpc")
    @PostMapping(value={"/export/daily/worksheet"})
    public ResponseEntity<BaseResponse> exportDailyWorksheetList(IFWUser ifwUser, @RequestBody ExportDailyWorksheetQueryInputDTO exportDailyWorksheetQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/daily/worksheet \u8bf7\u6c42\u53c2\u6570{}", (Object)exportDailyWorksheetQueryInputDTO);
        BaseResponse data = this.worksheetService.exportDailyWorksheetList(ifwUser, (ExportDailyWorksheetQueryInputBO)IFWBeanCopyUtil.map((Object)exportDailyWorksheetQueryInputDTO, ExportDailyWorksheetQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/daily/worksheet \u76f8\u5e94\u6570\u636e{}", (Object)data);
        ExcelUtils.exportExcelData((Workbook)((Workbook)data.getData()), (String)"\u65e5\u5e38\u4efb\u52a1\u5de5\u5355\u5bfc\u51fa", (HttpServletResponse)this.response);
        return null;
    }

    @ApiOperation(value="\u6839\u636echeckpointId\u67e5\u8be2\u70b9\u4f4d\u5de1\u89c6\u6570\u636e")
    @PostMapping(value={"/query/scan/checkpoint"})
    public ResponseEntity<BaseResponse> getScanInfoByCheckpoint(IFWUser ifwUser, @RequestBody QueryScanResultByCheckpointIdInputDTO queryScanResultByCheckpointIdInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/query/scan/checkpoint \u8bf7\u6c42\u53c2\u6570{}", (Object)queryScanResultByCheckpointIdInputDTO);
        BaseResponse response = this.worksheetEventService.getScanInfoByCheckpoint(ifwUser, (QueryScanResultByCheckpointIdInputBO)IFWBeanCopyUtil.map((Object)queryScanResultByCheckpointIdInputDTO, QueryScanResultByCheckpointIdInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/query/scan/checkpoint \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u6839\u636echeckpointId\u67e5\u8be2\u70b9\u4f4d\u5de1\u89c6\u6570\u636e")
    @PostMapping(value={"/export/scan/checkpoint"})
    public ResponseEntity<BaseResponse> exportScanInfoByCheckpoinnt(IFWUser ifwUser, @RequestBody QueryScanResultByCheckpointIdInputDTO queryScanResultByCheckpointIdInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/scan/checkpoint \u8bf7\u6c42\u53c2\u6570{}", (Object)queryScanResultByCheckpointIdInputDTO);
        BaseResponse data = this.worksheetEventService.exportScanInfoByCheckpoint(ifwUser, (QueryScanResultByCheckpointIdInputBO)IFWBeanCopyUtil.map((Object)queryScanResultByCheckpointIdInputDTO, QueryScanResultByCheckpointIdInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/scan/checkpoint \u76f8\u5e94\u6570\u636e{}", (Object)this.response);
        ExcelUtils.exportExcelData((Workbook)((Workbook)data.getData()), (String)"\u70b9\u4f4d\u5de1\u89c6\u8bb0\u5f55", (HttpServletResponse)this.response);
        return null;
    }

    @ApiOperation(value="\u5bfc\u51fa\u62a5\u4e8b\u5217\u8868")
    @PostMapping(value={"/export/report/list"})
    public ResponseEntity<BaseResponse> exportReportList(IFWUser ifwUser, @RequestBody ReportingQueryListInputDTO reportingQueryListInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/report/list \u8bf7\u6c42\u53c2\u6570{}", (Object)reportingQueryListInputDTO);
        BaseResponse data = this.reportingService.exportReportList(ifwUser, (ReportingQueryListInputBO)IFWBeanCopyUtil.map((Object)reportingQueryListInputDTO, ReportingQueryListInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/report/list \u76f8\u5e94\u6570\u636e{}", (Object)this.response);
        ExcelUtils.exportExcelData((Workbook)((Workbook)data.getData()), (String)"\u62a5\u4e8b\u8bb0\u5f55", (HttpServletResponse)this.response);
        return null;
    }
}

