/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.controller;

import com.ifourthwall.common.base.BaseReqDTO;
import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWUser;
import com.ifourthwall.common.utils.IFWBeanCopyUtil;
import com.ifourthwall.dbm.tracker.bo.CargoCommonStatisticsQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoDetailQueryInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.CargoStockOutCheckInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoInfoBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStatisticInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStockInRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryCargoStockOutRecordInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryLowSafeStockInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockByCargoInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockInDetailBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutDetailBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutInfoDetailInputBO;
import com.ifourthwall.dbm.tracker.bo.QueryStockOutInfoInputBO;
import com.ifourthwall.dbm.tracker.bo.StockInWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.StockOutWrapInputBO;
import com.ifourthwall.dbm.tracker.bo.UpdateCargoInfoInputBO;
import com.ifourthwall.dbm.tracker.dto.CargoCommonStatisticsQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoDetailQueryInputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoInfoInputDTO;
import com.ifourthwall.dbm.tracker.dto.CargoStockOutCheckInputDTO;
import com.ifourthwall.dbm.tracker.dto.ImportCargoInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryCargoInfoDTO;
import com.ifourthwall.dbm.tracker.dto.QueryCargoStatisticInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryCargoStockInRecordInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryCargoStockOutRecordInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryLowSafeStockInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryStockByCargoInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryStockInDetailDTO;
import com.ifourthwall.dbm.tracker.dto.QueryStockOutDetailDTO;
import com.ifourthwall.dbm.tracker.dto.QueryStockOutInfoDetailInputDTO;
import com.ifourthwall.dbm.tracker.dto.QueryStockOutInfoInputDTO;
import com.ifourthwall.dbm.tracker.dto.StockInWrapInputDTO;
import com.ifourthwall.dbm.tracker.dto.StockOutWrapInputDTO;
import com.ifourthwall.dbm.tracker.dto.UpdateCargoInfoInputDTO;
import com.ifourthwall.dbm.tracker.service.CargoService;
import com.ifourthwall.dbm.tracker.utils.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u5907\u54c1\u5907\u4ef6\u76f8\u5173"}, value="CargoController")
@RestController
@RequestMapping(value={"/dbm/tracker/cargo"})
public class CargoController {
    private static final Logger log = LoggerFactory.getLogger(CargoController.class);
    @Resource(name="cargoServiceImpl")
    CargoService cargoService;
    @Resource
    HttpServletResponse servletResponse;

    @ApiOperation(value="\u65b0\u589e\u8d27\u7269\u6a21\u7248", notes="fpc")
    @PostMapping(value={"/create"})
    public ResponseEntity<BaseResponse> create(IFWUser ifwUser, @RequestBody CargoInfoInputDTO cargoInfoInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/create \u8bf7\u6c42\u53c2\u6570{}", (Object)cargoInfoInputDTO);
        BaseResponse response = this.cargoService.createCargoModel(ifwUser, (CargoInfoInputBO)IFWBeanCopyUtil.map((Object)cargoInfoInputDTO, CargoInfoInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/create \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u66f4\u65b0\u7269\u6599\u6a21\u7248", notes="fpc")
    @PostMapping(value={"/update"})
    public ResponseEntity<BaseResponse> update(IFWUser ifwUser, @RequestBody UpdateCargoInfoInputDTO updateCargoInfoInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/update \u8bf7\u6c42\u53c2\u6570{}", (Object)updateCargoInfoInputDTO);
        BaseResponse response = this.cargoService.updateCargoModel(ifwUser, (UpdateCargoInfoInputBO)IFWBeanCopyUtil.map((Object)updateCargoInfoInputDTO, UpdateCargoInfoInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/update \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u8d27\u7269\u6a21\u7248", notes="fpc")
    @PostMapping(value={"/list"})
    public ResponseEntity<BaseResponse> selectByCargoPage(IFWUser ifwUser, @RequestBody QueryCargoInfoDTO queryCargoInfoDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/list \u8bf7\u6c42\u53c2\u6570{}", (Object)queryCargoInfoDTO);
        BaseResponse response = this.cargoService.selectByCargoPage(ifwUser, (QueryCargoInfoBO)IFWBeanCopyUtil.map((Object)queryCargoInfoDTO, QueryCargoInfoBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/list \u76f8\u5e94\u6570\u636e{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u8d27\u7269\u6a21\u7248", notes="fpc")
    @PostMapping(value={"/download/model"})
    public ResponseEntity<BaseResponse> downloadCardModel(IFWUser ifwUser, @RequestBody BaseReqDTO baseReqDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/download/model \u8bf7\u6c42\u53c2\u6570{}", (Object)"");
        Workbook sheets = this.cargoService.downloadCardModel(ifwUser, baseReqDTO);
        ExcelUtils.exportExcelData((Workbook)sheets, (String)"\u4eba\u5458\u6a21\u7248", (HttpServletResponse)this.servletResponse);
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/download/model \u8fd4\u56de\u53c2\u6570:{}");
        return null;
    }

    @ApiOperation(value="\u8d27\u7269\u5bfc\u5165")
    @PostMapping(value={"/import"})
    public ResponseEntity<BaseResponse> importCargoModel(IFWUser ifwUser, MultipartFile file, ImportCargoInputDTO importCargoInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/import \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.importCargoModel(ifwUser, file, importCargoInputDTO);
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/import \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5165\u5e93")
    @PostMapping(value={"/stock/in"})
    public ResponseEntity<BaseResponse> insertStockInRecord(IFWUser ifwUser, @RequestBody StockInWrapInputDTO stockInWrapInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.insertStockInRecord(ifwUser, (StockInWrapInputBO)IFWBeanCopyUtil.map((Object)stockInWrapInputDTO, StockInWrapInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u51fa\u5e93", notes="fpc")
    @PostMapping(value={"/stock/out"})
    public ResponseEntity<BaseResponse> insertStockOutRecord(IFWUser ifwUser, @RequestBody StockOutWrapInputDTO stockOutWrapInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.insertStockOutRecord(ifwUser, (StockOutWrapInputBO)IFWBeanCopyUtil.map((Object)stockOutWrapInputDTO, StockOutWrapInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5165\u5e93\u8be6\u60c5")
    @PostMapping(value={"/stock/in/detail"})
    public ResponseEntity<BaseResponse> getStockInDetail(IFWUser ifwUser, @RequestBody QueryStockInDetailDTO queryStockInDetailDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/detail \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getStockInDetail(ifwUser, (QueryStockInDetailBO)IFWBeanCopyUtil.map((Object)queryStockInDetailDTO, QueryStockInDetailBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/detail \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u51fa\u5e93\u8be6\u60c5")
    @PostMapping(value={"/stock/out/detail"})
    public ResponseEntity<BaseResponse> getStockOutDetail(IFWUser ifwUser, @RequestBody QueryStockOutDetailDTO queryStockOutDetailDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/detail \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getStockOutDetail(ifwUser, (QueryStockOutDetailBO)IFWBeanCopyUtil.map((Object)queryStockOutDetailDTO, QueryStockOutDetailBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/detail \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5165\u5e93\u5217\u8868")
    @PostMapping(value={"/stock/in/list"})
    public ResponseEntity<BaseResponse> getCargoStockInRecordList(IFWUser ifwUser, @RequestBody QueryCargoStockInRecordInputDTO queryCargoStockInRecordInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/list \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoStockInRecordList(ifwUser, (QueryCargoStockInRecordInputBO)IFWBeanCopyUtil.map((Object)queryCargoStockInRecordInputDTO, QueryCargoStockInRecordInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/list \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u51fa\u5e93\u5217\u8868")
    @PostMapping(value={"/stock/out/list"})
    public ResponseEntity<BaseResponse> getCargoStockOutRecordList(IFWUser ifwUser, @RequestBody QueryCargoStockOutRecordInputDTO queryCargoStockOutRecordInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/list \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoStockOutRecordList(ifwUser, (QueryCargoStockOutRecordInputBO)IFWBeanCopyUtil.map((Object)queryCargoStockOutRecordInputDTO, QueryCargoStockOutRecordInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/list \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5ba1\u6838\u51fa\u5e93")
    @PostMapping(value={"/stock/out/approval"})
    public ResponseEntity<BaseResponse> approvalStockOut(IFWUser ifwUser, @RequestBody CargoStockOutCheckInputDTO cargoStockOutCheckInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/approval \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.approvalStockOut(ifwUser, (CargoStockOutCheckInputBO)IFWBeanCopyUtil.map((Object)cargoStockOutCheckInputDTO, CargoStockOutCheckInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/approval \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u7269\u6599\u76d8\u70b9\u5217\u8868")
    @PostMapping(value={"/statistic/list"})
    public ResponseEntity<BaseResponse> getCargoDetailList(IFWUser ifwUser, @RequestBody QueryCargoStatisticInputDTO queryCargoStatisticInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/list \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoDetailList(ifwUser, (QueryCargoStatisticInputBO)IFWBeanCopyUtil.map((Object)queryCargoStatisticInputDTO, QueryCargoStatisticInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/list \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u5bfc\u51fa\u7269\u6599\u76d8\u70b9\u6570\u636e", notes="fpc")
    @PostMapping(value={"/export/statistic/list"})
    public ResponseEntity<BaseResponse> exportCargoDetailList(IFWUser ifwUser, @RequestBody QueryCargoStatisticInputDTO queryCargoStatisticInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/statistic/list \u8bf7\u6c42\u53c2\u6570{}", (Object)queryCargoStatisticInputDTO);
        BaseResponse data = this.cargoService.exportCargoDetailList(ifwUser, (QueryCargoStatisticInputBO)IFWBeanCopyUtil.map((Object)queryCargoStatisticInputDTO, QueryCargoStatisticInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/excel/export/statistic/list \u76f8\u5e94\u6570\u636e{}", (Object)data);
        ExcelUtils.exportExcelData((Workbook)((Workbook)data.getData()), (String)"\u7269\u6599\u76d8\u70b9\u6570\u636e\u5bfc\u51fa", (HttpServletResponse)this.servletResponse);
        return null;
    }

    @ApiOperation(value="\u4f4e\u4e8e\u5b89\u5168\u5e93\u5b58\u7684\u5217\u8868")
    @PostMapping(value={"/statistic/low/stock/list"})
    public ResponseEntity<BaseResponse> getLowSafeStock(IFWUser ifwUser, @RequestBody QueryLowSafeStockInputDTO queryLowSafeStockInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/low/stock/list \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getLowSafeStock(ifwUser, (QueryLowSafeStockInputBO)IFWBeanCopyUtil.map((Object)queryLowSafeStockInputDTO, QueryLowSafeStockInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/low/stock/list \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6298\u7ebf\u56fe")
    @PostMapping(value={"/statistic/line"})
    public ResponseEntity<BaseResponse> getCargoOutByDay(IFWUser ifwUser, @RequestBody QueryStockOutInfoInputDTO queryStockOutInfoInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/line \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoOutByDay(ifwUser, (QueryStockOutInfoInputBO)IFWBeanCopyUtil.map((Object)queryStockOutInfoInputDTO, QueryStockOutInfoInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/line \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6298\u7ebf\u56fe\u6bcf\u4e2a\u70b9\u7684\u8be6\u60c5")
    @PostMapping(value={"/statistic/line/detail"})
    public ResponseEntity<BaseResponse> getCargoStockOutInfoByDay(IFWUser ifwUser, @RequestBody QueryStockOutInfoDetailInputDTO queryStockOutInfoDetailInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/line/detail \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoStockOutInfoByDay(ifwUser, (QueryStockOutInfoDetailInputBO)IFWBeanCopyUtil.map((Object)queryStockOutInfoDetailInputDTO, QueryStockOutInfoDetailInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/line/detail \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u652f\u6491\u5929\u6570")
    @PostMapping(value={"/statistic/common"})
    public ResponseEntity<BaseResponse> getCargoCommonStatistics(IFWUser ifwUser, @RequestBody CargoCommonStatisticsQueryInputDTO cargoCommonStatisticsQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/common \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoCommonStatistics(ifwUser, (CargoCommonStatisticsQueryInputBO)IFWBeanCopyUtil.map((Object)cargoCommonStatisticsQueryInputDTO, CargoCommonStatisticsQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/statistic/common \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636e\u8d27\u7269id\uff0c\u67e5\u8be2\u8d27\u7269\u8be6\u60c5")
    @PostMapping(value={"/detail"})
    public ResponseEntity<BaseResponse> getCargoDetail(IFWUser ifwUser, @RequestBody CargoDetailQueryInputDTO cargoDetailQueryInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/detail \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoDetail(ifwUser, (CargoDetailQueryInputBO)IFWBeanCopyUtil.map((Object)cargoDetailQueryInputDTO, CargoDetailQueryInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/detail \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636ecargoId\u5206\u9875\u67e5\u8be2\u5165\u5e93\u4fe1\u606f")
    @PostMapping(value={"/stock/in/list/by/cargo"})
    public ResponseEntity<BaseResponse> getCargoStockInRecordByCargoIdList(IFWUser ifwUser, @RequestBody QueryStockByCargoInputDTO queryStockByCargoInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/list/by/cargo \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoStockInRecordByCargoIdList(ifwUser, (QueryStockByCargoInputBO)IFWBeanCopyUtil.map((Object)queryStockByCargoInputDTO, QueryStockByCargoInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/list/by/cargo \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }

    @ApiOperation(value="\u6839\u636ecargoId\u5206\u9875\u67e5\u8be2\u51fa\u5e93\u4fe1\u606f")
    @PostMapping(value={"/stock/out/list/by/cargo"})
    public ResponseEntity<BaseResponse> getCargoStockOutRecordByCargoIdList(IFWUser ifwUser, @RequestBody QueryStockByCargoInputDTO queryStockByCargoInputDTO) {
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/out/list/by/cargo \u63a5\u53d7\u53c2\u6570:{}", (Object)"");
        BaseResponse response = this.cargoService.getCargoStockOutRecordByCargoIdList(ifwUser, (QueryStockByCargoInputBO)IFWBeanCopyUtil.map((Object)queryStockByCargoInputDTO, QueryStockByCargoInputBO.class));
        log.info("\u63a5\u53e3 /dbm/tracker/cargo/stock/in/list/by/cargo \u8fd4\u56de\u53c2\u6570:{}", (Object)response);
        return ResponseEntity.ok((Object)response);
    }
}

