/*
 * Decompiled with CFR 0.152.
 */
package com.ifourthwall.dbm.tracker.config;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisLockHelper {
    private static final Logger log = LoggerFactory.getLogger(RedisLockHelper.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public synchronized boolean lock(String targetId, String timeStamp) {
        String preLock;
        if (this.stringRedisTemplate.opsForValue().setIfAbsent((Object)targetId, (Object)timeStamp, 10000L, TimeUnit.MILLISECONDS).booleanValue()) {
            return true;
        }
        String currentLock = (String)this.stringRedisTemplate.opsForValue().get((Object)targetId);
        if (!StringUtils.isBlank((CharSequence)currentLock) && Long.parseLong(currentLock) < System.currentTimeMillis() && !StringUtils.isBlank((CharSequence)(preLock = (String)this.stringRedisTemplate.opsForValue().getAndSet((Object)targetId, (Object)timeStamp)))) {
            this.stringRedisTemplate.expire((Object)targetId, 10000L, TimeUnit.MILLISECONDS);
            return true;
        }
        return false;
    }

    public synchronized void unlock(String target, String timeStamp) {
        try {
            String currentValue = (String)this.stringRedisTemplate.opsForValue().get((Object)target);
            if (!StringUtils.isBlank((CharSequence)currentValue) && currentValue.equals(timeStamp)) {
                this.stringRedisTemplate.opsForValue().getOperations().delete((Object)target);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u9501\u5f02\u5e38{}", (Throwable)e);
        }
    }
}

