package com.ifourthwall.dbm.security.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.security.dto.*;

/**
 * @Author: tanglei
 * @Date: 2020-03-16 18:07
 * @Description:
 */
public interface UfaceTenantFacade {

    /**
     * 查询租户下的uface应用
     * @Param: queryUfaceTenantReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.QueryUfaceTenantResDTO>
     * @Author: tanglei
     * @Date: 2020/3/16 18:22
     */
    BaseResponse<QueryUfaceTenantResDTO> selectUfaceTenant(QueryUfaceTenantReqDTO queryUfaceTenantReqDTO);

    /**
     * uface的AppId和租户绑定
     * @Param: insertUfaceAppIdResDTO
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.security.dto.InsertUfaceAppIdResDTO>
     * @Author: tanglei
     * @Date: 2020/4/28 14:24
     */
    BaseResponse<InsertUfaceAppIdResDTO> bingUfaceAppIdAndTenantId(InsertUfaceAppIdResDTO insertUfaceAppIdResDTO);

    /**
     * uface应用修改
     * @Param: [updateUfaceResDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.user.dto.BindUfaceResDTO>>>
     * @Author: tanglei
     * @Date: 2020/4/29 15:34
     */
    BaseResponse<UpdateUfaceResDTO> updateUface(UpdateUfaceResDTO updateUfaceResDTO);



}
