package com.ifourthwall.dbm.security.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.security.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-03-11 18:51
 * @Description:
 */
public interface UfacePersonFacade {


    /**
     * 查询这个租户下的门禁的人员信息
     * @Param: personReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.dbm.security.dto.UfacePersonDTO>>
     * @Author: tanglei
     * @Date: 2020/3/12 9:46
     */
    BaseResponse<List<UfacePersonDTO>> selectTenantToUser(QueryUfacePersonReqDTO personReqDTO);


    /**
     * 添加租户和门禁人员的关系
     * @Param: insertPersonReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.InsertPersonReqDTO>
     * @Author: tanglei
     * @Date: 2020/3/12 11:52
     */
    BaseResponse<InsertUfacePersonDTO> createUfacePerson(InsertUfacePersonDTO insertUfacePersonDTO);


    /**
     * 删除门禁人员和租户人员信息
     * @Param: deleteUfacePersonDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.DeleteUfacePersonDTO>
     * @Author: tanglei
     * @Date: 2020/3/12 11:52
     */
    BaseResponse<DeleteUfacePersonDTO> deleteUfacePerson(DeleteUfacePersonDTO deleteUfacePersonDTO);
}
