package com.ifourthwall.dbm.security.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.security.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-06-29 16:04
 * @Description:
 */
public interface PersonBadgeInfoFacade {

    /**
     * 工牌mac地址和人员绑定
     * @Param: insertPersonBadgeInfo
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.InsertPersonBadgeInfoDTO>
     * @Author: tanglei
     * @Date: 2020/6/30 11:16
     */
    BaseResponse<InsertPersonBadgeInfoDTO> insertPersonBadgeInfo(InsertPersonBadgeInfoDTO insertPersonBadgeInfoDTO);

    /**
     * 工牌mac地址和人员解绑
     * @Param: deletePersonBadgeInfo
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.DeletePersonBadgeInfoDTO>
     * @Author: tanglei
     * @Date: 2020/6/30 11:16
     */
    BaseResponse<DeletePersonBadgeInfoDTO> deletePersonBadgeInfo(DeletePersonBadgeInfoDTO deletePersonBadgeInfoDTO);

    /**
     * 工牌mac地址和人员修改
     * @Param: updatePersonBadgeInfo
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.UpdatePersonBadgeInfoDTO>
     * @Author: tanglei
     * @Date: 2020/6/30 11:16
     */
    BaseResponse<UpdatePersonBadgeInfoDTO> updatePersonBadgeInfo(UpdatePersonBadgeInfoDTO updatePersonBadgeInfoDTO);


    /**
     * 查询人员和mac地址所绑定的信息
     * @Param: queryPerBadgeReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<com.ifourthwall.dbm.security.dto.QueryPerBadgeResDTO>>
     * @Author: tanglei
     * @Date: 2020/6/30 14:43
     */
    BaseResponse<List<QueryPerBadgeResDTO>> selectPersonBadgeInfo(QueryPerBadgeReqDTO queryPerBadgeReqDTO);



    /**
     * 分页(根据用户ids和工牌ids)查询人员与工牌绑定的信息
     * @Param: pageBadgeInfoReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.PageBadgeInfoResDTO>
     * @Author: tanglei
     * @Date: 2020/7/10 15:43
     */
    BaseResponse<PageBadgeInfoResDTO> pageBadgeInfos(PageBadgeInfoReqDTO pageBadgeInfoReqDTO);



    /**
     * 分页查询人员与工牌绑定的信息
     * @Param: [pagePerBadgeReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.security.dto.PagePerBadgeResDTO>
     * @Author: tanglei
     * @Date: 2020/6/29 15:54
     */
    BaseResponse<PagePerBadgeResDTO> pagePersonBadgeBindInfos(PagePerBadgeReqDTO pagePerBadgeReqDTO);


    /**
     * 哥斯拉调用修改信标状态
     * @Param: [updateBadgeStatusDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< com.ifourthwall.dbm.perposition.bo.UpdateBadgeStatusDTO>
     * @Author: tanglei
     * @Date: 2020/7/13 17:42
     */
    BaseResponse<UpdateBadgeStatusDTO> updateBadgeStatus(UpdateBadgeStatusDTO updateBadgeStatusDTO);
}
