package com.ifourthwall.dbm.security.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.security.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-06-29 16:04
 * @Description:
 */
public interface GatewaySpaceInfoFacade {

    /**
     * 网关的mac地址和空间的绑定
     * @Param: insertGatewaySpaceDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.InsertGatewaySpaceDTO>
     * @Author: tanglei
     * @Date: 2020/6/29 17:16
     */
    BaseResponse<InsertGatewaySpaceDTO> insertGatewaySpaceInfo(InsertGatewaySpaceDTO insertGatewaySpaceDTO);


    /**
     * 网关的mac地址和空间的解绑
     * @Param: deleteGatewaySpaceDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.DeleteGatewaySpaceDTO>
     * @Author: tanglei
     * @Date: 2020/6/29 17:16
     */
    BaseResponse<DeleteGatewaySpaceDTO> deleteGatewaySpaceInfo(DeleteGatewaySpaceDTO deleteGatewaySpaceDTO);


    /**
     * 网关的mac地址和空间的修改
     * @Param: updateGatewaySpaceDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.UpdateGatewaySpaceDTO>
     * @Author: tanglei
     * @Date: 2020/6/29 17:16
     */
    BaseResponse<UpdateGatewaySpaceDTO> updateGatewaySpaceInfo(UpdateGatewaySpaceDTO updateGatewaySpaceDTO);



    /**
     * 查询网关的mac地址和空间
     * @Param: queryGatewaySpaceReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.dbm.security.dto.QueryGatewaySpaceResDTO>>
     * @Author: tanglei
     * @Date: 2020/6/30 17:16
     */
    BaseResponse<List<QueryGatewaySpaceResDTO>> selectGatewaySpaceInfos(QueryGatewaySpaceReqDTO queryGatewaySpaceReqDTO);


    /**
     * 网关管理分页查询
     * @Param: [pageGatewayInfoReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.PageGatewayInfoResDTO>
     * @Author: tanglei
     * @Date: 2020/7/2 14:54
     */
    BaseResponse<PageGatewayInfoResDTO> pageGatewaySpaceInfo(PageGatewayInfoReqDTO pageGatewayInfoReqDTO);

}
