package com.ifourthwall.dbm.security.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.dbm.security.dto.*;

import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-03-17 11:59
 * @Description:
 */
public interface DeviceSpaceObjectFacade {


    /**
     * 根据项目id和设备id集合查询空间id
     * @Param: [seerUfaceDeviceAlarmReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse< java.util.List<com.ifourthwall.dbm.security.dto.DeviceSpaceObjectDTO>>
     * @Author: tanglei
     * @Date: 2020/8/5 17:25
     */
    BaseResponse<List<DeviceSpaceObjectDTO>> selectDeviceKeyAndSpaceId(SeerUfaceDeviceAlarmReqDTO seerUfaceDeviceAlarmReqDTO);

    /**
     * 设备的创建
     * @Param: [insertDeviceReqDTO]
     * @Return: com.ifourthwall.common.base.BaseResponse<  com.ifourthwall.dbm.security.dto.InsertDeviceReqDTO>>
     * @Author: tanglei
     * @Date: 2020/3/10 10:22
     */
    BaseResponse<InsertDeviceReqDTO> createDevice(InsertDeviceReqDTO insertDeviceReqDTO);

    /**
     * 查询此租户所对应的设备信息和空间id和物件id
     * @Param: queryDeviceReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.DeviceSpaceObjectDTO>
     * @Author: tanglei
     * @Date: 2020/3/11 10:36
     */
    BaseResponse<DeviceSpaceObjectDTO> selectDeviceSpaceIdAndObjectId(QueryDeviceReqDTO queryDeviceReqDTO);

    /**
     * 设备的删除
     * @Param: deleteDeviceDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.DeleteDeviceDTO>
     * @Author: tanglei
     * @Date: 2020/3/11 10:36
     */
    BaseResponse<DeleteDeviceDTO> deleteUfaceDevice(DeleteDeviceDTO deleteDeviceDTO);


    /**
     * 根据租户id和空间id查询租户所对应的设备
     * @Param: queryDeviceKeyReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List< com.ifourthwall.dbm.security.dto.QueryDeviceKeyResDTO>>
     * @Author: tanglei
     * @Date: 2020/4/1 18:27
     */
    BaseResponse<List<QueryDeviceKeyResDTO>> selectDeviceToTeantId(QueryDeviceKeyReqDTO queryDeviceKeyReqDTO);

    /**
     * 根据租户id和项目id查询租户所对应的空间id
     * @Param: queryDeviceKeyReqDTO
     * @Return: com.ifourthwall.common.base.BaseResponse<java.util.List<  com.ifourthwall.dbm.security.dto.QueryDeviceSpIdsResDTO>>
     * @Author: tanglei
     * @Date: 2020/4/1 18:27
     */
    BaseResponse<List<QueryDeviceSpIdsResDTO>> selectDeviceToProject(QueryDeviceSpIdsReqDTO queryDeviceSpIdsReqDTO);
    
    /**
     * 修改空间id
     * @Param: updateDeviceDTO
     * @Return: com.ifourthwall.common.base.BaseResponse
     * @Author: tanglei
     * @Date: 2020/5/9 13:06
     */
    BaseResponse<UpdateDeviceDTO> updateSpaceId(UpdateDeviceDTO updateDeviceDTO);
}
