package com.ifourthwall.dbm.security.facade;

import com.ifourthwall.common.base.BaseResponse;
import com.ifourthwall.common.base.IFWPageInfo;
import com.ifourthwall.dbm.security.dto.*;

import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/3/26 13:48
 * @Description:
 */
public interface CameraFacade {

    /**
     * 新增更新摄像头
     * @Author: YangPeng
     * @Date: 2020/3/26 13:54
     * @param camera
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse upInsertCamera(InsertCameraDTO camera);

    /**
     * 删除摄像头
     * @Author: YangPeng
     * @Date: 2020/3/26 13:54
     * @param camera
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteCamera(DeleteCameraDTO camera);

    /**
     * 查询摄像头列表
     * @Author: YangPeng
     * @Date: 2020/3/26 13:54
     * @param camera
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<IFWPageInfo<QueryCameraListDTO>> queryCameraList(QueryCameraListQuDTO queryList);

    /**
     * seer-摄像头数据统计
     * @Author: YangPeng
     * @Date: 2020/3/26 13:54
     * @param camera
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse<SeerCameraNumberDTO> seerCameraNumber(QueryCameraListQuDTO queryList);

    /**
     * 9/12宫格配置
     * @Author: YangPeng
     * @Date: 2020/4/25 14:45
     * @param position
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse cameraPutPosition(cameraPutPositionQuDTO position);

    /**
     *新增摄像头模板
     * @Author: YangPeng
     * @Date: 2020/4/25 15:39
     * @param cameraTag
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertCameraTag(InsertCameraTagDTO cameraTag);

    /**
     *修改摄像头模板
     * @Author: YangPeng
     * @Date: 2020/4/25 15:39
     * @param cameraTag
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse updateCameraTag(UpdateCameraTagDTO cameraTag);

    /**
     *删除摄像头模板
     * @Author: YangPeng
     * @Date: 2020/4/25 15:39
     * @param cameraTag
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse deleteCameraTag(DeleteCameraTagDTO cameraTag);

    /**
     * 查询appid
     * @Author: YangPeng
     * @Date: 2020/4/28 17:05
     * @param queryAppIdQueryDTO
     * @return com.ifourthwall.dbm.security.bo.QueryAppIdBO
     * @throws
     */
    BaseResponse<QueryAppIdDTO> queryAppId(QueryAppIdQueryDTO queryAppId);

    /**
     * 插入appid
     * @Author: YangPeng
     * @Date: 2020/4/28 17:05
     * @param insertAppIdQuDoBO
     * @return void
     * @throws
     */
    BaseResponse insertAppId(InsertAppIdQuDTO insertAppId);

    /**
     * 查询摄像头告警记录
     *
     * @param map
     * @return com.ifourthwall.common.base.BaseResponse<java.util.List < com.ifourthwall.dbm.security.dto.QueryAlarmRecordDTO>>
     * @throws
     * @Author: YangPeng
     * @Date: 2020/5/6 16:45
     */
    BaseResponse<IFWPageInfo<QueryAlarmRecordDTO>> queryAlarmRecord(QueryAlarmRecordQuDTO map);

    /**
     * 插入记录
     * @Author: YangPeng
     * @Date: 2020/5/6 20:23
     * @param map
     * @return com.ifourthwall.common.base.BaseResponse
     * @throws
     */
    BaseResponse insertRecord(insertRecordDTO map);

    /**
     * 查询所有设备翻译配置
     * @Author: YangPeng
     * @Date: 2020/5/8 17:15
     * @param query
     * @return com.ifourthwall.common.base.BaseResponse<com.ifourthwall.dbm.security.dto.AllTranslationDTO>
     * @throws
     */
    BaseResponse<AllTranslationDTO> allTranslation(TranslationDTO query);
}
