package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotEmpty;

/**
 * @Author: YangPeng
 * @Date: 2020/3/26 13:50
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class UpdateCameraDTO extends BaseReqDTO {

    @ApiModelProperty("摄像头id")
    @NotEmpty(message = "摄像头id不能为空")
    private String cameraId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("空间id")
    private String projectSpaceId;

    @ApiModelProperty("摄像头类型(1:普通，2:智能)")
    private String cameraCategoryId;

    @ApiModelProperty("摄像头名称")
    private String cameraName;

    @ApiModelProperty("摄像头对应模型名称")
    private String modelName;

    @ApiModelProperty("摄像头地址")
    private String cameraUrl;

    @ApiModelProperty("是否收藏（0否，1是）")
    private String isFavorite;

    @ApiModelProperty("9宫格位置")
    private Integer nineSquares;

    @ApiModelProperty("12宫格位置")
    private Integer twelveSquares;

    @ApiModelProperty("数据点")
    private String dataPointId;

    @ApiModelProperty("摄像头对应物件名称")
    private String objectId;



}
