package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;


/**
 * @Author: tanglei
 * @Date: 2020-04-03 14:49
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryTotalPersonResDTO extends BaseReqDTO {
    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("空间名称")
    private String spaceName;

    @ApiModelProperty("识别guid,唯一不重复")
    private String guid;

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("设备名称")
    private String deviceName;

    @ApiModelProperty("人员guid，陌生人为STRANGERBABY，人证比对为IDCARDBABY")
    private String personGuid;

    @ApiModelProperty("现场照url")
    private String photoUrl;

    @ApiModelProperty("识别记录时间,0时区时间,如(2018-11-28T03:06:23+0000)")
    private String showTime;

    @ApiModelProperty("人员比对结果,1:比对成功 2:比对失败")
    private Byte type;

    @ApiModelProperty("识别模式,1:刷脸,2:刷卡,3:脸&卡双重认证, 4:人证比对")
    private Byte recMode;

    @ApiModelProperty("识别卡号")
    private String cardNo;

    @ApiModelProperty(" 活体结果 1:活体判断成功 2:活体判断失败 3:未进行活体判断")
    private Byte aliveType;

    @ApiModelProperty("比对模式,1:本地识别 2:云端识别")
    private Byte recType;

    @ApiModelProperty("人员姓名")
    private String personName;

    @ApiModelProperty("有效时间段判断 1:时间段内 2:时间段外 3:未进行时间段判断")
    private Byte passTimeType;

    @ApiModelProperty("设备类型")
    private String deviceType;

    @ApiModelProperty("有效日期判断 1:有效期内 2:有效期外 3:未进行有效期判断")
    private Byte permissionTimeType;

    @ApiModelProperty("识别模式判断 1. 模式正确 2.模式不正确")
    private String recModeType;

}
