package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

/**
 * @Author: tanglei
 * @Date: 2020-03-10 15:56
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QuerySettingDeviceResDTO extends BaseReqDTO {

    @ApiModelProperty("设备Id")
    private String appId;

    @ApiModelProperty("固定显示参数.大屏背景图片 默认使用设备自带图片(jpg,jpeg,png,mp4)")
    private String bigScrUrl;

    @ApiModelProperty("刷卡识别参数.刷卡模式开关 1:打开(默认) 2:关闭")
    private Integer cardEnable;

    @ApiModelProperty("卡&人脸双重认证.卡&人脸双重认证开关 1:打开2:关闭(默认)")
    private Integer cardFaceEnable;

    @ApiModelProperty("卡&人脸双重认证.外接硬件类型 1:IC读卡器(默认) 2:新中新 3:精伦 4:中控")
    private Integer cardFaceHardware;

    @ApiModelProperty("卡&人脸双重认证.卡号传输接口 1:USB 2:TTL串口(默认) 3:232串口")
    private Integer cardFaceIntf;

    @ApiModelProperty("卡&人脸双重认证.人脸识别阈值 80(默认)")
    private Integer cardFaceScore;

    @ApiModelProperty("刷卡识别参数.外接硬件类型 1:IC读卡器(默认) 2:新中新 3:精伦 4:中控")
    private Integer cardHardware;

    @ApiModelProperty("刷卡识别参数.卡号传输接口 1:USB 2:TTL串口(默认) 3:232串口 Uface设备自带的刷卡模块使用的是TTL串口 USB（或TTL或232）接口只能被一种识别模式使用，若>1种模式使用USB（或TTL或232）则报错")
    private Integer cardIntf;

    @ApiModelProperty("识别通用参数.识别距离 1:无限制 2:0.5以内 3:1米以内(默认) 4:1.5米以内 5:2米以内 6:3米以内 7:4米以内 若识别等级选择2活体，则6、7不可选；若识别等级选择1活体，则1-7均可选。")
    private Integer comRecDistModeType;

    @ApiModelProperty("识别通用参数.识别等级 1:非活体 2:活体(默认)")
    private Integer comRecRank;

    @ApiModelProperty("识别通用参数.时间窗 60秒(默认)")
    private Integer comRecTimeWindow;

    @ApiModelProperty("识别通用参数.继电器控制时间 500ms(默认) 继电器控制开门到关门之间的时间间隔，默认500ms。请输入100-25500之间的整数，向下取整百。如：输入101-199之间的整数，实际生效的是100ms。")
    private Integer comRelayTime;

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("刷脸识别参数.人脸检测类型 1:多人识别(默认) 2:单人识别")
    private Integer faceDetectionType;

    @ApiModelProperty("刷脸识别参数.刷脸模式开关 1:打开(默认) 2:关闭")
    private Integer faceEnable;

    @ApiModelProperty("刷脸识别参数.人脸识别阈值 80(默认) 实际允许0-100之间的所有整数。提示：请输入50-100之间的整数。分数越高，识别准确率越高，但识别速度会变慢。")
    private Integer faceScore ;

    @ApiModelProperty("人证比对参数.人证比对开关 1:打开 2:关闭(默认)")
    private Integer idCardFaceEnable;

    @ApiModelProperty("人证比对参数.外接硬件类型 1:IC读卡器 2:新中新(默认) 3:精伦 4:中控")
    private Integer idCardFaceHardware;

    @ApiModelProperty("人证比对参数.卡号传输接口 1:USB 2:TTL串口 3:232串口(默认)")
    private Integer idCardFaceIntf;

    @ApiModelProperty("人证比对参数.人脸识别阈值 50(默认)")
    private Integer idCardFaceScore;

    @ApiModelProperty("固定显示参数.是否显示设备序列号 true(默认) false")
    private Boolean isShowDeviceKey;

    @ApiModelProperty("固定显示参数.是否显示IP true(默认) false")
    private Boolean isShowIp;

    @ApiModelProperty("固定显示参数.是否显示人数 true(默认) false")
    private Boolean isShowPersonCount;

    @ApiModelProperty("识别失败参数.串口输出自定义内容")
    private String recFailComModeContent;

    @ApiModelProperty("识别失败参数.串口输出类型 1:开门2:不输出(默认) 100:自定义")
    private Integer recFailComModeType;

    @ApiModelProperty("识别失败参数.屏幕显示文字自定义内容 内容只允许数字、中英文和中英文符号，长度限制255个字符。如：注意陌生人！")
    private String recFailDisplayTextContent;

    @ApiModelProperty("识别失败参数.屏幕显示文字类型 1:识别失败(默认) 100:自定义")
    private Integer recFailDisplayTextType;

    @ApiModelProperty("别失败参数.识别失败开关 1:打开(默认) 2:关闭")
    private Integer recFailEnable;

    @ApiModelProperty("识别失败参数.继电器输出类型 1:输出 2:不输出(默认)")
    private Integer recFailRelayType;

    @ApiModelProperty("识别失败参数.判定次数 3(默认) 打开识别失败开关后，该选项有效；连续比对N次都未达到分数阈值，则判定为识别失败，默认3次；传入值请选择1-20之间的整数，1表示快速判定但精确率最低，随着数值增加，判定时间增加，精确度提高")
    private Integer recFailTimesThreshold;

    @ApiModelProperty("识别失败参数.语音播报自定义内容 内容只允许数字、英文和汉字，长度限制255个字符。如：注意陌生人")
    private String recFailTtsModeContent;

    @ApiModelProperty("识别失败参数.语音播类型 1:识别失败(默认) 2:不播放 100:自定义")
    private Integer recFailTtsModeType;

    @ApiModelProperty("识别失败参数.韦根输出自定义内容")
    private String recFailWiegandContent;

    @ApiModelProperty("识别失败参数.韦根输出类型 1:不输出(默认) 2:韦根26 3:韦根34")
    private Integer recFailWiegandType;

    @ApiModelProperty("权限不足参数.串口输出自定义内容")
    private String recNoPerComModeContent;

    @ApiModelProperty("权限不足参数.串口输出类型 1:开门 2:不输出(默认) 3:输出phone 4:输出cardNo 100:自定义")
    private Integer recNoPerComModeType;

    @ApiModelProperty("权限不足参数.屏幕显示文字1自定义内容")
    private String recNoPerDisplayText1Content;

    @ApiModelProperty("权限不足参数.屏幕显示文字1类型 1:姓名(默认) 100:自定义")
    private Integer recNoPerDisplayText1Type;

    @ApiModelProperty("权限不足参数.屏幕显示文字2自定义内容")
    private String recNoPerDisplayText2Content;

    @ApiModelProperty("权限不足参数.屏幕显示文字2类型 1:权限不足(默认) 100:自定义")
    private Integer recNoPerDisplayText2Type;

    @ApiModelProperty("权限不足参数.继电器输出类型 1:输出 2:不输出(默认)")
    private Integer recNoPerRelayType;

    @ApiModelProperty("权限不足参数.语音播报自定义内容 允许{name}、{tag}。字段格式固定，其他内容只允许数字、英文和汉字，长度限制255个字符。如：{name}无权通行")
    private String recNoPerTtsModeContent;

    @ApiModelProperty("权限不足参数.语音播类型 1:播报姓名权限不足(默认) 2:不播放 100:自定义")
    private Integer recNoPerTtsModeType;

    @ApiModelProperty("权限不足参数.韦根输出自定义内容")
    private String recNoPerWiegandContent;

    @ApiModelProperty("权限不足参数.韦根输出类型 1:不输出(默认) 2:韦根26 3:韦根34")
    private Integer recNoPerWiegandType;

    @ApiModelProperty("识别成功参数.串口输出自定义内容")
    private String recSucComModeContent;

    @ApiModelProperty("识别成功参数.串口输出类型 1:开门(默认) 2:不输出 3:输出phone 4:输出cardNo 100:自定义")
    private Integer recSucComModeType;

    @ApiModelProperty("识别成功参数.屏幕显示文字1自定义内容")
    private String recSucDisplayText1Content;

    @ApiModelProperty("识别成功参数.屏幕显示文字1类型 1:姓名(默认) 100:自定义")
    private Integer recSucDisplayText1Type;

    @ApiModelProperty("识别成功参数.屏幕显示文字2自定义内容")
    private String recSucDisplayText2Content;

    @ApiModelProperty("识别成功参数.屏幕显示文字2类型 1:识别成功(默认) 100:自定义")
    private Integer recSucDisplayText2Type;

    @ApiModelProperty("识别成功参数.继电器输出类型 1:输出(默认) 2:不输出")
    private Integer recSucRelayType;

    @ApiModelProperty("识别成功参数.语音播报自定义内容 允许{name}、{tag}。字段格式固定，其他内容只允许数字、英文和汉字，长度限制255个字符。如：{name}欢迎光临")
    private String recSucTtsModeContent;

    @ApiModelProperty("识别成功参数.语音播类型 1:播报名字(默认) 2:不播放 100:自定义")
    private Integer recSucTtsModeType;

    @ApiModelProperty("识别成功参数.韦根输出自定义内容 允许{phone}、{cardNo}。字段格式固定且只能为数字或字母，其他内容只允许数字、英文和英文字符，长度限制255个字符。\n" +
            "串口支持输出韦根信号，设备需要外接串口→韦根信号转换小板，小板由本公司定制。自定义内容传入格式：\n" +
            "韦根26：#26WG{cardNo}#，韦根34：#34WG{cardNo}#\n" +
            "注意：{cardNo}+数字组合后，韦根26范围为1-65535（待定），有效范围为5位；韦根34范围为1-4294967295（待定），有效范围为10位。若超出范围，则输出的信号会进行转换，输出无效信号。")
    private String recSucWiegandContent;

    @ApiModelProperty("识别成功参数.韦根输出类型 1:不输出(默认) 2:韦根26 3:韦根34")
    private Integer recSucWiegandType;

    @ApiModelProperty("固定显示参数.禁用界面图片 默认使用设备自带图片(jpg,jpeg,png,mp4)")
    private String scrDisableUrl;

    @ApiModelProperty("固定显示参数.显示文字内容1自定义内容 长度限制255")
    private String scrDisplayText1Content;

    @ApiModelProperty("固定显示参数.显示文字内容1类型 1:不显示(默认) 2:应用名称 100:自定义")
    private Integer scrDisplayText1Type;

    @ApiModelProperty("固定显示参数.显示文字内容2自定义内容 长度限制255")
    private String scrDisplayText2Content;

    @ApiModelProperty("固定显示参数.显示文字内容2类型 1:不显示2:设备名称(默认)  100:自定义")
    private Integer scrDisplayText2Type;

    @ApiModelProperty("固定显示参数.显示图片1 默认使用设备自带图片(jpg,jpeg,png,mp4)")
    private String scrImage1Url;

    @ApiModelProperty("固定显示参数.显示图片2 默认无图片(jpg,jpeg,png,mp4)")
    private String scrImage2Url;

    @ApiModelProperty("固定显示参数.屏幕方向 1:横屏(默认) 2:竖屏")
    private Integer scrOrntType;

}
