package com.ifourthwall.dbm.security.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-06-29 15:52
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryPerBadgeResDTO implements Serializable {

    @ApiModelProperty("人员信标id")
    private String personBadgeInfoId;

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("信标名称")
    private String badgeName;

    @ApiModelProperty("信标类型 0-手环 1-胸牌  2-卡片")
    private String badgeType;

    @ApiModelProperty("工牌的mac地址")
    private String badgeMacId;

    @ApiModelProperty("网关mac地址")
    private String gatewayMacId;

    @ApiModelProperty("临时工牌的mac地址")
    private String temporaryBadgeMacId;

    @ApiModelProperty("真实姓名")
    private String realName;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("信标状态 0-在线  1-离线")
    private String badgeStatus;

    @ApiModelProperty("定位时间")
    private Date positionTime;


}
