package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-03-02 16:55
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryDeviceResDTO extends BaseReqDTO {

    @ApiModelProperty("设备所属应用id")
    private String appId;

    @ApiModelProperty("创建的时间")
    private Date createTime;

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("设备最后活跃时间")
    private Date lastActiveTime;

    @ApiModelProperty("设备名称")
    private String name;

    @ApiModelProperty("设备在线状态 1:在线  2:不在线")
    private Byte onlineState;

    @ApiModelProperty("识别方式 1:本地识别 2:云端比对")
    private Byte recType;

    @ApiModelProperty("设备状态 1:未绑定 2:已绑定 3:已禁用")
    private Byte state;

    @ApiModelProperty("设备备注,开发者自动以传入")
    private String tag;

    @ApiModelProperty("设备类型 1:1diamante 2:2代 3:3代 6:c 10:2c")
    private Byte type;

    @ApiModelProperty("设备应用版本号")
    private String versionNo;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("物件id")
    private String objectId;

    @ApiModelProperty("空间名称")
    private String spaceName;


}
