package com.ifourthwall.dbm.security.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @Author: YangPeng
 * @Date: 2020/3/26 15:46
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryCameraListDTO implements Serializable {

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("摄像头id")
    private String cameraId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("空间id")
    private String projectSpaceId;

    @ApiModelProperty("空间id")
    private String projectSpaceName;

    @ApiModelProperty("摄像头类型(1:普通，2:智能)")
    private String cameraCategoryId;

    @ApiModelProperty("摄像头类型(1:普通，2:智能)")
    private String cameraCategoryName;

    @ApiModelProperty("摄像头名称")
    private String cameraName;

    @ApiModelProperty("摄像头地址")
    private String cameraUrl;

    @ApiModelProperty("是否收藏（0否，1是）")
    private String isFavorite;

    @ApiModelProperty("摄像头对应物件名称")
    private String objectId;

    @ApiModelProperty("数据点（哥斯拉）")
    private String dataPointId;
}
