package com.ifourthwall.dbm.security.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @Author: YangPeng
 * @Date: 2020/5/6 16:16
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QueryAlarmRecordQuBasisDTO extends PageCommonExTDTO {

    @NotNull(message = "开始时间不能为空")
    private Date startTime;

    @NotNull(message = "结束时间不能为空")
    private Date endTime;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("摄像头id")
    private List<String> cameraIds;

    @ApiModelProperty("1 查询该空间下的子空间 默认不查")
    private String type;
}
