package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.CacheKeyDecorator;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Author: tanglei
 * @Date: 2020-07-03 14:12
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class QuUserInfoResDTO implements Serializable {

    @ApiModelProperty("租户id")
    private String tenantId;

    @ApiModelProperty("用户id")
    private String userId;

    @ApiModelProperty("真实姓名")
    private String realName;

    @ApiModelProperty("手机号")
    private String phone;

    @ApiModelProperty("岗位")
    private List<QuPositionInfoResDTO> positionInfos;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("空间名称")
    private String spaceName;

    @ApiModelProperty("信标名称")
    private String badgeName;

    @ApiModelProperty("信标类型 0-手环 1-胸牌  2-卡片")
    private String badgeType;

    @ApiModelProperty("工牌的mac地址")
    private String badgeMacId;

    @ApiModelProperty("监测状态 0-在线 1-离线")
    private String badgeStatus;

    @ApiModelProperty("定位时间")
    private Date positionTime;


}
