package com.ifourthwall.dbm.security.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: tanglei
 * @Date: 2020-03-13 16:12
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PersonCookieReqDTO extends BaseReqDTO {

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("1:本地库 2:云端库")
    private Byte type;

    @ApiModelProperty("权限有效期 格式为毫秒值时间戳,时间区间使用,拼接")
    private String permissionTime;

    @ApiModelProperty("通过时间")
    private String passTime;

    @ApiModelProperty("人员Guid,用\",\"拼接")
    @NotNull(message = "门禁人员id不能为空")
    private String personGuids;

    @ApiModelProperty("人员权限 刷脸权限 1：无权限；2：有权限")
    private Integer facePermission;

    @ApiModelProperty("人员权限 刷卡权限 1：无权限；2：有权限")
    private Integer idCardPermission;

    @ApiModelProperty("人员权限 人卡合一权限 1：无权限；2：有权限")
    private Integer faceAndCardPermission;

    @ApiModelProperty("人员权限 人证比对权限 1：无权限；2：有权限")
    private Integer idCardFacePermission;



}
