package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.PlatformCodeConstants;
import com.ifourthwall.common.PlatformCodeEnum;
import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;

/**
 * @Author: tanglei
 * @Date: 2020-07-03 14:09
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PageUserInfoBadgeReqDTO extends BaseReqDTO {

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数")
    private Integer pageSize;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("真实姓名")
    private String employeeName;

    @ApiModelProperty("信标状态 0-在线  1-离线")
    private String badgeStatus;

    @ApiModelProperty("项目id")
    @NotNull(message = PlatformCodeConstants.PROJECT_ID_CANNOT_NULL)
    private String projectId;

}
