package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author: tanglei
 * @Date: 2020-04-08 11:50
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PageStaDeviceRecordReqDTO extends BaseReqDTO {

    @ApiModelProperty("设备序列号")
    private String deviceKey;

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("空间id")
    private String spaceId;

    @ApiModelProperty("人员姓名")
    private String personName;

    @ApiModelProperty("比对结果,1:比对成功 2:比对失败")
    private String type;

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数 最多50")
    private Integer pageSize;

    @ApiModelProperty("开始时间")
    private String startTime;

    @ApiModelProperty("结束时间")
    private String endTime;


}
