package com.ifourthwall.dbm.security.dto;

import com.ifourthwall.common.base.BaseReqDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @Author: tanglei
 * @Date: 2020-03-16 11:08
 * @Description:
 */
@Data
@ToString(callSuper = true)
public class PagePersonsAuthorizationReqDTO extends BaseReqDTO {

    @ApiModelProperty("项目id")
    private String projectId;

    @ApiModelProperty("页码")
    private Integer pageNum;

    @ApiModelProperty("每页个数 最多50")
    private Integer pageSize;

    @ApiModelProperty("人员id")
    private String personGuid;

    @ApiModelProperty("人员姓名")
    private String personName;

    @ApiModelProperty("1:本地库 2:云端库")
    private Byte type;

    @ApiModelProperty("设备类型 1:1代 2:2代 3:3代 6:C 10:2C")
    private Byte deviceType;

    @ApiModelProperty("设备类型序列号")
    private String deviceKey;

    @ApiModelProperty("设备名称")
    private String deviceName;

    @ApiModelProperty("查询时间区间开始(UTC时间/毫秒值),如2018-08-08T08:18:28+0000或1542793088000")
    private String startTime;

    @ApiModelProperty("查询时间区间结束(UTC时间/毫秒值),如2018-08-08T08:18:28+0000或1542793088000\n" +
            "返回数据:")
    private String endTime;



}
